/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2RetryingTCPChannel;
import com.mindbright.ssh2.SSH2StreamFilterFactory;
import com.mindbright.ssh2.SSH2TCPChannel;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public final class SSH2Listener
implements Runnable {
    private static final int LISTEN_QUEUE_SIZE = 32;
    SSH2Connection connection;
    SSH2StreamFilterFactory filterFactory;
    private int acceptTimeout;
    private boolean isLocalForward;
    private int channelType;
    private String localAddr;
    private int localPort;
    private String remoteAddr;
    private int remotePort;
    private ServerSocket listenSocket;
    private int acceptCount;
    private int acceptMax;
    private volatile int numOfRetries;
    private long retryDelayTime;
    private volatile boolean keepListening;
    private Thread myThread;

    public SSH2Listener(String string, int n, String string2, int n2, SSH2Connection sSH2Connection, SSH2StreamFilterFactory sSH2StreamFilterFactory, int n3) throws IOException {
        this.localAddr = string;
        this.localPort = n;
        this.remoteAddr = string2;
        this.remotePort = n2;
        this.connection = sSH2Connection;
        this.filterFactory = sSH2StreamFilterFactory;
        this.keepListening = true;
        this.acceptCount = 0;
        this.acceptMax = 0;
        this.acceptTimeout = n3;
        this.numOfRetries = 0;
        this.listenSocket = new ServerSocket(n, 32, InetAddress.getByName(string));
        if (this.acceptTimeout != 0) {
            this.listenSocket.setSoTimeout(this.acceptTimeout);
        }
        if (n == 0) {
            this.localPort = this.listenSocket.getLocalPort();
            sSH2Connection.getLog().debug("SSH2Listener", "we got assigned port " + this.localPort);
        }
        this.isLocalForward = string2 != null;
        this.channelType = this.isLocalForward ? 1 : 0;
        this.myThread = new Thread((Runnable)this, "SSH2Listener_" + string + ":" + this.localPort);
        this.myThread.setDaemon(true);
        this.myThread.start();
    }

    public SSH2Listener(String string, int n, String string2, int n2, SSH2Connection sSH2Connection, SSH2StreamFilterFactory sSH2StreamFilterFactory) throws IOException {
        this(string, n, string2, n2, sSH2Connection, sSH2StreamFilterFactory, 0);
    }

    public SSH2Listener(String string, int n, SSH2Connection sSH2Connection) throws IOException {
        this(string, n, null, -1, sSH2Connection, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block21: {
            this.connection.getLog().debug("SSH2Listener", "starting listener on " + this.localAddr + ":" + this.localPort);
            while (this.keepListening) {
                Socket socket = null;
                try {
                    socket = this.listenSocket.accept();
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.keepListening) continue;
                }
                if (!this.keepListening) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                socket.setSoTimeout(1000);
                if (this.connection.getEventHandler().listenerAccept(this, socket)) {
                    this.doConnect(socket);
                }
                ++this.acceptCount;
                SSH2Listener sSH2Listener = this;
                synchronized (sSH2Listener) {
                    if (this.acceptCount == this.acceptMax) {
                        this.keepListening = false;
                    }
                }
            }
            Object var5_7 = null;
            try {
                this.listenSocket.close();
                this.keepListening = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.listenSocket = null;
            this.connection.getLog().debug("SSH2Listener", "stopping listener on " + this.localAddr + ":" + this.localPort);
            {
                break block21;
                catch (IOException iOException) {
                    if (this.keepListening) {
                        this.connection.getLog().error("SSH2Listener", "run", "Error in accept for listener " + this.localAddr + ":" + this.localPort + " : " + iOException.getMessage());
                    }
                    Object var5_8 = null;
                    try {
                        this.listenSocket.close();
                        this.keepListening = false;
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    this.listenSocket = null;
                    this.connection.getLog().debug("SSH2Listener", "stopping listener on " + this.localAddr + ":" + this.localPort);
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                try {
                    this.listenSocket.close();
                    this.keepListening = false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.listenSocket = null;
                this.connection.getLog().debug("SSH2Listener", "stopping listener on " + this.localAddr + ":" + this.localPort);
                throw throwable;
            }
        }
    }

    public void doConnect(Socket socket) {
        InetAddress inetAddress = socket.getInetAddress();
        int n = socket.getPort();
        try {
            SSH2TCPChannel sSH2TCPChannel = null;
            if (this.numOfRetries > 0) {
                SSH2RetryingTCPChannel sSH2RetryingTCPChannel = new SSH2RetryingTCPChannel(this.channelType, this.connection, this, socket, this.remoteAddr, this.remotePort, inetAddress.getHostName(), n);
                sSH2RetryingTCPChannel.setRetries(this.numOfRetries);
                if (this.retryDelayTime > 0L) {
                    sSH2RetryingTCPChannel.setRetryDelay(this.retryDelayTime);
                }
                sSH2TCPChannel = sSH2RetryingTCPChannel;
            } else {
                sSH2TCPChannel = new SSH2TCPChannel(this.channelType, this.connection, this, socket, this.remoteAddr, this.remotePort, inetAddress.getHostName(), n);
            }
            this.connection.getLog().notice("SSH2Listener", "connect from: " + inetAddress.getHostAddress() + ":" + n + " on " + this.localAddr + ":" + this.localPort + ", new ch. #" + sSH2TCPChannel.getChannelId());
            this.connection.setSocketOptions("local." + this.localAddr + "." + this.localPort, socket);
            this.connection.getEventHandler().channelConnect(this, sSH2TCPChannel, socket);
            if (this.filterFactory != null) {
                sSH2TCPChannel.applyFilter(this.filterFactory.createFilter(this.connection, sSH2TCPChannel));
            }
            this.sendChannelOpen(sSH2TCPChannel, socket);
        }
        catch (IOException iOException) {
            this.connection.getLog().error("SSH2Listener", "doConnect", "Error in  " + this.localAddr + ":" + this.localPort + " : " + iOException.getMessage());
        }
    }

    public void sendChannelOpen(SSH2TCPChannel sSH2TCPChannel, Socket socket) {
        int n;
        String string;
        String string2 = socket.getInetAddress().getHostAddress();
        int n2 = socket.getPort();
        if (this.isLocalForward) {
            string = this.remoteAddr;
            n = this.remotePort;
        } else {
            string = this.localAddr;
            n = this.localPort;
        }
        this.connection.connectLocalChannel(sSH2TCPChannel, string, n, string2, n2);
    }

    public SSH2Connection getConnection() {
        return this.connection;
    }

    public synchronized void setAcceptMax(int n) {
        this.acceptMax = n;
    }

    public void setRetries(int n) {
        this.numOfRetries = n;
    }

    public void setRetryDelay(long l) {
        this.retryDelayTime = l;
    }

    public void setThreadPriority(int n) {
        this.myThread.setPriority(n);
    }

    public int getListenPort() {
        return this.localPort;
    }

    public String getListenHost() {
        return this.listenSocket.getInetAddress().getHostAddress();
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getRemoteHost() {
        return this.remoteAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.listenSocket != null && this.keepListening) {
            this.keepListening = false;
            Socket socket = null;
            try {
                String string = this.listenSocket.getInetAddress().getHostAddress();
                if (string.equals("0.0.0.0")) {
                    string = InetAddress.getLocalHost().getHostAddress();
                }
                socket = new Socket(string, this.localPort);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

