/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.KeyFactory;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.interfaces.RSAPublicKey;
import com.mindbright.jca.security.spec.RSAPublicKeySpec;
import com.mindbright.ssh2.SSH2DataBuffer;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2SimpleSignature;
import java.math.BigInteger;

public final class SSH2RSA
extends SSH2SimpleSignature {
    public static final String SSH2_KEY_FORMAT = "ssh-rsa";

    public SSH2RSA() {
        super("SHA1withRSA", SSH2_KEY_FORMAT);
    }

    public byte[] encodePublicKey(PublicKey publicKey) throws SSH2Exception {
        SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(8192);
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new SSH2FatalException("SSH2RSA, invalid public key type: " + publicKey);
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        sSH2DataBuffer.writeString(SSH2_KEY_FORMAT);
        sSH2DataBuffer.writeBigInt(rSAPublicKey.getPublicExponent());
        sSH2DataBuffer.writeBigInt(rSAPublicKey.getModulus());
        return sSH2DataBuffer.readRestRaw();
    }

    public PublicKey decodePublicKey(byte[] byArray) throws SSH2Exception {
        SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(byArray.length);
        sSH2DataBuffer.writeRaw(byArray);
        String string = sSH2DataBuffer.readJavaString();
        if (!string.equals(SSH2_KEY_FORMAT)) {
            throw new SSH2FatalException("SSH2RSA, keyblob type mismatch, got '" + string + ", (execpted + '" + SSH2_KEY_FORMAT + "')");
        }
        BigInteger bigInteger = sSH2DataBuffer.readBigInt();
        BigInteger bigInteger2 = sSH2DataBuffer.readBigInt();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger2, bigInteger);
            return keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new SSH2FatalException("SSH2RSA, error decoding public key blob: " + exception);
        }
    }
}

