/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.PrivateKey;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.Signature;
import com.mindbright.jca.security.SignatureException;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2PKISigner;
import com.mindbright.ssh2.SSH2SignatureException;
import com.mindbright.ssh2.SSH2Transport;
import java.util.Hashtable;

public abstract class SSH2Signature
implements SSH2PKISigner {
    private static Hashtable algorithms = new Hashtable();
    protected String algorithm;
    protected Signature signature;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected byte[] pubKeyBlob;

    public static SSH2Signature getInstance(String string) throws SSH2Exception {
        SSH2Signature sSH2Signature = SSH2Signature.getEncodingInstance(string);
        sSH2Signature.init(string);
        return sSH2Signature;
    }

    public static SSH2Signature getEncodingInstance(String string) throws SSH2Exception {
        SSH2Signature sSH2Signature = null;
        String string2 = (String)algorithms.get(string);
        try {
            sSH2Signature = (SSH2Signature)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            throw new SSH2FatalException("Public key algorithm '" + string + "' not supported");
        }
        return sSH2Signature;
    }

    private void init(String string) throws SSH2Exception {
        this.algorithm = string;
        String string2 = this.getSignatureAlgorithm();
        try {
            this.signature = Signature.getInstance(string2);
        }
        catch (Exception exception) {
            throw new SSH2FatalException("Error initializing SSH2Signature: " + string + "/" + string2 + " - " + exception);
        }
    }

    protected SSH2Signature() {
    }

    public final String getAlgorithmName() {
        return this.algorithm;
    }

    public final byte[] getPublicKeyBlob() throws SSH2SignatureException {
        if (this.pubKeyBlob == null) {
            try {
                this.pubKeyBlob = this.encodePublicKey(this.publicKey);
            }
            catch (SSH2Exception sSH2Exception) {
                throw new SSH2SignatureException(sSH2Exception.getMessage());
            }
        }
        return this.pubKeyBlob;
    }

    public final PublicKey getPublicKey() throws SSH2SignatureException {
        if (this.publicKey == null) {
            try {
                this.publicKey = this.decodePublicKey(this.pubKeyBlob);
            }
            catch (SSH2Exception sSH2Exception) {
                throw new SSH2SignatureException(sSH2Exception.getMessage());
            }
        }
        return this.publicKey;
    }

    public final void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setIncompatibility(SSH2Transport sSH2Transport) {
    }

    public final void initSign(PrivateKey privateKey) throws SSH2Exception {
        this.privateKey = privateKey;
        try {
            this.signature.initSign(privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SSH2FatalException("SSH2Signature.initSign, invalid key: " + invalidKeyException.getMessage());
        }
    }

    public final void initVerify(PublicKey publicKey) throws SSH2Exception {
        this.initVerify(this.encodePublicKey(publicKey));
    }

    public final void initVerify(byte[] byArray) throws SSH2Exception {
        this.pubKeyBlob = byArray;
        this.publicKey = this.decodePublicKey(byArray);
        try {
            this.signature.initVerify(this.publicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SSH2FatalException("SSH2Signature.initVerify, invalid key: " + invalidKeyException.getMessage());
        }
    }

    public final byte[] sign(byte[] byArray) throws SSH2SignatureException {
        try {
            this.signature.update(byArray);
            byte[] byArray2 = this.signature.sign();
            return this.encodeSignature(byArray2);
        }
        catch (SignatureException signatureException) {
            throw new SSH2SignatureException("Error in " + this.algorithm + " sign: " + signatureException.getMessage());
        }
    }

    public final boolean verify(byte[] byArray, byte[] byArray2) throws SSH2SignatureException {
        try {
            byte[] byArray3 = this.decodeSignature(byArray);
            this.signature.update(byArray2);
            return this.signature.verify(byArray3);
        }
        catch (SignatureException signatureException) {
            throw new SSH2SignatureException("Error in " + this.algorithm + " verify: " + signatureException.getMessage());
        }
    }

    protected abstract String getSignatureAlgorithm();

    protected abstract byte[] encodePublicKey(PublicKey var1) throws SSH2Exception;

    protected abstract PublicKey decodePublicKey(byte[] var1) throws SSH2Exception;

    protected abstract byte[] encodeSignature(byte[] var1);

    protected abstract byte[] decodeSignature(byte[] var1) throws SSH2SignatureException;

    public void clearSensitiveData() {
        this.signature = null;
    }

    static {
        algorithms.put("ssh-dss", "com.mindbright.ssh2.SSH2DSS");
        algorithms.put("ssh-rsa", "com.mindbright.ssh2.SSH2RSA");
    }
}

