/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2AuthHostBased;
import com.mindbright.ssh2.SSH2AuthKbdInteract;
import com.mindbright.ssh2.SSH2AuthModule;
import com.mindbright.ssh2.SSH2AuthPassword;
import com.mindbright.ssh2.SSH2AuthPublicKey;
import com.mindbright.ssh2.SSH2Authenticator;
import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2Interactor;
import com.mindbright.ssh2.SSH2KeyPairFile;
import com.mindbright.ssh2.SSH2Signature;
import com.mindbright.ssh2.SSH2Transport;
import com.mindbright.ssh2.SSH2UserAuth;
import java.io.IOException;

public class SSH2SimpleClient {
    protected SSH2Transport transport;
    protected SSH2Connection connection;
    protected SSH2UserAuth userAuth;

    public SSH2SimpleClient(SSH2Transport sSH2Transport, String string, String string2, long l) throws SSH2Exception {
        this.init(sSH2Transport, string, new SSH2AuthPassword(string2), l);
    }

    public SSH2SimpleClient(SSH2Transport sSH2Transport, String string, String string2) throws SSH2Exception {
        this.init(sSH2Transport, string, new SSH2AuthPassword(string2), 0L);
    }

    public SSH2SimpleClient(SSH2Transport sSH2Transport, String string, String string2, String string3) throws SSH2Exception, IOException {
        this(sSH2Transport, false, string, string2, string3, 0L);
    }

    public SSH2SimpleClient(SSH2Transport sSH2Transport, String string, String string2, String string3, long l) throws SSH2Exception, IOException {
        this(sSH2Transport, false, string, string2, string3, 0L);
    }

    public SSH2SimpleClient(SSH2Transport sSH2Transport, boolean bl, String string, String string2, String string3) throws SSH2Exception, IOException {
        this(sSH2Transport, bl, string, string2, string3, 0L);
    }

    public SSH2SimpleClient(SSH2Transport sSH2Transport, boolean bl, String string, String string2, String string3, long l) throws SSH2Exception, IOException {
        SSH2KeyPairFile sSH2KeyPairFile = new SSH2KeyPairFile();
        sSH2KeyPairFile.load(string2, string3);
        String string4 = sSH2KeyPairFile.getAlgorithmName();
        SSH2Signature sSH2Signature = SSH2Signature.getInstance(string4);
        sSH2Signature.initSign(sSH2KeyPairFile.getKeyPair().getPrivate());
        sSH2Signature.setPublicKey(sSH2KeyPairFile.getKeyPair().getPublic());
        SSH2AuthModule sSH2AuthModule = bl ? new SSH2AuthHostBased(sSH2Signature) : new SSH2AuthPublicKey(sSH2Signature);
        this.init(sSH2Transport, string, sSH2AuthModule, l);
    }

    public SSH2SimpleClient(SSH2Transport sSH2Transport, String string, SSH2Interactor sSH2Interactor, long l) throws SSH2Exception {
        this.init(sSH2Transport, string, new SSH2AuthKbdInteract(sSH2Interactor), l);
    }

    public SSH2SimpleClient(SSH2Transport sSH2Transport, String string, SSH2Interactor sSH2Interactor) throws SSH2Exception {
        this.init(sSH2Transport, string, new SSH2AuthKbdInteract(sSH2Interactor), 0L);
    }

    public SSH2SimpleClient(SSH2Transport sSH2Transport, SSH2Authenticator sSH2Authenticator) throws SSH2Exception {
        this.init(sSH2Transport, sSH2Authenticator, 0L);
    }

    public SSH2SimpleClient(SSH2Transport sSH2Transport, SSH2Authenticator sSH2Authenticator, long l) throws SSH2Exception {
        this.init(sSH2Transport, sSH2Authenticator, l);
    }

    private void init(SSH2Transport sSH2Transport, String string, SSH2AuthModule sSH2AuthModule, long l) throws SSH2Exception {
        SSH2Authenticator sSH2Authenticator = new SSH2Authenticator(string);
        sSH2Authenticator.addModule(sSH2AuthModule);
        this.init(sSH2Transport, sSH2Authenticator, l);
    }

    private void init(SSH2Transport sSH2Transport, SSH2Authenticator sSH2Authenticator, long l) throws SSH2Exception {
        this.transport = sSH2Transport;
        sSH2Transport.boot();
        if (!sSH2Transport.waitForKEXComplete()) {
            throw new SSH2FatalException("Key exchange failed: " + sSH2Transport.getDisconnectMessage());
        }
        this.userAuth = new SSH2UserAuth(sSH2Transport, sSH2Authenticator);
        if (!this.userAuth.authenticateUser("ssh-connection", l)) {
            throw new SSH2FatalException("Permission denied");
        }
        this.connection = new SSH2Connection(this.userAuth, sSH2Transport);
        sSH2Transport.setConnection(this.connection);
        sSH2Authenticator.clearSensitiveData();
        int n = sSH2Transport.getOurPreferences().getIntPreference("alive");
        sSH2Transport.enableKeepAlive(n);
    }

    public SSH2Transport getTransport() {
        return this.transport;
    }

    public SSH2Connection getConnection() {
        return this.connection;
    }
}

