/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Channel;
import com.mindbright.ssh2.SSH2ChannelCloseListener;
import com.mindbright.ssh2.SSH2SessionChannel;
import com.mindbright.ssh2.SSH2TerminalAdapter;
import com.mindbright.terminal.TerminalInputChaff;
import com.mindbright.terminal.TerminalWindow;
import java.io.IOException;
import java.io.OutputStream;

public class SSH2TerminalAdapterImpl
extends TerminalInputChaff
implements SSH2TerminalAdapter,
SSH2ChannelCloseListener {
    private TerminalWindow terminal;
    private SSH2SessionChannel session;
    private TerminalOutStream stdout;
    private boolean minimumLatency;

    public SSH2TerminalAdapterImpl(TerminalWindow terminalWindow) {
        this.terminal = terminalWindow;
        this.stdout = new TerminalOutStream();
    }

    public TerminalWindow getTerminal() {
        return this.terminal;
    }

    public void attach(SSH2SessionChannel sSH2SessionChannel) {
        this.session = sSH2SessionChannel;
        this.minimumLatency = "true".equals(sSH2SessionChannel.getConnection().getPreferences().getPreference("term-min-lat"));
        sSH2SessionChannel.changeStdOut(this.stdout);
        this.terminal.addInputListener(this);
    }

    public void detach() {
        if (this.terminal != null) {
            this.terminal.removeInputListener(this);
        }
    }

    public void startChaff() {
        this.session.addCloseListener(this);
        super.startChaff();
    }

    public void stopChaff() {
        super.stopChaff();
        this.session.removeCloseListener(this);
        this.session.changeStdOut(null);
        this.terminal = null;
        this.session = null;
        this.stdout = null;
    }

    public void closed(SSH2Channel sSH2Channel) {
        this.stopChaff();
    }

    protected void sendTypedChar(int n) {
        if (this.minimumLatency) {
            this.session.stdinWriteNoLatency(n);
        } else {
            try {
                this.session.getStdIn().write(n);
            }
            catch (IOException iOException) {
                this.session.getConnection().getLog().error("SSH2TerminalAdapterImpl", "typedChar", "error writing to stdin: " + iOException.getMessage());
            }
        }
    }

    protected void sendFakeChar() {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5};
        this.session.getConnection().getTransport().sendIgnore(byArray);
    }

    public void sendBytes(byte[] byArray) {
        try {
            this.session.getStdIn().write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            this.session.getConnection().getLog().error("SSH2TerminalAdapterImpl", "sendBytes", "error writing to stdin: " + iOException.getMessage());
        }
    }

    public void signalWindowChanged(int n, int n2, int n3, int n4) {
        this.session.sendWindowChange(n, n2);
    }

    public void sendBreak() {
        if (!this.session.doBreak(500)) {
            this.session.getConnection().getLog().error("SSH2TerminalAdapterImpl", "sendBreak", "Failed to send break");
        }
    }

    final class TerminalOutStream
    extends OutputStream {
        TerminalOutStream() {
        }

        public void write(int n) throws IOException {
            SSH2TerminalAdapterImpl.this.terminal.write((char)n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            SSH2TerminalAdapterImpl.this.terminal.write(byArray, n, n2);
        }
    }
}

