/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jce.crypto.Cipher;
import com.mindbright.jce.crypto.Mac;
import com.mindbright.jce.crypto.ShortBufferException;
import com.mindbright.jce.crypto.spec.IvParameterSpec;
import com.mindbright.jce.crypto.spec.SecretKeySpec;
import com.mindbright.ssh2.SSH2;
import com.mindbright.ssh2.SSH2CompressionException;
import com.mindbright.ssh2.SSH2Compressor;
import com.mindbright.ssh2.SSH2ConnectException;
import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2CorruptPacketException;
import com.mindbright.ssh2.SSH2DataBuffer;
import com.mindbright.ssh2.SSH2EOFException;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2KeyExchanger;
import com.mindbright.ssh2.SSH2ListUtil;
import com.mindbright.ssh2.SSH2MacCheckException;
import com.mindbright.ssh2.SSH2Preferences;
import com.mindbright.ssh2.SSH2Signature;
import com.mindbright.ssh2.SSH2SignatureException;
import com.mindbright.ssh2.SSH2TransportEventAdapter;
import com.mindbright.ssh2.SSH2TransportEventHandler;
import com.mindbright.ssh2.SSH2TransportPDU;
import com.mindbright.ssh2.SSH2TransportPDUPool;
import com.mindbright.ssh2.SSH2UserAuth;
import com.mindbright.util.Log;
import com.mindbright.util.Queue;
import com.mindbright.util.SecureRandomAndPad;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SSH2Transport {
    private static final boolean DEBUG_ALL_TX = false;
    private static final boolean DEBUG_ALL_RX = false;
    private boolean weAreAServer;
    private String clientVersion;
    private String serverVersion;
    protected SSH2Preferences ourPrefs;
    protected SSH2Preferences peerPrefs;
    protected SSH2TransportEventHandler eventHandler;
    private SSH2KeyExchanger keyExchanger;
    private volatile SSH2UserAuth userAuth;
    private volatile SSH2Connection connection;
    private boolean authenticated = false;
    protected Log tpLog;
    protected Socket tpSocket;
    protected InputStream tpIn;
    protected OutputStream tpOut;
    private Thread transmitter;
    private Thread receiver;
    private Queue txQueue;
    protected SecureRandomAndPad tpRand;
    private KeepAliveThread heartbeat;
    private byte[] sessionId;
    private volatile boolean keyExchangeInProgress;
    private boolean keyExchangeOk;
    private Object keyExchangeMonitor;
    private SSH2TransportPDU clientKEXINITPkt;
    private SSH2TransportPDU serverKEXINITPkt;
    private byte[] serverPublicKeyBlob;
    private TranceiverContext rxContext;
    private TranceiverContext txContext;
    private int rxSeqNum;
    private int txSeqNum;
    private int rxNumPacketsSinceKEX;
    private int txNumPacketsSinceKEX;
    private int rxNumBlocksSinceKEX;
    private int txNumBlocksSinceKEX;
    private static final int PACKETS_BEFORE_REKEY = Integer.MAX_VALUE;
    private long blocks_before_rekey = 0x40000000L;
    private Object disconnectMonitor = new Object();
    private volatile boolean isConnected = false;
    private volatile boolean isTxUp = false;
    private volatile boolean isRxUp = false;
    private String disconnectMessage;
    protected boolean activity;
    public boolean incompatibleSignature;
    public boolean incompatiblePublicKeyAuth;
    public boolean incompatibleHMACKeyLength;
    public boolean incompatiblePublicKeyUserId;
    public boolean incompatibleChannelOpenFail;
    public boolean incompatibleRijndael;
    public boolean incompatibleCantReKey;
    public boolean incompatibleBuggyChannelClose;
    public boolean incompatibleMayReceiveDataAfterClose;
    public boolean incompatibleOldDHGex;

    public SSH2Transport(Socket socket, SecureRandomAndPad secureRandomAndPad) {
        this(socket, new SSH2Preferences(), secureRandomAndPad);
    }

    public SSH2Transport(Socket socket, SSH2Preferences sSH2Preferences, SecureRandomAndPad secureRandomAndPad) {
        this(socket, sSH2Preferences, null, secureRandomAndPad);
    }

    public SSH2Transport(Socket socket, SSH2Preferences sSH2Preferences, SSH2TransportEventHandler sSH2TransportEventHandler, SecureRandomAndPad secureRandomAndPad) {
        this(socket, sSH2Preferences, sSH2TransportEventHandler, secureRandomAndPad, new Log(sSH2Preferences.getIntPreference("log-level")));
        String string = sSH2Preferences.getPreference("log-file");
        if (string != null) {
            try {
                boolean bl = "true".equals(sSH2Preferences.getPreference("log-append"));
                FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
                this.tpLog.setLogOutputStream(fileOutputStream);
            }
            catch (IOException iOException) {
                this.tpLog.error("SSH2Transport", "<init>", "could't open log file: " + iOException.getMessage());
            }
        }
    }

    public SSH2Transport(Socket socket, SSH2Preferences sSH2Preferences, SSH2TransportEventHandler sSH2TransportEventHandler, SecureRandomAndPad secureRandomAndPad, Log log) {
        this.keyExchangeMonitor = new Object();
        this.ourPrefs = sSH2Preferences;
        this.eventHandler = sSH2TransportEventHandler != null ? sSH2TransportEventHandler : new SSH2TransportEventAdapter();
        this.tpSocket = socket;
        this.tpRand = secureRandomAndPad;
        this.tpLog = log;
        SSH2TransportPDU.pktDefaultSize = this.ourPrefs.getIntPreference("default-pkt-sz");
        SSH2TransportPDUPool.POOL_SIZE = this.ourPrefs.getIntPreference("pkt-pool-sz");
        try {
            this.setSocketOptions("transport", socket);
            this.rxContext = SSH2TransportPDU.createTranceiverContext("none", "none", "none");
            this.txContext = SSH2TransportPDU.createTranceiverContext("none", "none", "none");
            this.tpIn = socket.getInputStream();
            this.tpOut = socket.getOutputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void boot() throws SSH2Exception {
        this.boot(this.ourPrefs.getIntPreference("hello-timeout") * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot(int n) throws SSH2Exception {
        Object object = this.disconnectMonitor;
        synchronized (object) {
            if (this.isConnected) {
                throw new SSH2FatalException("Already booted");
            }
            this.isConnected = true;
        }
        try {
            int n2 = this.tpSocket.getSoTimeout();
            if (n >= 0) {
                this.tpSocket.setSoTimeout(n);
            }
            this.negotiateVersion();
            if (n >= 0) {
                this.tpSocket.setSoTimeout(n2);
            }
        }
        catch (IOException iOException) {
            throw new SSH2FatalException("I/O error in version negotiation", iOException);
        }
        this.transmitter = new Thread(new Runnable(){

            public void run() {
                SSH2Transport.this.transportTransmitLoop();
            }
        }, "SSH2TransportTX");
        this.txQueue = new Queue(this.ourPrefs.getIntPreference("queue-depth"), this.ourPrefs.getIntPreference("queue-hiwater"));
        this.transmitter.start();
        this.startKeyExchange();
        this.receiver = new Thread(new Runnable(){

            public void run() {
                SSH2Transport.this.transportReceiveLoop();
            }
        }, "SSH2TransportRX");
        this.receiver.start();
    }

    public void setSocketOptions(String string, Socket socket) throws IOException {
        String string2 = "socketoption." + string;
        String string3 = this.ourPrefs.getPreference(string2 + "." + "tcp-nodelay");
        if (string3 != null) {
            socket.setTcpNoDelay(Boolean.valueOf(string3));
        }
    }

    public String getLocalHostName() {
        return this.tpSocket.getLocalAddress().getHostName();
    }

    public byte[] getSessionId() {
        byte[] byArray = this.sessionId;
        if (!this.incompatiblePublicKeyUserId) {
            SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(this.sessionId.length + 4);
            sSH2DataBuffer.writeString(this.sessionId);
            byArray = sSH2DataBuffer.readRestRaw();
        }
        return byArray;
    }

    public SSH2TransportPDU getClientKEXINITPDU() {
        return this.clientKEXINITPkt;
    }

    public SSH2TransportPDU getServerKEXINITPDU() {
        return this.serverKEXINITPkt;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public SSH2Preferences getOurPreferences() {
        return this.ourPrefs;
    }

    public SSH2Preferences getPeerPreferences() {
        return this.peerPrefs;
    }

    public void setEventHandler(SSH2TransportEventHandler sSH2TransportEventHandler) {
        if (sSH2TransportEventHandler != null) {
            this.eventHandler = sSH2TransportEventHandler;
        }
    }

    public SSH2TransportEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public Log getLog() {
        return this.tpLog;
    }

    public void setLog(Log log) {
        this.tpLog = log;
    }

    public boolean isServer() {
        return this.weAreAServer;
    }

    public SecureRandom getSecureRandom() {
        return this.tpRand;
    }

    public SSH2Compressor getRxCompressor() {
        return this.rxContext.compressor;
    }

    public SSH2Compressor getTxCompressor() {
        return this.txContext.compressor;
    }

    public void setUserAuth(SSH2UserAuth sSH2UserAuth) {
        this.userAuth = sSH2UserAuth;
    }

    public void requestService(String string) {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(5);
        sSH2TransportPDU.writeString(string);
        this.transmit(sSH2TransportPDU);
    }

    public void setConnection(SSH2Connection sSH2Connection) {
        this.connection = sSH2Connection;
    }

    public void startKeyExchange() throws SSH2Exception {
        this.startKeyExchange(this.ourPrefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startKeyExchange(SSH2Preferences sSH2Preferences) throws SSH2Exception {
        Object object = this.keyExchangeMonitor;
        synchronized (object) {
            if (!this.keyExchangeInProgress) {
                if (this.incompatibleCantReKey && this.peerPrefs != null) {
                    throw new SSH2FatalException("Error, peer '" + (this.weAreAServer ? this.clientVersion : this.serverVersion) + "' doesn't support re-keying");
                }
                this.ourPrefs = sSH2Preferences;
                this.keyExchangeInProgress = true;
                if (this.incompatibleRijndael) {
                    this.removeRijndael();
                }
                this.txQueue.disable();
                this.rxNumPacketsSinceKEX = 0;
                this.txNumPacketsSinceKEX = 0;
                this.rxNumBlocksSinceKEX = 0;
                this.txNumBlocksSinceKEX = 0;
                this.sendKEXINIT();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForKEXComplete() {
        Object object = this.keyExchangeMonitor;
        synchronized (object) {
            if (this.keyExchangeInProgress) {
                try {
                    this.keyExchangeMonitor.wait(this.ourPrefs.getIntPreference("kex-timeout") * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.keyExchangeOk;
        }
    }

    public boolean keyExchangeInProgress() {
        return this.keyExchangeInProgress;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisconnectMessage() {
        String string = null;
        Object object = this.disconnectMonitor;
        synchronized (object) {
            if (!this.isConnected) {
                string = this.disconnectMessage;
            }
        }
        return string;
    }

    public void sendIgnore(byte[] byArray) {
        this.sendIgnore(byArray, 0, byArray.length);
    }

    public void sendIgnore(byte[] byArray, int n, int n2) {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(2);
        sSH2TransportPDU.writeString(byArray, n, n2);
        this.transmit(sSH2TransportPDU);
    }

    public void sendDebug(boolean bl, String string, String string2) {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(4);
        sSH2TransportPDU.writeBoolean(bl);
        sSH2TransportPDU.writeString(string);
        sSH2TransportPDU.writeString(string2);
        this.transmit(sSH2TransportPDU);
    }

    public void enableKeepAlive(int n) {
        if (this.heartbeat != null && this.heartbeat.isRunning()) {
            this.heartbeat.setInterval(n);
        } else if (n > 0) {
            this.heartbeat = new KeepAliveThread(n);
        }
    }

    public int getKeepAliveInterval() {
        if (this.heartbeat != null) {
            return this.heartbeat.getInterval();
        }
        return 0;
    }

    public void disableKeepAlive() {
        if (this.heartbeat != null) {
            this.heartbeat.stop();
        }
        this.heartbeat = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kexComplete(boolean bl) {
        Object object = this.keyExchangeMonitor;
        synchronized (object) {
            this.keyExchangeInProgress = false;
            this.keyExchangeOk = bl;
            this.keyExchangeMonitor.notifyAll();
            if (bl) {
                this.eventHandler.kexComplete(this);
            }
        }
    }

    private void authTerminate() {
        if (this.userAuth != null) {
            this.userAuth.terminate();
        }
    }

    public void transmit(SSH2TransportPDU sSH2TransportPDU) {
        if (this.isConnected) {
            this.txQueue.putLast(sSH2TransportPDU);
        }
    }

    public synchronized void transmitInternal(SSH2TransportPDU sSH2TransportPDU) throws SSH2Exception {
        try {
            sSH2TransportPDU.writeTo(this.tpOut, this.txSeqNum++, this.txContext, this.tpRand);
        }
        catch (ShortBufferException shortBufferException) {
            throw new SSH2FatalException("Internal error/bug: " + shortBufferException.getMessage());
        }
        catch (IOException iOException) {
            throw new SSH2FatalException("Couldn't write packet of type " + SSH2.msgTypeString(sSH2TransportPDU.pktType), iOException);
        }
    }

    public void fatalDisconnect(int n, String string) {
        this.disconnectInternal(n, string, "", false);
    }

    public void normalDisconnect(String string) {
        this.disconnectInternal(11, string, "", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectInternal(int n, String string, String string2, boolean bl) {
        Object object = this.disconnectMonitor;
        synchronized (object) {
            if (!this.isConnected) {
                return;
            }
            this.isConnected = false;
            this.disconnectMessage = string;
        }
        if (bl) {
            this.eventHandler.peerDisconnect(this, n, string, string2);
            this.tpLog.warning("SSH2Transport", "disconnect by peer: " + string);
        } else if (n == 11) {
            this.eventHandler.normalDisconnect(this, string, string2);
            this.tpLog.notice("SSH2Transport", "disconnect by application: " + string);
        } else {
            this.eventHandler.fatalDisconnect(this, n, string, string2);
            this.tpLog.error("SSH2Transport", "disconnectInternal", "disconnect: " + string);
        }
        if (!bl && this.isTxUp) {
            this.txQueue.disable();
            object = SSH2TransportPDU.createOutgoingPacket(1);
            ((SSH2DataBuffer)object).writeInt(n);
            ((SSH2DataBuffer)object).writeString(string);
            ((SSH2DataBuffer)object).writeString("");
            try {
                this.transmitInternal((SSH2TransportPDU)object);
            }
            catch (SSH2Exception sSH2Exception) {
                this.tpLog.message(2, "SSH2Transport", "disconnectInternal", "error writing disconnect msg: " + sSH2Exception);
            }
        }
        this.disableKeepAlive();
        this.shutdownRx();
        this.shutdownTx();
        if (this.connection != null) {
            this.connection.terminate();
        }
        this.tpLog.close();
    }

    private void negotiateVersion() throws IOException, SSH2Exception {
        int n = 0;
        String string = SSH2.getVersionId(this.ourPrefs.getPreference("package-version"));
        if (this.weAreAServer) {
            this.serverVersion = string;
            String string2 = this.serverVersion + "\r\n";
            this.tpOut.write(string2.getBytes());
            this.tpOut.flush();
            this.clientVersion = string2;
            this.tpLog.notice("SSH2Transport", "peer's version is '" + this.clientVersion + "'");
        } else {
            this.clientVersion = string;
            String string3 = this.clientVersion + "\r\n";
            this.tpOut.write(string3.getBytes());
            this.tpOut.flush();
            while (!(string3 = this.readIdString()).startsWith("SSH-")) {
                if (++n > 5) {
                    throw new SSH2ConnectException("Not an SSH server");
                }
                this.eventHandler.gotConnectInfoText(this, string3);
            }
            this.serverVersion = string3;
            this.tpLog.notice("SSH2Transport", "peer's version is '" + this.serverVersion + "'");
        }
        this.checkPeerVersion(this.clientVersion, this.serverVersion);
    }

    private void checkPeerVersion(String string, String string2) throws SSH2Exception {
        String string3;
        String string4 = SSH2Transport.extractPackageVersion(string);
        String string5 = SSH2Transport.extractPackageVersion(string2);
        int n = SSH2Transport.extractMajor(string);
        int n2 = SSH2Transport.extractMinor(string);
        int n3 = SSH2Transport.extractMajor(string2);
        int n4 = SSH2Transport.extractMinor(string2);
        if (this.weAreAServer) {
            this.eventHandler.gotPeerVersion(this, string, n, n2, string4);
        } else {
            this.eventHandler.gotPeerVersion(this, string2, n3, n4, string5);
        }
        if (n != n3 && (n3 != 1 || n4 != 99)) {
            String string6 = this.weAreAServer ? "Can't serve a client with version " + string : "Can't connect to a server with version " + string2;
            throw new SSH2FatalException(string6);
        }
        String string7 = string3 = this.weAreAServer ? string4 : string5;
        if (string3.startsWith("2.0.7") || string3.startsWith("2.0.8") || string3.startsWith("2.0.9")) {
            throw new SSH2FatalException("Peer's version is too old: " + string3);
        }
        this.incompatiblePublicKeyAuth = string3.startsWith("2.0.11") || string3.startsWith("2.0.12");
        this.incompatibleChannelOpenFail = this.incompatiblePublicKeyAuth || string3.startsWith("2.0.13") || string3.startsWith("2.0.14") || string3.startsWith("2.0.15") || string3.startsWith("2.0.16") || string3.startsWith("2.0.17") || string3.startsWith("2.0.18") || string3.startsWith("2.0.19");
        this.incompatibleMayReceiveDataAfterClose = string3.indexOf("F-SECURE") != -1 || string3.indexOf("SSH Secure Shell") != -1;
        this.incompatibleSignature = string3.startsWith("2.1.0 SSH") || string3.startsWith("2.1.0") && string3.indexOf("F-SECURE") != -1 || this.incompatiblePublicKeyAuth;
        this.incompatibleHMACKeyLength = this.incompatibleSignature || string3.startsWith("2.2.0 SSH") || string3.startsWith("2.3.0 SSH") || (string3.startsWith("2.2.0") || string3.startsWith("2.3.0")) && string3.indexOf("F-SECURE") != -1;
        this.incompatibleBuggyChannelClose = this.incompatibleHMACKeyLength || string3.startsWith("2.4.0 SSH");
        this.incompatiblePublicKeyUserId = this.incompatibleSignature || string3.startsWith("OpenSSH_2.0") || string3.startsWith("OpenSSH_2.1") || string3.startsWith("OpenSSH_2.2");
        this.incompatibleRijndael = string3.startsWith("OpenSSH_2.5.1p1") || string3.startsWith("OpenSSH_2.5.0") || string3.startsWith("OpenSSH_2.3");
        this.incompatibleCantReKey = this.incompatiblePublicKeyUserId || string3.startsWith("OpenSSH_2.3") || string3.startsWith("OpenSSH_2.5.1") || string3.startsWith("OpenSSH_2.5.2") || string3.startsWith("Sun_SSH_1.0") || !"true".equals(this.ourPrefs.getPreference("queued-rx-chan"));
        boolean bl = this.incompatibleOldDHGex = string3.startsWith("OpenSSH_2.0") || string3.startsWith("OpenSSH_2.1") || string3.startsWith("OpenSSH_2.2") || string3.startsWith("OpenSSH_2.3") || string3.startsWith("OpenSSH_2.5.0") || string3.startsWith("OpenSSH_2.5.1") || string3.startsWith("OpenSSH_2.5.2");
        if (this.incompatiblePublicKeyAuth) {
            this.tpLog.notice("SSH2Transport", "enabling draft incompatible publickey method");
        }
        if (this.incompatibleChannelOpenFail) {
            this.tpLog.notice("SSH2Transport", "enabling draft incompatible SERVICE_ACCEPT");
            this.tpLog.notice("SSH2Transport", "enabling draft incompatible CHANNEL_OPEN_FAILURE");
        }
        if (this.incompatibleSignature) {
            this.tpLog.notice("SSH2Transport", "enabling draft incompatible signature format");
        }
        if (this.incompatibleHMACKeyLength) {
            this.tpLog.notice("SSH2Transport", "enabling rfc incompatible hmac key length");
        }
        if (this.incompatiblePublicKeyUserId) {
            this.tpLog.notice("SSH2Transport", "enabling draft incompatible session id for signature");
        }
        if (this.incompatibleRijndael) {
            this.tpLog.notice("SSH2Transport", "disabling aes/rijndael cipher, peer has buggy implementation");
        }
        if (this.incompatibleCantReKey) {
            this.tpLog.notice("SSH2Transport", "disabling key re-exchange, not implemented in peer");
        }
        if (this.incompatibleMayReceiveDataAfterClose) {
            this.tpLog.notice("SSH2Transport", "enabling workaround for buggy SSH servers that may send channel data after close");
        }
        if (this.incompatibleOldDHGex) {
            this.tpLog.notice("SSH2Transport", "enabling workaround for old DH GEX");
        }
    }

    public static int extractMajor(String string) throws SSH2Exception {
        try {
            int n = string.indexOf(46, 4);
            return Integer.parseInt(string.substring(4, n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SSH2FatalException("Corrupt version string: " + string);
        }
    }

    public static int extractMinor(String string) throws SSH2Exception {
        try {
            int n = string.indexOf(46, 4) + 1;
            int n2 = string.indexOf(45, n);
            return Integer.parseInt(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SSH2FatalException("Corrupt version string: " + string);
        }
    }

    public static String extractPackageVersion(String string) throws SSH2Exception {
        try {
            int n = string.indexOf(45, 4) + 1;
            return string.substring(n);
        }
        catch (Exception exception) {
            throw new SSH2FatalException("Corrupt version string: " + string);
        }
    }

    private String readIdString() throws IOException, SSH2Exception {
        byte[] byArray = new byte[256];
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = this.tpIn.read()) == -1) {
                throw new SSH2EOFException("Server closed connection before sending identification");
            }
            if (n2 == 13) continue;
            if (n2 == 10) break;
            if (n >= byArray.length) {
                throw new SSH2FatalException("Too long id string: " + new String(byArray));
            }
            byArray[n++] = (byte)n2;
        }
        return new String(byArray, 0, n);
    }

    private void sendKEXINIT() throws SSH2Exception {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(20);
        byte[] byArray = new byte[16];
        this.tpRand.nextBytes(byArray);
        sSH2TransportPDU.writeRaw(byArray);
        this.ourPrefs.writeTo(sSH2TransportPDU);
        sSH2TransportPDU.writeBoolean(false);
        sSH2TransportPDU.writeInt(0);
        if (this.weAreAServer) {
            this.serverKEXINITPkt = sSH2TransportPDU.makeCopy();
        } else {
            this.clientKEXINITPkt = sSH2TransportPDU.makeCopy();
        }
        this.transmitInternal(sSH2TransportPDU);
        this.eventHandler.kexStart(this);
    }

    private void processKEXINIT(SSH2TransportPDU sSH2TransportPDU) throws SSH2Exception {
        this.startKeyExchange();
        if (this.weAreAServer) {
            this.clientKEXINITPkt = sSH2TransportPDU;
        } else {
            this.serverKEXINITPkt = sSH2TransportPDU;
        }
        sSH2TransportPDU.readRaw(16);
        this.peerPrefs = new SSH2Preferences();
        this.peerPrefs.readFrom(sSH2TransportPDU);
        boolean bl = sSH2TransportPDU.readBoolean();
        sSH2TransportPDU.readInt();
        this.tpLog.info("SSH2Transport", "peer kex algorithms: " + this.peerPrefs.getPreference("kex-algorithms"));
        this.tpLog.info("SSH2Transport", "peer host key algorithms: " + this.peerPrefs.getPreference("server-host-key-algorithms"));
        this.tpLog.info("SSH2Transport", "peer enc. alg. cli2srv: " + this.peerPrefs.getPreference("enc-algorithms-cli2srv"));
        this.tpLog.info("SSH2Transport", "peer enc. alg. srv2cli: " + this.peerPrefs.getPreference("enc-algorithms-srv2cli"));
        this.tpLog.info("SSH2Transport", "peer mac alg. cli2srv: " + this.peerPrefs.getPreference("mac-algorithms-cli2srv"));
        this.tpLog.info("SSH2Transport", "peer mac alg. srv2cli: " + this.peerPrefs.getPreference("mac-algorithms-srv2cli"));
        this.tpLog.info("SSH2Transport", "peer comp. alg. cli2srv: " + this.peerPrefs.getPreference("comp-algorithms-cli2srv"));
        this.tpLog.info("SSH2Transport", "peer comp. alg. srv2cli: " + this.peerPrefs.getPreference("comp-algorithms-srv2cli"));
        this.tpLog.info("SSH2Transport", "our kex algorithms: " + this.ourPrefs.getPreference("kex-algorithms"));
        this.tpLog.info("SSH2Transport", "our host key algorithms: " + this.ourPrefs.getPreference("server-host-key-algorithms"));
        this.tpLog.info("SSH2Transport", "our enc. alg. cli2srv: " + this.ourPrefs.getPreference("enc-algorithms-cli2srv"));
        this.tpLog.info("SSH2Transport", "our enc. alg. srv2cli: " + this.ourPrefs.getPreference("enc-algorithms-srv2cli"));
        this.tpLog.info("SSH2Transport", "our mac alg. cli2srv: " + this.ourPrefs.getPreference("mac-algorithms-cli2srv"));
        this.tpLog.info("SSH2Transport", "our mac alg. srv2cli: " + this.ourPrefs.getPreference("mac-algorithms-srv2cli"));
        this.tpLog.info("SSH2Transport", "our comp. alg. cli2srv: " + this.ourPrefs.getPreference("comp-algorithms-cli2srv"));
        this.tpLog.info("SSH2Transport", "our comp. alg. srv2cli: " + this.ourPrefs.getPreference("comp-algorithms-srv2cli"));
        this.keyExchanger = this.ourPrefs.selectKEXAlgorithm(this.peerPrefs, this.weAreAServer);
        this.tpLog.info("SSH2Transport", "KEX algorithm chosen: " + this.ourPrefs.getAgreedKEXAlgorithm());
        this.tpLog.info("SSH2Transport", "same KEX guessed? " + this.ourPrefs.sameKEXGuess());
        this.tpLog.info("SSH2Transport", "first KEX follows? " + bl);
        if (!this.ourPrefs.canAgree(this.peerPrefs, this.weAreAServer)) {
            String string = this.ourPrefs.getDisagreeType();
            String string2 = "No match in kex params '" + string + "', our's: " + this.ourPrefs.getPreference(string) + ", peer's: " + this.peerPrefs.getPreference(string);
            throw new SSH2FatalException(string2);
        }
        if (bl && !this.ourPrefs.sameKEXGuess()) {
            try {
                this.receiveInternal();
            }
            catch (IOException iOException) {
                throw new SSH2FatalException("I/O error when reading guessed packet", iOException);
            }
            catch (ShortBufferException shortBufferException) {
                throw new SSH2FatalException("Internal error/bug: " + shortBufferException.getMessage());
            }
            this.tpLog.notice("SSH2Transport", "first KEX packet discarded, wrong initial guess");
        }
        this.eventHandler.kexAgreed(this, this.ourPrefs, this.peerPrefs);
        this.keyExchanger.init(this);
    }

    private void removeRijndael() {
        boolean bl = false;
        String string = this.ourPrefs.getPreference("enc-algorithms-cli2srv");
        String string2 = this.ourPrefs.getPreference("enc-algorithms-srv2cli");
        int n = string.length();
        int n2 = string2.length();
        string = SSH2ListUtil.removeAllPrefixFromList(string, "aes");
        string = SSH2ListUtil.removeAllPrefixFromList(string, "rijndael");
        string2 = SSH2ListUtil.removeAllPrefixFromList(string2, "aes");
        string2 = SSH2ListUtil.removeAllPrefixFromList(string2, "rijndael");
        if (string.length() != n) {
            this.ourPrefs.setPreference("enc-algorithms-cli2srv", string);
            bl = true;
        }
        if (string2.length() != n2) {
            this.ourPrefs.setPreference("enc-algorithms-srv2cli", string2);
            bl = true;
        }
        if (bl) {
            this.tpLog.warning("SSH2Transport", "removed AES cipher from our preferences due to bug in peer's implementation");
        }
    }

    public void sendNewKeys() throws SSH2Exception {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(21);
        this.transmitInternal(sSH2TransportPDU);
        this.changeKeys(true);
        this.txQueue.enable();
    }

    public void authenticateHost(byte[] byArray, byte[] byArray2, byte[] byArray3) throws SSH2Exception {
        this.tpLog.debug2("SSH2Transport", "authenticateHost", "Server's public host key: ", byArray);
        this.tpLog.debug2("SSH2Transport", "authenticateHost", "Signature over H: ", byArray2);
        this.tpLog.debug2("SSH2Transport", "authenticateHost", "Exchange hash H", byArray3);
        boolean bl = false;
        SSH2Signature sSH2Signature = SSH2Signature.getInstance(this.ourPrefs.getAgreedHostKeyAlgorithm());
        sSH2Signature.initVerify(byArray);
        sSH2Signature.setIncompatibility(this);
        bl = sSH2Signature.verify(byArray2, byArray3);
        if (!bl) {
            String string = "server's signature didn't verify";
            this.tpLog.error("SSH2Transport", "authenticateHost", string);
            this.fatalDisconnect(9, string);
            throw new SSH2FatalException(string);
        }
        this.tpLog.info("SSH2Transport", "server's signature verified");
        if (this.serverPublicKeyBlob == null) {
            if (!this.eventHandler.kexAuthenticateHost(this, sSH2Signature)) {
                throw new SSH2SignatureException("Host authentication failed");
            }
            this.serverPublicKeyBlob = sSH2Signature.getPublicKeyBlob();
        } else {
            byte[] byArray4 = sSH2Signature.getPublicKeyBlob();
            boolean bl2 = byArray4.length == this.serverPublicKeyBlob.length;
            for (int i = 0; bl2 && i < byArray4.length; ++i) {
                bl2 = byArray4[i] == this.serverPublicKeyBlob[i];
            }
            if (!bl2) {
                this.disconnectInternal(10, "Server host key changed", "", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transportTransmitLoop() {
        this.isTxUp = true;
        this.tpLog.debug("SSH2Transport", "transportTransmitLoop", "starting");
        try {
            SSH2TransportPDU sSH2TransportPDU;
            while ((sSH2TransportPDU = (SSH2TransportPDU)this.txQueue.getFirst()) != null) {
                ++this.txNumPacketsSinceKEX;
                this.txNumBlocksSinceKEX += sSH2TransportPDU.getPayloadLength() / this.txContext.getCipherBlockSize();
                sSH2TransportPDU.writeTo(this.tpOut, this.txSeqNum++, this.txContext, this.tpRand);
                this.activity = true;
                if (this.txNumPacketsSinceKEX < Integer.MAX_VALUE && (long)this.txNumBlocksSinceKEX < this.blocks_before_rekey) continue;
                this.startKeyExchange();
            }
        }
        catch (ShortBufferException shortBufferException) {
            String string = "Internal error/bug: " + shortBufferException.getMessage();
            this.tpLog.error("SSH2Transport", "transportTransmitLoop", string);
            this.disconnectInternal(10, string, "", false);
        }
        catch (IOException iOException) {
            String string = "I/O error: " + iOException.getMessage();
            if (this.isTxUp) {
                this.tpLog.error("SSH2Transport", "transportTransmitLoop", string);
            }
            this.disconnectInternal(10, string, "", false);
        }
        catch (SSH2CompressionException sSH2CompressionException) {
            String string = "Internal error/bug: " + sSH2CompressionException.getMessage();
            this.tpLog.error("SSH2Transport", "transportTransmitLoop", string);
            this.disconnectInternal(6, string, "", false);
        }
        catch (SSH2Exception sSH2Exception) {
            String string = "Key reexchange failed: " + sSH2Exception.getMessage();
            this.tpLog.error("SSH2Transport", "transportTransmitLoop", string);
            this.disconnectInternal(6, string, "", false);
        }
        finally {
            this.shutdownTx();
            this.kexComplete(false);
            this.authTerminate();
        }
        this.tpLog.debug("SSH2Transport", "transportTransmitLoop", "stopping");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transportReceiveLoop() {
        this.isRxUp = true;
        this.tpLog.debug("SSH2Transport", "transportReceiveLoop", "starting");
        try {
            while (this.isRxUp) {
                this.processRxPacket(this.receiveInternal());
            }
        }
        catch (ShortBufferException shortBufferException) {
            String string = "Internal error/bug: " + shortBufferException.getMessage();
            this.disconnectInternal(10, string, "", false);
        }
        catch (SSH2MacCheckException sSH2MacCheckException) {
            String string = sSH2MacCheckException.getMessage();
            this.disconnectInternal(5, string, "", false);
        }
        catch (SSH2CompressionException sSH2CompressionException) {
            String string = sSH2CompressionException.getMessage();
            this.disconnectInternal(6, string, "", false);
        }
        catch (SSH2SignatureException sSH2SignatureException) {
            String string = sSH2SignatureException.getMessage();
            this.disconnectInternal(3, string, "", false);
        }
        catch (SSH2Exception sSH2Exception) {
            if (this.isRxUp) {
                String string = sSH2Exception.getMessage();
                if (sSH2Exception.getRootCause() != null) {
                    string = string + " (rootcause: " + sSH2Exception.getRootCause() + ")";
                }
                this.disconnectInternal(2, string, "", false);
            }
        }
        catch (IOException iOException) {
            if (this.isRxUp) {
                String string = "I/O error: " + iOException.getMessage();
                this.disconnectInternal(10, string, "", false);
            }
        }
        finally {
            this.shutdownRx();
            this.kexComplete(false);
            this.authTerminate();
        }
        this.tpLog.debug("SSH2Transport", "transportReceiveLoop", "stopping");
    }

    private void processRxPacket(SSH2TransportPDU sSH2TransportPDU) throws ShortBufferException, IOException, SSH2Exception {
        ++this.rxNumPacketsSinceKEX;
        this.rxNumBlocksSinceKEX += sSH2TransportPDU.getPayloadLength() / this.rxContext.getCipherBlockSize();
        switch (sSH2TransportPDU.pktType) {
            case 1: {
                int n = sSH2TransportPDU.readInt();
                String string = sSH2TransportPDU.readJavaString();
                String string2 = sSH2TransportPDU.readJavaString();
                this.disconnectInternal(n, string, string2, true);
                break;
            }
            case 2: {
                byte[] byArray = sSH2TransportPDU.readString();
                this.eventHandler.msgIgnore(this, byArray);
                break;
            }
            case 3: {
                int n = sSH2TransportPDU.readInt();
                this.eventHandler.msgUnimplemented(this, n);
                break;
            }
            case 4: {
                boolean bl = sSH2TransportPDU.readBoolean();
                String string = sSH2TransportPDU.readJavaString();
                String string3 = sSH2TransportPDU.readJavaString();
                this.eventHandler.msgDebug(this, bl, string, string3);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.userAuth.processMessage(sSH2TransportPDU);
                sSH2TransportPDU = null;
                break;
            }
            case 20: {
                this.processKEXINIT(sSH2TransportPDU);
                sSH2TransportPDU = null;
                break;
            }
            case 21: {
                if (!this.keyExchangeInProgress) {
                    throw new SSH2CorruptPacketException("Received MSG_NEWKEYS while not doing key exchange");
                }
                this.changeKeys(false);
                this.kexComplete(true);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                if (!this.keyExchangeInProgress) {
                    throw new SSH2CorruptPacketException("Received KEX packet while not doing key exchange");
                }
                this.keyExchanger.processKEXMethodPDU(sSH2TransportPDU);
                break;
            }
            case 52: {
                this.userAuth.processMessage(sSH2TransportPDU);
                sSH2TransportPDU = null;
                this.authenticated = true;
                this.rxContext.authSucceeded();
                this.txContext.authSucceeded();
                break;
            }
            case 50: 
            case 51: 
            case 53: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                this.userAuth.processMessage(sSH2TransportPDU);
                sSH2TransportPDU = null;
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 90: {
                this.connection.processGlobalMessage(sSH2TransportPDU);
                sSH2TransportPDU = null;
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                this.connection.processChannelMessage(sSH2TransportPDU);
                sSH2TransportPDU = null;
                break;
            }
            default: {
                if (this.handleExtensionRxPacket(sSH2TransportPDU)) break;
                this.tpLog.warning("SSH2Transport", "received packet of unknown type: " + sSH2TransportPDU.pktType);
                SSH2TransportPDU sSH2TransportPDU2 = SSH2TransportPDU.createOutgoingPacket(3);
                sSH2TransportPDU2.writeInt(this.rxSeqNum);
                if (this.keyExchangeInProgress) {
                    this.transmitInternal(sSH2TransportPDU2);
                } else {
                    this.transmit(sSH2TransportPDU2);
                }
                this.eventHandler.peerSentUnknownMessage(this, sSH2TransportPDU.pktType);
            }
        }
        if (sSH2TransportPDU != null) {
            sSH2TransportPDU.release();
        }
        if (this.rxNumPacketsSinceKEX >= Integer.MAX_VALUE || (long)this.rxNumBlocksSinceKEX >= this.blocks_before_rekey) {
            this.startKeyExchange();
        }
    }

    protected boolean handleExtensionRxPacket(SSH2TransportPDU sSH2TransportPDU) throws ShortBufferException, IOException, SSH2Exception {
        return false;
    }

    public SSH2TransportPDU receiveInternal() throws SSH2Exception, ShortBufferException, IOException {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createIncomingPacket();
        sSH2TransportPDU.readFrom(this.tpIn, this.rxSeqNum++, this.rxContext);
        this.activity = true;
        return sSH2TransportPDU;
    }

    private void shutdownTx() {
        if (this.isTxUp) {
            this.isTxUp = false;
            try {
                this.tpOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.txQueue.disable();
            this.txQueue.setBlocking(false);
        }
    }

    private void shutdownRx() {
        if (this.isRxUp) {
            this.isRxUp = false;
            try {
                this.tpIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private synchronized void changeKeys(boolean bl) throws SSH2Exception {
        try {
            String string = this.ourPrefs.getAgreedCipher(bl, this.weAreAServer);
            String string2 = this.ourPrefs.getAgreedMac(bl, this.weAreAServer);
            String string3 = this.ourPrefs.getAgreedCompression(bl, this.weAreAServer);
            int n = SSH2Preferences.getCipherKeyLen(string);
            int n2 = SSH2Preferences.getMacKeyLen(string2);
            this.tpLog.info("SSH2Transport", "new " + (bl ? "transmitter" : "receiver") + " context (" + string + "," + string2 + "," + string3 + ")");
            string = SSH2Preferences.ssh2ToJCECipher(string);
            string2 = SSH2Preferences.ssh2ToJCEMac(string2);
            TranceiverContext tranceiverContext = SSH2TransportPDU.createTranceiverContext(string, string2, string3);
            this.initTranceiverContext(tranceiverContext, n, this.incompatibleHMACKeyLength ? 16 : n2, bl);
            if (bl) {
                this.txContext = tranceiverContext;
            } else {
                this.rxContext = tranceiverContext;
            }
            int n3 = this.txContext.getCipherBlockSize();
            if (n3 == 0 || this.rxContext.getCipherBlockSize() < n3) {
                n3 = this.rxContext.getCipherBlockSize();
            }
            this.blocks_before_rekey = n3 >= 16 ? 1L << n3 * 2 : (long)(0x40000000 / n3);
        }
        catch (Exception exception) {
            throw new SSH2FatalException("Error in changeKeys", exception);
        }
    }

    private void initTranceiverContext(TranceiverContext tranceiverContext, int n, int n2, boolean bl) throws SSH2Exception {
        char[] cArray = this.weAreAServer ^ bl ? new char[]{'A', 'C', 'E'} : new char[]{'B', 'D', 'F'};
        byte[] byArray = this.deriveKey(cArray[0], tranceiverContext.getCipherBlockSize());
        byte[] byArray2 = this.deriveKey(cArray[1], n);
        byte[] byArray3 = this.deriveKey(cArray[2], n2);
        int n3 = 6;
        try {
            n3 = Integer.parseInt(this.ourPrefs.getPreference("compression"));
        }
        catch (Exception exception) {
            n3 = 6;
        }
        tranceiverContext.init(byArray2, byArray, byArray3, n3, bl);
        if (this.authenticated) {
            tranceiverContext.authSucceeded();
        }
    }

    byte[] deriveKey(char c, int n) {
        int n2;
        byte[] byArray = new byte[n];
        byte[] byArray2 = this.keyExchanger.getSharedSecret_K();
        byte[] byArray3 = this.keyExchanger.getExchangeHash_H();
        if (this.sessionId == null) {
            this.sessionId = new byte[byArray3.length];
            System.arraycopy(byArray3, 0, this.sessionId, 0, this.sessionId.length);
        }
        MessageDigest messageDigest = this.keyExchanger.getExchangeHashAlgorithm();
        messageDigest.update(byArray2);
        messageDigest.update(byArray3);
        messageDigest.update(new byte[]{(byte)c});
        messageDigest.update(this.sessionId);
        byte[] byArray4 = messageDigest.digest();
        System.arraycopy(byArray4, 0, byArray, 0, n2 < n ? n2 : n);
        for (n2 = byArray4.length; n2 < n; n2 += byArray4.length) {
            messageDigest.reset();
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            messageDigest.update(byArray, 0, n2);
            byArray4 = messageDigest.digest();
            if (n - n2 > byArray4.length) {
                System.arraycopy(byArray4, 0, byArray, n2, byArray4.length);
                continue;
            }
            System.arraycopy(byArray4, 0, byArray, n2, n - n2);
        }
        this.tpLog.debug2("SSH2Transport", "deriveKey", "key id " + c, byArray);
        return byArray;
    }

    protected void reportInactivity(int n) {
    }

    public static class TranceiverContext {
        protected Mac mac;
        protected Cipher cipher = null;
        protected SSH2Compressor compressor;

        public int getCipherBlockSize() {
            if (this.cipher != null) {
                return this.cipher.getBlockSize();
            }
            return 1;
        }

        public void init(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, boolean bl) throws SSH2Exception {
            try {
                if (this.cipher != null) {
                    this.cipher.init(bl ? 2 : 1, new SecretKeySpec(byArray, this.cipher.getAlgorithm()), new IvParameterSpec(byArray2));
                }
                if (this.mac != null) {
                    this.mac.init(new SecretKeySpec(byArray3, this.mac.getAlgorithm()));
                }
                if (this.compressor != null) {
                    this.compressor.init(bl ? 1 : 2, n);
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SSH2FatalException("Invalid key in TranceiverContext.init");
            }
        }

        public void authSucceeded() {
            if (this.compressor != null) {
                this.compressor.authSucceeded();
            }
        }
    }

    private class KeepAliveThread
    implements Runnable {
        private volatile int interval;
        private volatile boolean keepRunning;

        protected KeepAliveThread(int n) {
            this.interval = n;
            this.keepRunning = true;
            Thread thread = new Thread((Runnable)this, "SSH2TransportKeepAlive");
            thread.setDaemon(true);
            thread.setPriority(1);
            thread.start();
        }

        protected synchronized void setInterval(int n) {
            if (n < 1) {
                this.stop();
            } else {
                this.interval = n;
            }
        }

        protected int getInterval() {
            return this.interval;
        }

        public void run() {
            int n = 0;
            int n2 = 0;
            while (this.keepRunning) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (SSH2Transport.this.activity) {
                    n = 0;
                    n2 = 0;
                    SSH2Transport.this.activity = false;
                    continue;
                }
                SSH2Transport.this.reportInactivity(++n2);
                if (++n < this.interval) continue;
                SSH2Transport.this.sendIgnore("heartbeat".getBytes());
                Thread.yield();
                n = 0;
                SSH2Transport.this.activity = false;
            }
        }

        protected void stop() {
            this.keepRunning = false;
        }

        public boolean isRunning() {
            return this.keepRunning;
        }
    }
}

