/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.terminal.DisplayController;
import com.mindbright.terminal.DisplayModel;
import com.mindbright.terminal.DisplayUtil;
import com.mindbright.terminal.DisplayView;
import com.mindbright.terminal.FocusKludge;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;

public class DisplaySwing
extends JPanel
implements DisplayView,
AdjustmentListener,
MouseListener,
MouseMotionListener,
ComponentListener,
FocusListener,
ImageObserver {
    boolean pendingShow = true;
    boolean visTopChangeAllowed = true;
    static final int REPAINT_SLEEP = 70;
    static final boolean DEBUG = false;
    public static final int MIN_ROWS = 2;
    public static final int MIN_COLS = 8;
    public static final int MAX_COLS = 512;
    public static final int MAX_ROWS = 512;
    protected boolean haveScrollbar = false;
    private volatile boolean updateScrollbar = false;
    protected Container myPanel;
    private JFrame ownerFrame;
    private boolean logoDraw;
    private Image logoImg;
    private int logoX;
    private int logoY;
    private int logoW;
    private int logoH;
    private int centerLogoX;
    private int centerLogoY;
    private boolean isDirty = false;
    private int dirtyTop;
    private int dirtyBottom;
    private int dirtyLeft;
    private int dirtyRight;
    private int rows;
    private int cols;
    private int vpixels;
    private int hpixels;
    private int borderWidth = 2;
    private int borderHeight = 2;
    private int xPos;
    private int yPos;
    private int charWidth;
    private int charHeight;
    private int baselineIndex;
    private int lineSpaceDelta;
    private boolean cursorHollow = false;
    private boolean hasCursor = false;
    private int curRow;
    private int curCol;
    private int lastKeyKludge = 0;
    private boolean lastKeyWasPressed = false;
    private Color origBgColor;
    private Color origFgColor;
    private Color cursorColor;
    private int visTop = 0;
    private boolean visTopChangePending = false;
    private int visTopChange = 0;
    private Image memImage;
    private Graphics memGraphics;
    private Dimension memImageSize;
    private Font plainFont;
    private Font boldFont;
    private DisplayModel model;
    private DisplayController controller;
    private boolean hasSelection = false;
    private int selectionTopRow;
    private int selectionTopCol;
    private int selectionBottomRow;
    private int selectionBottomCol;
    private Repainter repainter;
    private JScrollBar scrollbar;
    private StringBuffer charbuf = new StringBuffer();

    public DisplaySwing(Frame frame) {
        this.ownerFrame = (JFrame)frame;
        frame.addComponentListener(this);
        this.addComponentListener(this);
        this.addFocusListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setAutoscrolls(true);
        try {
            new FocusKludge(frame);
            new FocusKludge(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.repainter = new Repainter(70);
    }

    public void setModel(DisplayModel displayModel) {
        this.model = displayModel;
    }

    public DisplayModel getModel() {
        return this.model;
    }

    public void setController(DisplayController displayController) {
        this.controller = displayController;
    }

    public void setKeyListener(KeyListener keyListener) {
        this.addKeyListener(keyListener);
    }

    public void delKeyListener(KeyListener keyListener) {
        this.removeKeyListener(keyListener);
    }

    private boolean isInsideSelection(int n, int n2) {
        if (!this.hasSelection) {
            return false;
        }
        if (n < this.selectionTopRow || n > this.selectionBottomRow) {
            return false;
        }
        if (n == this.selectionTopRow && n2 < this.selectionTopCol) {
            return false;
        }
        return n != this.selectionBottomRow || n2 <= this.selectionBottomCol;
    }

    public void setLogo(Image image, int n, int n2, int n3, int n4) {
        this.logoImg = image;
        this.logoX = n;
        this.logoY = n2;
        this.logoW = n3;
        this.logoH = n4;
    }

    public Image getLogo() {
        return this.logoImg;
    }

    public boolean showLogo() {
        this.logoDraw = this.logoImg != null;
        this.centerLogoX = -1;
        this.centerLogoY = -1;
        try {
            this.makeAllDirty();
            this.repaint();
        }
        catch (Throwable throwable) {
            this.logoDraw = false;
            System.out.println("Logo crash");
        }
        return this.logoDraw;
    }

    public void hideLogo() {
        this.logoDraw = false;
        try {
            this.makeAllDirty();
            this.repaint();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Color getTermRGBColor(String string) throws NumberFormatException {
        int n = string.indexOf(44);
        int n2 = string.lastIndexOf(44);
        if (n == -1 || n2 == -1) {
            throw new NumberFormatException();
        }
        int n3 = Integer.parseInt(string.substring(0, n).trim());
        int n4 = Integer.parseInt(string.substring(n + 1, n2).trim());
        int n5 = Integer.parseInt(string.substring(n2 + 1).trim());
        Color color = new Color(n3, n4, n5);
        return color;
    }

    public static Color getTermColor(String string) throws IllegalArgumentException {
        int n;
        for (n = 0; n < DisplayView.termColors.length && !DisplayView.termColorNames[n].equalsIgnoreCase(string); ++n) {
        }
        if (n == DisplayView.termColors.length) {
            throw new IllegalArgumentException("Unknown color: " + string);
        }
        return DisplayView.termColors[n];
    }

    public void setFont(String string, int n) {
        this.plainFont = new Font(string, 0, n);
        this.boldFont = new Font(string, 1, n);
        super.setFont(this.plainFont);
        this.calculateCharSize();
        if (this.isShowing()) {
            this.setGeometry(this.rows, this.cols);
        }
    }

    public void setLineSpaceDelta(int n) {
        this.lineSpaceDelta = n;
    }

    public void setFont(Font font) {
        this.setFont(font.getName(), font.getSize());
    }

    public void setVisTopChangeAllowed(boolean bl) {
        this.visTopChangeAllowed = bl;
    }

    public void setVisTopDelta(int n) {
        this.setVisTopDelta(n, this.visTopChangeAllowed);
    }

    public void setVisTopDelta(int n, boolean bl) {
        this.setVisTop(this.visTop + n, bl);
    }

    public void setVisTop(int n) {
        this.setVisTop(n, this.visTopChangeAllowed);
    }

    public void setVisTop(int n, boolean bl) {
        if (this.model == null) {
            return;
        }
        this.visTopChangePending = false;
        if (this.visTop != (n = this.fenceVisTop(n)) && bl) {
            this.visTop = n;
            this.repaint();
            this.updateScrollbarValues();
        }
    }

    public void setPendingVisTopChange(int n) {
        this.visTopChangePending = true;
        this.visTopChange = n;
    }

    private int fenceVisTop(int n) {
        int n2 = 0;
        int n3 = this.model.getBufferRows() - this.rows;
        if (n < n2) {
            n = n2;
        }
        if (n > n3) {
            n = n3;
        }
        return n;
    }

    public void updateScrollbarValues() {
        if (this.model == null) {
            return;
        }
        if (this.haveScrollbar) {
            this.updateScrollbar = true;
        }
    }

    protected void updateScrollbarValues(int n, int n2, int n3, int n4) {
        this.scrollbar.setValues(n, n2, n3, n4);
        this.scrollbar.setBlockIncrement(n2);
    }

    protected Dimension getScrollbarSize() {
        return this.scrollbar.getSize();
    }

    protected void addScrollbarToPanel(String string) {
        this.myPanel.add((Component)this.scrollbar, string);
    }

    protected void removeScrollbarFromPanel() {
        this.myPanel.remove(this.scrollbar);
    }

    public Container getPanelWithScrollbar(String string) {
        if (this.myPanel != null) {
            return this.myPanel;
        }
        this.scrollbar = new JScrollBar(1);
        this.updateScrollbarValues();
        this.scrollbar.addAdjustmentListener(this);
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this, "Center");
        if (string.equals("left")) {
            this.myPanel.add((Component)this.scrollbar, "West");
            this.haveScrollbar = true;
        } else if (string.equals("right")) {
            this.myPanel.add((Component)this.scrollbar, "East");
            this.haveScrollbar = true;
        } else {
            this.haveScrollbar = false;
        }
        return this.myPanel;
    }

    public void moveScrollbar(String string) {
        if (this.myPanel == null) {
            return;
        }
        if (string.equals("left") || string.equals("right")) {
            this.removeScrollbarFromPanel();
            this.addScrollbarToPanel(string.equals("right") ? "East" : "West");
            this.ownerFrame.pack();
            this.requestFocus();
            this.haveScrollbar = true;
        } else if (string.equals("none")) {
            this.removeScrollbarFromPanel();
            this.ownerFrame.pack();
            this.requestFocus();
            this.haveScrollbar = false;
        }
    }

    private final synchronized void makeAllDirty() {
        this.dirtyTop = 0;
        this.dirtyLeft = 0;
        this.dirtyBottom = this.rows;
        this.dirtyRight = this.cols;
        this.isDirty = true;
    }

    private final void makeCursorDirty() {
        this.makeAreaDirty(this.curRow, this.curCol, this.curRow + 1, this.curCol + 1);
    }

    private final void makeSelectionDirty() {
        int n;
        int n2;
        int n3 = this.selectionTopRow;
        int n4 = this.selectionBottomRow;
        if (n3 != n4) {
            n2 = 0;
            n = this.cols;
        } else if (this.selectionTopCol < this.selectionBottomCol) {
            n2 = this.selectionTopCol;
            n = this.selectionBottomCol;
        } else {
            n = this.selectionTopCol;
            n2 = this.selectionBottomCol;
        }
        this.makeAreaDirty(n3, n2, n4 + 1, n + 1);
    }

    public void updateDirtyArea(int n, int n2, int n3, int n4) {
        this.makeAreaDirty(n, n2, n3, n4);
    }

    private final synchronized void makeAreaDirty(int n, int n2, int n3, int n4) {
        if (n3 < this.visTop || n > this.visTop + this.rows) {
            return;
        }
        n -= this.visTop;
        n3 -= this.visTop;
        if (!this.isDirty) {
            this.dirtyTop = n;
            this.dirtyBottom = n3;
            this.dirtyLeft = n2;
            this.dirtyRight = n4;
            this.isDirty = true;
        } else {
            if (n < this.dirtyTop) {
                this.dirtyTop = n;
            }
            if (n3 > this.dirtyBottom) {
                this.dirtyBottom = n3;
            }
            if (n2 < this.dirtyLeft) {
                this.dirtyLeft = n2;
            }
            if (n4 > this.dirtyRight) {
                this.dirtyRight = n4;
            }
            if (this.dirtyTop == this.dirtyBottom) {
                ++this.dirtyBottom;
            }
            if (this.dirtyLeft == this.dirtyRight) {
                ++this.dirtyRight;
            }
        }
        this.dirtyTop = this.dirtyTop < 0 ? 0 : this.dirtyTop;
        this.dirtyBottom = this.dirtyBottom > this.rows ? this.rows : this.dirtyBottom;
        this.dirtyLeft = this.dirtyLeft < 0 ? 0 : this.dirtyLeft;
        int n5 = this.dirtyRight = this.dirtyRight > this.cols ? this.cols : this.dirtyRight;
        if (this.dirtyBottom - this.dirtyTop > 1) {
            this.dirtyLeft = 0;
            this.dirtyRight = this.cols;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.cursorHollow = false;
        this.makeCursorDirty();
        this.repaint(true);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.cursorHollow = true;
        this.makeCursorDirty();
        this.repaint(true);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void emulateComponentShown() {
        this.componentShown(new ComponentEvent(this.ownerFrame, 0));
    }

    public synchronized void componentShown(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() == this.ownerFrame && this.pendingShow) {
            this.pendingShow = false;
            this.calculateCharSize();
            this.setGeometry(this.rows, this.cols);
            this.setPosition(this.xPos, this.yPos);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public synchronized void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.getSize();
        int n = (dimension.width - 2 * this.borderWidth) / this.charWidth;
        int n2 = (dimension.height - 2 * this.borderHeight) / this.charHeight;
        if (this.pendingShow || componentEvent != null && componentEvent.getComponent() != this || n <= 0 || n2 <= 0) {
            return;
        }
        if ((n2 != this.rows || n != this.cols) && this.controller != null) {
            this.controller.displayDragResize(n2, n);
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.visTop = adjustmentEvent.getValue();
        this.updateScrollbarValues();
        this.repaint();
    }

    private final int mouseRow(int n) {
        int n2 = (n - this.borderHeight) / this.charHeight;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.rows) {
            n2 = this.rows - 1;
        }
        return n2;
    }

    private final int mouseCol(int n) {
        int n2 = (n - this.borderWidth) / this.charWidth;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.cols) {
            n2 = this.cols - 1;
        }
        return n2;
    }

    private static int getWhichButton(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return 0;
        }
        if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            return 1;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            return 2;
        }
        return -1;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public synchronized void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        int n = this.mouseRow(mouseEvent.getY());
        int n2 = this.mouseCol(mouseEvent.getX());
        int n3 = mouseEvent.getModifiers();
        if (this.controller != null) {
            this.controller.mouseClicked(this.visTop, n, n2, n3, DisplaySwing.getWhichButton(mouseEvent));
        }
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        int n = this.mouseRow(mouseEvent.getY());
        int n2 = this.mouseCol(mouseEvent.getX());
        int n3 = mouseEvent.getModifiers();
        if (this.controller != null) {
            this.controller.mousePressed(this.visTop, n, n2, n3, DisplaySwing.getWhichButton(mouseEvent), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        int n = this.mouseRow(mouseEvent.getY());
        int n2 = this.mouseCol(mouseEvent.getX());
        int n3 = mouseEvent.getModifiers();
        if (this.controller != null) {
            this.controller.mouseReleased(this.visTop, n, n2, n3, DisplaySwing.getWhichButton(mouseEvent));
        }
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        int n = 0;
        int n2 = this.visTop;
        int n3 = (mouseEvent.getY() - this.borderHeight) / this.charHeight;
        int n4 = this.mouseCol(mouseEvent.getX());
        if (this.visTop + n3 >= this.model.getBufferRows()) {
            n3 = this.model.getBufferRows() - this.visTop - 1;
        }
        if (this.visTop + n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.rows) {
            this.controller.scrollDown();
            ++n2;
            n3 = this.rows - 1;
            n = -1;
            n4 = this.cols - 1;
        } else if (n3 < 0) {
            this.controller.scrollUp();
            --n2;
            n3 = 0;
            n = 1;
            n4 = 0;
        }
        int n5 = mouseEvent.getModifiers();
        if (this.controller != null) {
            this.controller.mouseDragged(n2, n3, n4, n5, DisplaySwing.getWhichButton(mouseEvent), n);
        }
    }

    private void calculateCharSize() {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        this.charWidth = -1;
        this.charHeight = fontMetrics.getHeight() + this.lineSpaceDelta;
        int n = fontMetrics.getMaxAscent();
        int n2 = fontMetrics.getMaxDescent();
        int n3 = fontMetrics.getLeading();
        this.baselineIndex = n + n3 - 1;
        if (this.charWidth == -1) {
            this.charWidth = fontMetrics.charWidth('W');
        }
    }

    public boolean isWide(char c) {
        return !DisplayUtil.isBoxOrBlockChar(c) && ((Component)this).getFontMetrics(this.getFont()).charWidth(c) > this.charWidth;
    }

    public Dimension getDimensionOfText(int n, int n2) {
        return new Dimension(n2 * this.charWidth + 2 * this.borderHeight, n * this.charHeight + 2 * this.borderWidth);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getDimensionOfText(this.rows, this.cols);
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getDimensionOfText(2, 8);
    }

    public Dimension getMaximumSize() {
        return this.getDimensionOfText(512, 512);
    }

    final Rectangle getClipRect(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            Dimension dimension = this.getSize();
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        }
        return rectangle;
    }

    private void clearDirtyArea(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl;
        boolean bl2 = bl = n == 0 && n3 == this.cols && n2 == 0 && n4 == this.rows;
        if (bl) {
            Dimension dimension = this.getSize();
            n8 = 0;
            n7 = 0;
            n6 = dimension.width;
            n5 = dimension.height;
        } else {
            n8 = this.borderWidth + this.charWidth * n;
            n7 = this.borderHeight + n2 * this.charHeight;
            n6 = this.charWidth * (n3 - n);
            n5 = this.charHeight * (n4 - n2);
        }
        graphics.setColor(this.origBgColor);
        graphics.fillRect(n8, n7, n6, n5);
        graphics.setColor(this.origFgColor);
    }

    void doRepaint() {
        super.repaint();
    }

    public void repaint() {
        this.repaint(false);
    }

    public void repaint(boolean bl) {
        if (this.repainter != null) {
            this.repainter.repaint(bl);
        }
    }

    private void drawBufferedString(int n, int n2, Color color, boolean bl) {
        if (this.charbuf.length() == 0) {
            return;
        }
        Color color2 = this.memGraphics.getColor();
        this.memGraphics.setColor(color);
        if (bl) {
            this.memGraphics.setFont(this.boldFont);
        }
        this.memGraphics.drawString(this.charbuf.toString(), n, n2);
        if (bl) {
            this.memGraphics.setFont(this.plainFont);
        }
        this.charbuf.setLength(0);
        this.memGraphics.setColor(color2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        int n;
        boolean bl;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.model == null) {
            return;
        }
        if (this.hpixels == 0 || this.vpixels == 0) {
            Dimension dimension = this.getSize();
            this.vpixels = dimension.height;
            this.hpixels = dimension.width;
            System.out.println("h=" + this.hpixels + " v=" + this.vpixels);
            if (this.hpixels == 0 || this.vpixels == 0) {
                return;
            }
        }
        Serializable serializable = this;
        synchronized (serializable) {
            n5 = this.dirtyLeft;
            n4 = this.dirtyRight;
            n3 = this.dirtyTop;
            n2 = this.dirtyBottom;
            bl = this.isDirty;
            this.isDirty = false;
        }
        if (this.memGraphics == null || this.memImageSize == null || this.hpixels != this.memImageSize.width || this.vpixels != this.memImageSize.height) {
            this.memImageSize = new Dimension(this.hpixels, this.vpixels);
            this.memImage = this.createImage(this.hpixels, this.vpixels);
        }
        this.memGraphics = this.memImage.getGraphics();
        this.memGraphics.setFont(this.plainFont);
        if (bl) {
            this.clearDirtyArea(this.memGraphics, n5, n3, n4, n2);
        } else {
            this.makeAllDirty();
            n3 = 0;
            n2 = this.rows;
            n5 = 0;
            n4 = this.cols;
            serializable = this.getClipRect(graphics);
            this.memGraphics.setClip(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
            this.memGraphics.setColor(this.origBgColor);
            this.memGraphics.fillRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
            this.memGraphics.setColor(this.origFgColor);
        }
        int n6 = 0;
        int n7 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = n3; i < n2; ++i) {
            n = this.borderHeight + i * this.charHeight;
            int[] nArray = this.model.getAttribs(this.visTop, i);
            char[] cArray = this.model.getChars(this.visTop, i);
            if (nArray == null || cArray == null || nArray.length != cArray.length || n5 > nArray.length || n4 > nArray.length) continue;
            this.charbuf.setLength(0);
            int n8 = n5;
            Color color = null;
            boolean bl4 = false;
            for (int j = n5; j < n4; ++j) {
                boolean bl5;
                Color color2 = this.origBgColor;
                Color color3 = this.origFgColor;
                int n9 = nArray[j];
                int n10 = n9 & 0xFFFF;
                boolean bl6 = false;
                int n11 = this.borderWidth + this.charWidth * j;
                if ((n9 & 0x10) != 0 ^ this.isInsideSelection(this.visTop + i, j)) {
                    color2 = (n9 & 0x40) != 0 ? DisplayView.termColors[(n9 & 0xFF0000) >>> 16] : this.origFgColor;
                    color3 = (n9 & 0x80) != 0 ? DisplayView.termColors[(n9 & 0xFF000000) >>> 24] : this.origBgColor;
                    if ((n9 & 2) != 0) {
                        color2 = DisplayUtil.makeDimmerColor(color2);
                    }
                    bl6 = true;
                } else {
                    if ((n9 & 0x80) != 0) {
                        color2 = DisplayView.termColors[(n9 & 0xFF000000) >>> 24];
                        bl6 = true;
                    }
                    if ((n9 & 0x40) != 0) {
                        color3 = DisplayView.termColors[(n9 & 0xFF0000) >>> 16];
                        bl6 = true;
                    }
                    if ((n9 & 2) != 0) {
                        color3 = DisplayUtil.makeDimmerColor(color3);
                        bl6 = true;
                    }
                }
                if (this.hasCursor && this.visTop + i == this.curRow && j == this.curCol) {
                    bl2 = true;
                    bl3 = (n9 & 0x10) != 0;
                    n6 = n11;
                    n7 = n;
                } else if ((n9 & 0x400) == 0) {
                    if (bl6) {
                        this.memGraphics.setColor(color2);
                        bl5 = this.charWidth;
                        if ((n9 & 0x200) != 0) {
                            bl5 *= 2;
                        }
                        this.memGraphics.fillRect(n11, n, bl5 ? 1 : 0, this.charHeight);
                    }
                    this.memGraphics.setColor(color3);
                }
                if ((n10 & 0x8000) != 0) {
                    if ((n9 & 0x20) != 0) {
                        this.drawBufferedString(n8, this.baselineIndex + n, color, bl4);
                    } else if ((n9 & 0x200) != 0) {
                        this.drawBufferedString(n8, this.baselineIndex + n, color, bl4);
                        boolean bl7 = bl5 = (n9 & 1) != 0 || (n9 & 8) != 0;
                        if (bl5) {
                            this.memGraphics.setFont(this.boldFont);
                        }
                        this.memGraphics.drawChars(cArray, j, 1, n11, n + this.baselineIndex);
                        if (bl5) {
                            this.memGraphics.setFont(this.plainFont);
                        }
                    } else if ((n9 & 0x400) != 0) {
                        this.drawBufferedString(n8, this.baselineIndex + n, color, bl4);
                    } else if ((n9 & 0x100) != 0) {
                        this.drawBufferedString(n8, this.baselineIndex + n, color, bl4);
                        DisplayUtil.drawLineDrawChar(this.memGraphics, n11, n, this.baselineIndex, cArray[j], this.charWidth, this.charHeight);
                    } else if (DisplayUtil.isBoxOrBlockChar(cArray[j])) {
                        this.drawBufferedString(n8, this.baselineIndex + n, color, bl4);
                        DisplayUtil.drawBoxOrBlockChar(this.memGraphics, n11, n, this.baselineIndex, cArray[j], this.charWidth, this.charHeight);
                    } else {
                        boolean bl8 = bl5 = (n9 & 1) != 0 || (n9 & 8) != 0;
                        if (color != null && (bl4 != bl5 || color != this.memGraphics.getColor())) {
                            this.drawBufferedString(n8, this.baselineIndex + n, color, bl4);
                        }
                        if (this.charbuf.length() == 0) {
                            n8 = n11;
                            color = this.memGraphics.getColor();
                            bl4 = bl5;
                        }
                        this.charbuf.append(cArray[j]);
                    }
                    if ((n9 & 4) == 0) continue;
                    this.memGraphics.drawLine(n11, n + this.baselineIndex, n11 + this.charWidth, n + this.baselineIndex);
                    continue;
                }
                this.drawBufferedString(n8, this.baselineIndex + n, color, bl4);
            }
            this.drawBufferedString(n8, this.baselineIndex + n, color, bl4);
        }
        if (bl2) {
            this.memGraphics.setColor(this.cursorColor);
            this.memGraphics.setXORMode(bl3 ? this.origFgColor : this.origBgColor);
            if (this.cursorHollow) {
                this.memGraphics.drawRect(n6, n7, this.charWidth - 1, this.charHeight - 1);
            } else {
                this.memGraphics.fillRect(n6, n7, this.charWidth, this.charHeight);
            }
            this.memGraphics.setPaintMode();
            this.memGraphics.setColor(this.origFgColor);
        }
        if (this.logoDraw && this.logoImg != null) {
            int n12 = this.logoX;
            n = this.logoY;
            if (n12 == -1) {
                if (this.centerLogoX == -1) {
                    this.centerLogoX = this.hpixels / 2 - this.logoW / 2;
                }
                n12 = this.centerLogoX;
            }
            if (n == -1) {
                if (this.centerLogoY == -1) {
                    this.centerLogoY = this.vpixels / 2 - this.logoH / 2;
                }
                n = this.centerLogoY;
            }
            this.memGraphics.setClip(graphics.getClip());
            this.memGraphics.drawImage(this.logoImg, n12, n, this);
        }
        graphics.drawImage(this.memImage, 0, 0, null);
        if (this.updateScrollbar) {
            this.updateScrollbar = false;
            this.updateScrollbarValues(this.visTop, this.rows, 0, this.model.getBufferRows());
        }
    }

    public void setPosition(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DisplaySwing.this.setPositionI(n, n2);
            }
        });
    }

    private void setPositionI(int n, int n2) {
        int n3;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getDimensionOfText(this.rows, this.cols);
        Insets insets = this.ownerFrame.getInsets();
        int n4 = n3 = this.haveScrollbar ? this.getScrollbarSize().width : 0;
        if (n < 0) {
            n += dimension.width - dimension2.width - insets.left - insets.right - n3;
        }
        if (n2 < 0) {
            n2 += dimension.height - dimension2.height - insets.top - insets.bottom;
        }
        this.xPos = n;
        this.yPos = n2;
        if (this.isShowing()) {
            ((Component)this.ownerFrame).setLocation(n, n2);
            this.ownerFrame.pack();
            this.requestFocus();
        } else {
            this.pendingShow = true;
        }
        this.repaint(true);
    }

    public void setGeometry(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DisplaySwing.this.setGeometryI(n, n2);
            }
        });
    }

    private void setGeometryI(int n, int n2) {
        Dimension dimension = this.getDimensionOfText(n, n2);
        if (this.vpixels == dimension.height && this.hpixels == dimension.width) {
            return;
        }
        this.vpixels = dimension.height;
        this.hpixels = dimension.width;
        this.rows = n;
        this.cols = n2;
        this.setSize(dimension);
        if (this.visTopChangePending) {
            this.visTop = this.fenceVisTop(this.visTopChange);
            this.visTopChangePending = false;
        }
        if (this.isShowing()) {
            this.memGraphics = null;
            this.updateScrollbarValues();
            this.makeAllDirty();
            this.ownerFrame.pack();
            this.requestFocus();
        } else {
            this.pendingShow = true;
        }
        this.repaint();
        if (this.controller != null) {
            this.controller.displayResized(n, n2, this.vpixels, this.hpixels);
        }
    }

    public synchronized void resetSelection() {
        this.hasSelection = false;
        this.makeSelectionDirty();
        this.repaint();
    }

    public synchronized void setSelection(int n, int n2, int n3, int n4) {
        if (this.hasSelection) {
            this.makeSelectionDirty();
        } else {
            this.hasSelection = true;
        }
        if (n < n3) {
            this.selectionTopRow = n;
            this.selectionTopCol = n2;
            this.selectionBottomRow = n3;
            this.selectionBottomCol = n4;
        } else if (n == n3) {
            this.selectionTopRow = this.selectionBottomRow = n;
            if (n2 < n4) {
                this.selectionTopCol = n2;
                this.selectionBottomCol = n4;
            } else {
                this.selectionTopCol = n4;
                this.selectionBottomCol = n2;
            }
        } else {
            this.selectionTopRow = n3;
            this.selectionTopCol = n4;
            this.selectionBottomRow = n;
            this.selectionBottomCol = n2;
        }
        this.makeSelectionDirty();
        this.repaint();
    }

    public void setNoCursor() {
        if (this.hasCursor) {
            this.hasCursor = false;
            this.makeCursorDirty();
            this.repaint();
        }
    }

    public synchronized void setCursorPosition(int n, int n2) {
        this.makeCursorDirty();
        if (!this.hasCursor) {
            this.hasCursor = true;
        }
        this.curRow = n;
        this.curCol = n2;
        this.makeCursorDirty();
    }

    public void setBackgroundColor(Color color) {
        this.origBgColor = color;
        this.setBackground(this.origBgColor);
        this.makeAllDirty();
        this.repaint();
    }

    public void setForegroundColor(Color color) {
        this.origFgColor = color;
        this.setForeground(this.origFgColor);
        this.makeAllDirty();
        this.repaint();
    }

    public void setCursorColor(Color color) {
        this.cursorColor = color;
        this.makeAllDirty();
        this.repaint();
    }

    public void reverseColors() {
        Color color = this.origBgColor;
        this.origBgColor = this.origFgColor;
        this.origFgColor = color;
        this.makeAllDirty();
        this.repaint();
    }

    public void doBell() {
        this.doBell(false);
    }

    public void doBell(boolean bl) {
        if (bl) {
            this.reverseColors();
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reverseColors();
        } else {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit != null) {
                try {
                    toolkit.beep();
                }
                catch (Exception exception) {
                    this.doBell(true);
                }
            }
        }
    }

    public Component getAWTComponent() {
        return this;
    }

    public void setIgnoreClose() {
        this.ownerFrame.setDefaultCloseOperation(0);
    }

    public void windowClosed() {
        this.removeComponentListener(this);
        this.removeFocusListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
        this.ownerFrame.removeComponentListener(this);
        this.ownerFrame = null;
        this.controller = null;
        this.model = null;
        this.repainter = null;
        if (this.myPanel != null) {
            this.myPanel.removeAll();
        }
        this.myPanel = null;
        this.scrollbar = null;
        this.removeAll();
    }

    public Component mkButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setActionCommand(string2);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (n == 32) {
            return false;
        }
        this.repaint();
        return true;
    }

    private class Repainter
    extends Thread {
        protected int sleepTime;
        protected boolean repaintRequested;
        protected boolean hasSlept;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Repainter(int n) {
            super("DisplaySwing.repainter");
            this.sleepTime = n;
            this.repaintRequested = false;
            this.hasSlept = false;
            Repainter repainter = this;
            synchronized (repainter) {
                this.start();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Repainter repainter = this;
            synchronized (repainter) {
                this.notify();
            }
            while (DisplaySwing.this.ownerFrame != null) {
                try {
                    repainter = this;
                    synchronized (repainter) {
                        this.wait(this.sleepTime);
                        if (this.repaintRequested) {
                            DisplaySwing.this.doRepaint();
                            this.repaintRequested = false;
                            this.hasSlept = false;
                        } else {
                            this.hasSlept = true;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void repaint(boolean bl) {
            this.repaintRequested = true;
            if (bl || this.hasSlept) {
                Repainter repainter = this;
                synchronized (repainter) {
                    this.notify();
                }
            }
        }
    }
}

