/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.terminal.TerminalInputListener;
import com.mindbright.terminal.TerminalWindow;

public final class LineReaderTerminal
implements TerminalInputListener {
    TerminalWindow terminal;
    StringBuffer readLineStr;
    boolean echoStar;
    boolean isReadingLine;
    boolean terminalChanged;
    volatile boolean ctrlCPressed;
    volatile boolean ctrlDPressed;
    ExternalMessageException extMsg;

    public LineReaderTerminal(TerminalWindow terminalWindow) {
        this.terminal = terminalWindow;
        terminalWindow.addInputListener(this);
    }

    public void detach() {
        this.terminal.removeInputListener(this);
    }

    public void print(String string) {
        if (this.terminal != null) {
            this.terminal.write(string);
        } else {
            System.out.print(string);
        }
    }

    public void println(String string) {
        if (this.terminal != null) {
            this.terminal.write(string + "\n\r");
        } else {
            System.out.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakPromptLine(String string) {
        if (this.isReadingLine) {
            LineReaderTerminal lineReaderTerminal = this;
            synchronized (lineReaderTerminal) {
                this.extMsg = new ExternalMessageException(string);
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String string) {
        LineReaderTerminal lineReaderTerminal = this;
        synchronized (lineReaderTerminal) {
            if (string != null) {
                this.readLineStr = new StringBuffer(string);
                this.terminal.write(string);
            } else {
                this.readLineStr = new StringBuffer();
            }
            this.isReadingLine = true;
            this.terminalChanged = false;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.isReadingLine = false;
        }
        if (this.terminalChanged) {
            return null;
        }
        return this.readLineStr.toString();
    }

    public String promptLine(String string, String string2, boolean bl) throws ExternalMessageException {
        String string3 = null;
        if (this.terminal != null) {
            this.terminal.setAttributeBold(true);
            this.terminal.write(string);
            this.terminal.setAttributeBold(false);
            this.echoStar = bl;
            string3 = this.readLine(string2);
            this.echoStar = false;
        }
        if (this.extMsg != null) {
            ExternalMessageException externalMessageException = this.extMsg;
            this.extMsg = null;
            throw externalMessageException;
        }
        return string3;
    }

    public boolean ctrlCPressed() {
        boolean bl = this.ctrlCPressed;
        this.ctrlCPressed = false;
        return bl;
    }

    public synchronized void typedChar(char c) {
        if (this.isReadingLine) {
            if (c == '\u007f' || c == '\b') {
                if (this.readLineStr.length() > 0) {
                    boolean bl = false;
                    if (this.readLineStr.charAt(this.readLineStr.length() - 1) < ' ') {
                        bl = true;
                    }
                    this.readLineStr.setLength(this.readLineStr.length() - 1);
                    this.terminal.write('\b');
                    if (bl) {
                        this.terminal.write('\b');
                    }
                    this.terminal.write(' ');
                    if (bl) {
                        this.terminal.write(' ');
                    }
                    this.terminal.write('\b');
                    if (bl) {
                        this.terminal.write('\b');
                    }
                } else {
                    this.terminal.ringBell();
                }
            } else if (c == '\r') {
                this.notify();
                this.terminal.write("\n\r");
            } else {
                this.ctrlCPressed = false;
                this.ctrlDPressed = false;
                this.readLineStr.append(c);
                if (this.echoStar) {
                    this.terminal.write('*');
                } else {
                    this.terminal.write(c);
                }
            }
        } else if (c == '\u0003') {
            this.ctrlCPressed = true;
        } else if (c == '\u0004') {
            this.ctrlDPressed = true;
        }
    }

    public void typedChar(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.typedChar((char)byArray[i]);
        }
    }

    public void sendBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.typedChar((char)byArray[i]);
        }
    }

    public void signalWindowChanged(int n, int n2, int n3, int n4) {
    }

    public synchronized void signalTermTypeChanged(String string) {
        this.terminalChanged = true;
        this.notify();
    }

    public void sendBreak() {
    }

    public static class ExternalMessageException
    extends Exception {
        public ExternalMessageException(String string) {
            super(string);
        }
    }
}

