/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.tandem6530.BadColorException;
import com.mindbright.terminal.tandem6530.FieldAttributes;
import com.mindbright.terminal.tandem6530.ParseException;

public class IBM3270FieldAttributes
extends FieldAttributes {
    public static final int DEFAULT_FG_COLOR = 4;
    public static final int DEFAULT_BG_COLOR = 0;
    private int fgColor = 4;
    private int bgColor = 0;

    public IBM3270FieldAttributes(char c, char c2, char c3) throws ParseException {
        super(c, c2, c3);
    }

    public int getFgColor() {
        return this.fgColor;
    }

    public void setFgColor(int n) throws BadColorException {
        if (n < 0 || n > 15) {
            throw new BadColorException("Invalid color");
        }
        this.fgColor = n;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int n) throws BadColorException {
        if (n < 0 || n > 15) {
            throw new BadColorException("Invalid color");
        }
        this.bgColor = n;
    }

    public int hashCode() {
        return super.hashCode() + 4000 * this.getFgColor() + 8000 * this.getBgColor();
    }

    public boolean equals(Object object) {
        IBM3270FieldAttributes iBM3270FieldAttributes = (IBM3270FieldAttributes)object;
        if (iBM3270FieldAttributes == null) {
            return false;
        }
        return super.equals(object) && this.getFgColor() == iBM3270FieldAttributes.getFgColor() && this.getBgColor() == iBM3270FieldAttributes.getBgColor();
    }

    public String toString() {
        return super.toString() + " fg=" + this.getFgColor() + " bg=" + this.getBgColor();
    }
}

