/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.DisplayModel;
import com.mindbright.terminal.DisplayView;
import com.mindbright.terminal.SearchContext;
import com.mindbright.terminal.Terminal;
import com.mindbright.terminal.TerminalOption;
import com.mindbright.terminal.TerminalWindow;
import com.mindbright.terminal.tandem6530.ActionHandler;
import com.mindbright.terminal.tandem6530.AsciiCodes;
import com.mindbright.terminal.tandem6530.BlockMode;
import com.mindbright.terminal.tandem6530.ColorMap;
import com.mindbright.terminal.tandem6530.ConfigParameter;
import com.mindbright.terminal.tandem6530.ConvMode;
import com.mindbright.terminal.tandem6530.FieldAttributes;
import com.mindbright.terminal.tandem6530.IBM3270FieldAttributes;
import com.mindbright.terminal.tandem6530.Mode;
import com.mindbright.terminal.tandem6530.ParseException;
import com.mindbright.terminal.tandem6530.Parser;
import com.mindbright.terminal.tandem6530.ProtectBlockMode;
import com.mindbright.terminal.tandem6530.StatusLine;
import com.mindbright.terminal.tandem6530.Terminal6530Callback;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Terminal6530
implements Terminal,
DisplayModel,
Terminal6530Callback,
ActionHandler,
AsciiCodes {
    private static String MY_NAME = "tn6530-8";
    private static String MY_REVISION = "G40";
    private boolean DEBUG = false;
    private boolean LIMITED_DEBUG = true;
    private static int OPT_BAUD_RATE = 0;
    private static int OPT_BELL_COLUMN = 1;
    private static int OPT_BELL_VOLUME = 2;
    private static int OPT_CHAR_SET = 3;
    private static int OPT_CHAR_SIZE = 4;
    private static int OPT_COLOR_SUPPORT = 5;
    private static int OPT_COMPRESSION_ENHANCE = 6;
    private static int OPT_CURSOR_TYPE = 7;
    private static int OPT_DEFAULT_DEVICE_ID = 8;
    private static int OPT_DUPLEX = 9;
    private static int OPT_EM3270_SUPPORT = 10;
    private static int OPT_KEYBOARD = 11;
    private static int OPT_KEY_CLICK_VOLUME = 12;
    private static int OPT_LANGUAGE = 13;
    private static int OPT_LOCAL_TRANSMIT_COLUMN = 14;
    private static int OPT_MLAN_HOST_INIT = 15;
    private static int OPT_NORMAL_INTENSITY = 16;
    private static int OPT_PACKET_BLOCKING = 17;
    private static int OPT_PARITY = 18;
    private static int OPT_RETURN_KEY_FUNCTION = 19;
    private static int OPT_RTM_SUPPORT = 20;
    private static int OPT_SAVE_CONFIG = 21;
    private static int OPT_SCREEN_SAVER = 22;
    private static int OPT_SINGLE_PAGE_SUBMODE = 23;
    private static int OPT_STATUS_LINE_BORDER = 24;
    private static int OPT_SWITCH_REFRESH_RATE = 25;
    private static int OPT_SCREEN_FORMAT = 26;
    private static int OPT_MODE = 27;
    private static int OPT_LAST_OPTION = 28;
    private int[] options = new int[OPT_LAST_OPTION];
    private static int ATTR_6530_DIM_INTENSITY = 1;
    private static int ATTR_6530_BLINKING = 2;
    private static int ATTR_6530_REVERSE_VIDEO = 4;
    private static int ATTR_6530_INVISIBLE = 8;
    private static int ATTR_6530_UNDERSCORE = 16;
    private static final int MODE_CONV = 0;
    private static final int MODE_BLOCK = 1;
    private static final int MODE_PROTECT_BLOCK = 2;
    private int currentMode;
    private Mode[] modes;
    private ConvMode convMode;
    private BlockMode blockMode;
    private ProtectBlockMode protectBlockMode;
    private Parser hostParser = new Parser();
    private Parser keyboardParser = new Parser();
    private TerminalWindow termWin;
    private DisplayView display;
    private static int STATUS_LINE = 24;
    private static int COLUMNS = 80;
    private static int MAX_PAGES = 10;
    private StatusLine statusLine = new StatusLine(this, 32768);
    private boolean colorSupport = false;
    private ColorMap colorMap = new ColorMap();
    private boolean keyboardLocked = false;
    private boolean haveError = false;
    private boolean showStatusLine = true;
    private boolean enterIsFuctionKey = false;
    private boolean localLineEditing = true;
    private boolean viewBlankPage = false;
    private boolean powerUp = false;
    private static Properties defaultProperties;
    private Properties props = new Properties(defaultProperties);
    private boolean propsChanged;
    private static TerminalOption optColorMapping;
    private static TerminalOption[] optionsDef;
    private boolean doupdate = true;

    public Terminal6530() {
        this.convMode = new ConvMode(this, this.keyboardParser);
        this.blockMode = new BlockMode(this, MAX_PAGES);
        this.protectBlockMode = new ProtectBlockMode(this, MAX_PAGES);
        this.modes = new Mode[3];
        this.modes[0] = this.convMode;
        this.modes[1] = this.blockMode;
        this.modes[2] = this.protectBlockMode;
        this.hostParser.setActionHandler(this);
        this.keyboardParser.setActionHandler(this);
        this.currentMode = 1;
        this.doSetConversationalMode();
        this.options[Terminal6530.OPT_BAUD_RATE] = 8;
        this.options[Terminal6530.OPT_BELL_COLUMN] = 72;
        this.options[Terminal6530.OPT_BELL_VOLUME] = 1;
        this.options[Terminal6530.OPT_CHAR_SET] = 0;
        this.options[Terminal6530.OPT_CHAR_SIZE] = 1;
        this.options[Terminal6530.OPT_COLOR_SUPPORT] = 0;
        this.options[Terminal6530.OPT_COMPRESSION_ENHANCE] = 0;
        this.options[Terminal6530.OPT_CURSOR_TYPE] = 3;
        this.options[Terminal6530.OPT_DEFAULT_DEVICE_ID] = 0;
        this.options[Terminal6530.OPT_DUPLEX] = 0;
        this.options[Terminal6530.OPT_EM3270_SUPPORT] = 0;
        this.options[Terminal6530.OPT_KEYBOARD] = 7;
        this.options[Terminal6530.OPT_KEY_CLICK_VOLUME] = 0;
        this.options[Terminal6530.OPT_LANGUAGE] = 0;
        this.options[Terminal6530.OPT_LOCAL_TRANSMIT_COLUMN] = 1;
        this.options[Terminal6530.OPT_MLAN_HOST_INIT] = 0;
        this.options[Terminal6530.OPT_NORMAL_INTENSITY] = 0;
        this.options[Terminal6530.OPT_PACKET_BLOCKING] = 1;
        this.options[Terminal6530.OPT_PARITY] = 3;
        this.options[Terminal6530.OPT_RETURN_KEY_FUNCTION] = 0;
        this.options[Terminal6530.OPT_RTM_SUPPORT] = 0;
        this.options[Terminal6530.OPT_SAVE_CONFIG] = 0;
        this.options[Terminal6530.OPT_SCREEN_SAVER] = 0;
        this.options[Terminal6530.OPT_SINGLE_PAGE_SUBMODE] = 0;
        this.options[Terminal6530.OPT_STATUS_LINE_BORDER] = 0;
        this.options[Terminal6530.OPT_SWITCH_REFRESH_RATE] = 0;
        this.options[Terminal6530.OPT_SCREEN_FORMAT] = 0;
        this.options[Terminal6530.OPT_MODE] = 0;
    }

    public static Terminal getTerminal(String string) {
        if (MY_NAME.equals(string)) {
            return new Terminal6530();
        }
        return null;
    }

    public static String[] getTerminalTypes() {
        String[] stringArray = new String[]{MY_NAME};
        return stringArray;
    }

    public boolean setTerminalType(String string) {
        return false;
    }

    public void setDumbMode(boolean bl) {
    }

    public void doBell() {
        this.debug("doBell");
        if (this.display != null) {
            this.display.doBell();
        }
    }

    public void doBackspace() {
        this.debug("doBackspace");
        this.modes[this.currentMode].doBackspace();
    }

    public void doHTab() {
        this.debug("doHTab");
        this.modes[this.currentMode].doHTab();
    }

    public void doLineFeed() {
        this.debug("doLineFeed");
        this.modes[this.currentMode].doLineFeed();
    }

    public void doCarriageReturn() {
        this.debug("doCarriageReturn");
        this.modes[this.currentMode].doCarriageReturn();
    }

    public void doSetConversationalMode() {
        if (this.currentMode == 0) {
            return;
        }
        this.debug("doSetConversationalMode");
        this.hostParser.setConversationalMode();
        this.keyboardParser.setConversationalMode();
        this.setMode(0);
        this.statusLine.setStatus("CONV");
    }

    public void doSetBlockMode() {
        this.debug("doSetBlockMode");
        this.hostParser.setBlockMode();
        this.keyboardParser.setBlockMode();
        this.setMode(1);
        this.statusLine.setStatus("BLOCK");
    }

    public void doSetBufferAddress(int n, int n2) {
        this.debug("doSetBufferAddress " + n + "," + n2);
        this.modes[this.currentMode].doSetBufferAddress(n, n2);
    }

    public void doDataCompression(int n, char c) {
        this.debug("doDataCompression " + n + "*'" + c + "'");
        for (int i = 0; i < n; ++i) {
            this.modes[this.currentMode].hostChar(c);
        }
    }

    public void doSetCursorAddress(int n, int n2) {
        this.debug("doSetCursorAddress " + n + "," + n2);
        this.modes[this.currentMode].doSetCursorAddress(false, n, n2);
    }

    public void doDefineFieldAttribute(int n, int n2, boolean bl, int n3) {
        this.debug("doDefineFieldAttribute " + n + "," + n2 + "fixed=" + bl + " row = " + n3);
        this.modes[this.currentMode].doDefineFieldAttribute(n, n2, bl, n3);
    }

    public void doStartField(FieldAttributes fieldAttributes) {
        this.debug("doStartField " + fieldAttributes);
        this.modes[this.currentMode].doStartField(fieldAttributes);
    }

    public void doPrintScreenOrPage() {
        this.notImplemented("doPrintScreenOrPage");
    }

    public void doSetTab() {
        this.debug("doSetTab");
        this.modes[this.currentMode].doSetTab();
    }

    public void doClearTab() {
        this.debug("doClearTab");
        this.modes[this.currentMode].doClearTab();
    }

    public void doClearAllTabs() {
        this.debug("doClearAllTabs");
        this.modes[this.currentMode].doClearAllTabs();
    }

    public void doSetVideoAttributes(char c) {
        this.debug("doSetVideoAttributes");
        this.modes[this.currentMode].doSetVideoAttribute(c & 0x1F);
    }

    public void doSetVideoPriorConditionRegister(char c) {
        this.debug("doSetVideoPriorConditionRegister");
        this.modes[this.currentMode].doSetDefaultVideoAttribute(c & 0x1F);
    }

    public void doSet40CharLineWidth() {
        this.debug("doSet40CharLineWidth");
    }

    public void doSet80CharLineWidth() {
        this.debug("doSet80CharLineWidth");
    }

    public void doReadCursorAddress() {
        this.debug("doReadCursorAddress");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0001').append('!');
        stringBuffer.append((char)(32 + this.modes[this.currentMode].getPage()));
        stringBuffer.append((char)(31 + this.modes[this.currentMode].getRow()));
        stringBuffer.append((char)(31 + this.modes[this.currentMode].getCol()));
        if (this.currentMode == 0) {
            stringBuffer.append('\r');
        } else {
            stringBuffer.append('\u0003');
            stringBuffer.append('\u0000');
        }
        this.send(stringBuffer.toString());
    }

    public void doUnlockKeyboard() {
        this.debug("doUnlockKeyboard");
        this.keyboardLocked = false;
        this.statusLine.setStatus(this.currentMode == 0 ? "CONV" : "BLOCK");
    }

    public void doLockKeyboard() {
        this.debug("doLockKeyboard");
        this.keyboardLocked = true;
        this.statusLine.setStatus("KBD LOCKED");
    }

    public void doSetStringConfigurationParameter(String[] stringArray) {
        this.debug("doSetStringConfigurationParameter");
    }

    public void doReadStringConfigurationParameter(int n) {
        this.debug("doReadStringConfigurationParameter");
    }

    public void doSimulateFunctionKey(char c) {
        this.debug("doSimulateFunctionKey");
        this.sendFunctionKey(c);
    }

    public void doGetMachineName() {
        this.debug("doGetMachineName");
    }

    public void doDisconnectModem() {
        this.debug("doDisconnectModem");
    }

    public void doGetCurrentDirectoryAndRedirectionInformation(char c) {
        this.debug("doGetCurrentDirectoryAndRedirectionInformation");
    }

    public void doReadVTLAUNCHConfigurationParameter(int n) {
        this.debug("doReadVTLAUNCHConfigurationParameter");
    }

    public void doBackTab() {
        this.debug("doBackTab");
        this.modes[this.currentMode].doBackTab();
    }

    public void doRTMControl(int n, int[] nArray) {
        this.debug("doRTMControl");
        this.notImplemented("RTM, Control");
    }

    public void doRTMDataUpload(int[] nArray) {
        this.debug("doRTMDataUpload");
        this.notImplemented("RTM, Data Upload");
    }

    public void doSetEM3270Mode(int n) {
        this.debug("doSetEM3270Mode");
        this.notImplemented("EM3270, Set EM3270 mode");
    }

    public void doReadAllLocations() {
        this.debug("doReadAllLocations");
        this.notImplemented("EM3270, Read All Locations");
    }

    public void doReadKeyboardLatch() {
        this.debug("doReadKeyboardLatch");
        this.notImplemented("EM3270, Read Keyboard Latch");
    }

    public void doWriteToMessageField(char[] cArray, char[] cArray2) {
        this.debug("doWriteToMessageField");
        this.statusLine.setMessage(cArray, cArray2);
    }

    public void doSetMaxPageNumber(int n) {
        this.debug("doSetMaxPageNumber");
        this.modes[this.currentMode].doSetMaxPageNumber(n);
    }

    public void doReinitialize() {
        this.debug("doReinitialize");
        this.doSetBlockMode();
    }

    public void doSetColorMapTable(int n, byte[] byArray) {
        this.debug("doSetColorMapTable");
        this.colorMap.set(n, byArray);
    }

    public void doResetColorMapTable() {
        this.debug("doResetColorMapTable");
        this.colorMap.reset();
    }

    public void doReadColorMappingTable() {
        this.debug("doReadColorMappingTable");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0001').append('0');
        stringBuffer.append(this.colorMap.read());
        if (this.currentMode == 0) {
            stringBuffer.append('\r');
        } else {
            stringBuffer.append((char)(32 + MAX_PAGES));
            stringBuffer.append('\u0003');
            stringBuffer.append('\u0000');
        }
        this.send(stringBuffer.toString());
    }

    public void doDefineDataTypeTable(int n, byte[] byArray) {
        this.debug("doDefineDataTypeTable");
        this.modes[this.currentMode].doDefineDataTypeTable(n, byArray);
    }

    public void doResetVariableTable() {
        this.debug("doResetVariableTable");
        this.modes[this.currentMode].doResetVariableTable();
    }

    public void doDefineVariableTable(int n, FieldAttributes[] fieldAttributesArray) {
        this.debug("doDefineVariableTable");
        this.modes[this.currentMode].doDefineVariableTable(n, fieldAttributesArray);
    }

    public void doSet40CharactersScreenWidth() {
        this.debug("doSet40CharactersScreenWidth");
    }

    public void doSetColorConfiguration(int n, byte[] byArray) {
        this.debug("doSetColorConfiguration");
        this.notImplemented("Color, Set Color Configuration");
    }

    public void doResetColorConfiguration() {
        this.debug("doResetColorConfiguration");
        this.notImplemented("Color, Reset Color Configuration");
    }

    public void doReadColorConfiguration() {
        this.debug("doReadColorConfiguration");
        this.notImplemented("Color, Read Color Configuration");
    }

    public void doDefineEnterKeyFunction(char[] cArray) {
        this.debug("doDefineEnterKeyFunction");
        this.convMode.setEnterKeyFunction(cArray);
    }

    public void doSetTerminalConfiguration(ConfigParameter[] configParameterArray) {
        this.debug("doSetTerminalConfiguration");
        if (configParameterArray == null) {
            return;
        }
        block29: for (int i = 0; i < configParameterArray.length; ++i) {
            switch (configParameterArray[i].getCode()) {
                case 'A': {
                    int n = configParameterArray[i].getValue();
                    if (n != 1 && n != 3) continue block29;
                    this.options[Terminal6530.OPT_CURSOR_TYPE] = n;
                    continue block29;
                }
                case 'B': {
                    int n = configParameterArray[i].getValue();
                    if (0 > n || n > 80) continue block29;
                    this.options[Terminal6530.OPT_BELL_COLUMN] = n;
                    continue block29;
                }
                case 'C': {
                    int n = configParameterArray[i].getValue();
                    if (n != 0 && n != 10) continue block29;
                    this.options[Terminal6530.OPT_BELL_VOLUME] = n;
                    continue block29;
                }
                case 'D': {
                    this.notImplemented("Setting of keyboard click");
                    continue block29;
                }
                case 'E': {
                    continue block29;
                }
                case 'F': {
                    int n = configParameterArray[i].getValue();
                    if ((0 > n || n > 14 || n == 9) && (19 > n || n > 32 || n == 28)) continue block29;
                    this.options[Terminal6530.OPT_LANGUAGE] = n;
                    continue block29;
                }
                case 'G': {
                    int n = configParameterArray[i].getValue();
                    if (n != 0 && n != 3) continue block29;
                    this.options[Terminal6530.OPT_MODE] = n;
                    continue block29;
                }
                case 'H': {
                    int n = configParameterArray[i].getValue();
                    if (0 > n || n > 16) continue block29;
                    this.options[Terminal6530.OPT_BAUD_RATE] = n;
                    continue block29;
                }
                case 'I': {
                    int n = configParameterArray[i].getValue();
                    if (1 > n || n > 3) continue block29;
                    this.options[Terminal6530.OPT_PARITY] = n;
                    continue block29;
                }
                case 'J': {
                    int n = configParameterArray[i].getValue();
                    if (n != 0 && n != 1) continue block29;
                    this.options[Terminal6530.OPT_DUPLEX] = n;
                    this.convMode.setHalfDuplex(n == 1);
                    continue block29;
                }
                case 'K': {
                    continue block29;
                }
                case 'L': {
                    int n = configParameterArray[i].getValue();
                    if (0 > n || n > 8) continue block29;
                    this.options[Terminal6530.OPT_PACKET_BLOCKING] = n;
                    continue block29;
                }
                case 'M': {
                    int n = configParameterArray[i].getValue();
                    if (n == 1) {
                        this.enterIsFuctionKey = true;
                        continue block29;
                    }
                    if (n != 0) continue block29;
                    this.enterIsFuctionKey = false;
                    continue block29;
                }
                case 'N': {
                    continue block29;
                }
                case 'O': {
                    continue block29;
                }
                case 'P': {
                    int n = configParameterArray[i].getValue();
                    if (0 > n || n > 20) continue block29;
                    this.options[Terminal6530.OPT_SCREEN_SAVER] = n;
                    continue block29;
                }
                case 'S': {
                    continue block29;
                }
                case 'T': {
                    int n = configParameterArray[i].getValue();
                    if (n != 0 && n != 1) continue block29;
                    this.options[Terminal6530.OPT_NORMAL_INTENSITY] = n;
                    continue block29;
                }
                case 'U': {
                    int n = configParameterArray[i].getValue();
                    if (0 > n || n > 80) continue block29;
                    if (n == 0) {
                        n = 1;
                    }
                    this.options[Terminal6530.OPT_LOCAL_TRANSMIT_COLUMN] = n;
                    this.convMode.setLocalTransmitColumn(n);
                    continue block29;
                }
                case 'V': {
                    int n = configParameterArray[i].getValue();
                    if (n != 0 && n != 1) continue block29;
                    this.options[Terminal6530.OPT_CHAR_SIZE] = n;
                    continue block29;
                }
                case 'W': {
                    continue block29;
                }
                case 'X': {
                    continue block29;
                }
                case 'e': {
                    this.notImplemented("Setting of color support");
                    continue block29;
                }
                case 'f': {
                    this.notImplemented("Setting of compression enhance");
                    continue block29;
                }
                case 'i': {
                    this.notImplemented("Setting of MLAN host init IXF");
                    continue block29;
                }
                case 'j': {
                    this.notImplemented("Setting of RTM support");
                    continue block29;
                }
                case 'h': {
                    this.notImplemented("Setting of EM3270 support");
                    continue block29;
                }
                default: {
                    this.debug("Got unknown configuration code " + configParameterArray[i].getCode() + ".");
                }
            }
        }
    }

    public void doRead6530ColorMappingTable() {
        this.notImplemented("Color, Read 6530 Color Mapping Table");
    }

    public void doSetIODeviceConfiguration(int n, ConfigParameter[] configParameterArray) {
        this.debug("doSetIODeviceConfiguration");
        this.notImplemented("Aux*, Set IO Device Configuration");
    }

    public void doSet6530ColorMapping(boolean bl) {
        this.debug("doSet6530ColorMapping");
        this.notImplemented("EM3270, Set 6530 Color Mapping");
    }

    public void doReadIODeviceConfiguration(int n) {
        this.debug("doReadIODeviceConfiguration");
        this.notImplemented("Aux*, Read IO Device Configuration");
    }

    public void doTerminateRemote6530Operation(int n) {
        this.debug("doTerminateRemote6530Operation");
        this.notImplemented("OS stuff, Terminate Remote 6530 Operation");
    }

    public void doCursorUp() {
        this.debug("doCursorUp");
        this.modes[this.currentMode].doCursorUp();
    }

    public void doCursorRight() {
        this.debug("doCursorRight");
        this.modes[this.currentMode].doCursorRight();
    }

    public void doCursorHomeDown() {
        this.debug("doCursorHomeDown");
        this.modes[this.currentMode].doCursorHomeDown();
    }

    public void doCursorHome() {
        this.debug("doCursorHome");
        this.modes[this.currentMode].doCursorHome();
    }

    public void doRollUp() {
        this.debug("doRollUp");
        this.modes[this.currentMode].doRollUp();
    }

    public void doRollDown() {
        this.debug("doRollDown");
        this.modes[this.currentMode].doRollDown();
    }

    public void doPageUp() {
        this.debug("doPageUp");
        this.modes[this.currentMode].doPageUp();
    }

    public void doPageDown() {
        this.debug("doPageDown");
        this.modes[this.currentMode].doPageDown();
    }

    public void doClearMemoryToSpaces() {
        this.debug("doClearMemoryToSpaces");
        this.modes[this.currentMode].doClearMemoryToSpaces();
    }

    public void doClearMemoryToSpaces(int n, int n2, int n3, int n4) {
        this.debug("doClearMemoryToSpaces");
        this.modes[this.currentMode].doClearMemoryToSpaces(n, n2, n3, n4);
    }

    public void doEraseToEndOfPageOrMemory() {
        this.debug("doEraseToEndOfPageOrMemory");
        this.modes[this.currentMode].doEraseToEndOfPageOrMemory();
    }

    public void doReadWithAddress(int n, int n2, int n3, int n4) {
        this.debug("doReadWithAddress");
        this.send(this.modes[this.currentMode].doReadWithAddress(n, n2, n3, n4));
    }

    public void doEraseToEndOfLineOrField() {
        this.debug("doEraseToEndOfLineOrField");
        this.modes[this.currentMode].doEraseToEndOfLineOrField();
    }

    public void doReadWithAddressAll(int n, int n2, int n3, int n4) {
        this.debug("doReadWithAddressAll");
        this.send(this.modes[this.currentMode].doReadWithAddressAll(n, n2, n3, n4));
    }

    public void doInsertLine() {
        this.debug("doInsertLine");
        this.modes[this.currentMode].doInsertLine();
    }

    public void doDeleteLine() {
        this.debug("doDeleteLine");
        this.modes[this.currentMode].doDeleteLine();
    }

    public void doDisableLocalLineEditing() {
        this.debug("doDisableLocalLineEditing");
        this.localLineEditing = false;
    }

    public void doInsertCharacter() {
        this.debug("doInsertCharacter");
        this.modes[this.currentMode].doInsertCharacter();
    }

    public void doWriteToAux1OrAux2Device(int n, char c) {
        this.debug("doWriteToAux1OrAux2Device");
        this.notImplemented("Aux*, Write To Aux1 Or Aux2 Device");
    }

    public void doDeleteCharacter() {
        this.debug("doDeleteCharacter");
        this.modes[this.currentMode].doDeleteCharacter();
    }

    public void doReadScreenWithAllAttributes(int n, int n2, int n3, int n4) {
        this.debug("doReadScreenWithAllAttributes");
        this.notImplemented("EM3270, Read Screen With All Attributes");
    }

    public void doLoadAndExecuteAnOperatingSystemProgram(String string) {
        this.debug("doLoadAndExecuteAnOperatingSystemProgram");
        this.notImplemented("OS stuff, Load And Execute An OS Program");
    }

    public void doEnterProtectedSubmode() {
        this.debug("doEnterProtectedSubmode");
        this.setMode(2);
    }

    public void doExitProtectedSubmode() {
        this.debug("doExitProtectedSubmode");
        this.setMode(1);
    }

    public void doReportExecReturnCode() {
        this.debug("doReportExecReturnCode");
        this.notImplemented("OS stuff, Report Exec Return Code");
    }

    public void doReadTerminalConfiguration() {
        this.debug("doReadTerminalConfiguration");
        String string = "\u0001!" + this.configString('A', this.options[OPT_CURSOR_TYPE]) + this.configString('B', this.options[OPT_BELL_COLUMN]) + this.configString('C', this.options[OPT_BELL_VOLUME]) + this.configString('D', this.options[OPT_KEY_CLICK_VOLUME]) + this.configString('E', this.options[OPT_STATUS_LINE_BORDER]) + this.configString('F', this.options[OPT_LANGUAGE]) + this.configString('G', this.options[OPT_MODE]) + this.configString('H', this.options[OPT_BAUD_RATE]) + this.configString('I', this.options[OPT_PARITY]) + this.configString('J', this.options[OPT_DUPLEX]) + this.configString('K', this.options[OPT_DEFAULT_DEVICE_ID]) + this.configString('L', this.options[OPT_PACKET_BLOCKING]) + this.configString('M', this.options[OPT_RETURN_KEY_FUNCTION]) + this.configString('N', this.options[OPT_SINGLE_PAGE_SUBMODE]) + this.configString('O', this.options[OPT_SAVE_CONFIG]) + this.configString('P', this.options[OPT_SCREEN_SAVER]) + this.configString('S', this.options[OPT_SCREEN_FORMAT]) + this.configString('T', this.options[OPT_NORMAL_INTENSITY]) + this.configString('U', this.options[OPT_LOCAL_TRANSMIT_COLUMN]) + this.configString('V', this.options[OPT_CHAR_SIZE]) + this.configString('W', this.options[OPT_CHAR_SET]) + this.configString('X', this.options[OPT_KEYBOARD]) + this.configString('e', this.options[OPT_COLOR_SUPPORT]) + this.configString('f', this.options[OPT_COMPRESSION_ENHANCE]) + this.configString('i', this.options[OPT_MLAN_HOST_INIT]) + this.configString('j', this.options[OPT_RTM_SUPPORT]);
        switch (this.options[OPT_EM3270_SUPPORT]) {
            case 0: {
                string = string + "h00";
                break;
            }
            case 1: {
                string = string + "h01";
                break;
            }
            case 10: {
                string = string + "h10";
                break;
            }
            case 11: {
                string = string + "h11";
            }
        }
        if (this.currentMode == 0) {
            string = string + '\r';
        } else {
            string = string + '\u0003';
            string = string + '\u0000';
        }
        this.send(string);
    }

    public void doReadTerminalStatus() {
        this.debug("doReadTerminalStatus");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0001').append('?');
        if (!this.powerUp) {
            stringBuffer.append('A');
            this.powerUp = true;
        } else {
            stringBuffer.append('C');
        }
        stringBuffer.append('F');
        stringBuffer.append(MY_REVISION.charAt(0));
        if (this.currentMode == 0) {
            stringBuffer.append('\r');
        } else {
            stringBuffer.append((char)(32 + MAX_PAGES));
            stringBuffer.append('?');
            stringBuffer.append('>');
            stringBuffer.append('\u0003');
            stringBuffer.append('\u0000');
        }
        this.send(stringBuffer.toString());
    }

    public void doReadFullRevisionLevel() {
        this.debug("doReadFullRevisionLevel");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0001').append('#');
        stringBuffer.append(MY_REVISION);
        stringBuffer.append("T0");
        stringBuffer.append(MY_REVISION);
        if (this.currentMode == 0) {
            stringBuffer.append('\r');
        } else {
            stringBuffer.append('\u0003');
            stringBuffer.append('\u0000');
        }
        this.send(stringBuffer.toString());
    }

    public void doDelayOneSecond() {
        this.debug("doDelayOneSecond");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void doResetMoifiedDataTags() {
        this.debug("doResetMoifiedDataTags");
        this.modes[this.currentMode].doResetMoifiedDataTags();
    }

    public void doReadWholePageOrBuffer() {
        this.debug("doReadWholePageOrBuffer");
        this.send(this.modes[this.currentMode].doReadWholePageOrBuffer());
    }

    public void doDisplayPage(int n) {
        this.debug("doDisplayPage " + n);
        if (n == 0) {
            this.viewBlankPage = true;
            this.doLockKeyboard();
            this.repaint();
            this.statusLine.setMessage("blank page");
        } else {
            this.viewBlankPage = false;
            this.modes[this.currentMode].doDisplayPage(n);
            this.statusLine.setMessage("");
        }
    }

    public void doSelectPage(int n) {
        this.debug("doSelectPage " + n);
        this.modes[this.currentMode].doSelectPage(n);
    }

    public void doStartEnhancedColorField(IBM3270FieldAttributes iBM3270FieldAttributes) {
        this.debug("doStartEnhancedColorField");
        this.notImplemented("EM3270, Enhanced Color Field");
    }

    public void doStartFieldExtended(FieldAttributes fieldAttributes) {
        this.debug("doStartFieldExtended");
        this.modes[this.currentMode].doStartFieldExtended(fieldAttributes);
    }

    public void doWriteToFileOrDeviceName(String string, int n, byte[] byArray) {
        this.debug("doWriteToFileOrDeviceName");
        this.notImplemented("Write to file or device");
    }

    public void doWriteOrReadToFileOrDeviceName(String string, int n, byte[] byArray) {
        this.debug("doWriteOrReadToFileOrDeviceName");
        this.notImplemented("Write/read to file or device");
    }

    public String terminalType() {
        this.debug("terminalType");
        return MY_NAME;
    }

    public void reset() {
        this.debug("reset");
        this.modes[this.currentMode].switchReset();
    }

    public int getRows() {
        this.debug("getRows");
        return STATUS_LINE + 1;
    }

    public int getCols() {
        this.debug("getCols");
        return COLUMNS;
    }

    public synchronized void keyHandler(char c, int n, int n2) {
        this.debug("keyHandler: '" + c + "' (" + c + ") " + n + " " + n2);
        if (this.haveError) {
            this.haveError = false;
            this.statusLine.resetError();
        }
        if (n == 8) {
            if ((n2 & 2) != 0) {
                this.softReset();
                return;
            }
            if ((n2 & 8) != 0) {
                this.programReset();
                return;
            }
        }
        if (n == 53 && (n2 & 2) != 0) {
            this.DEBUG = !this.DEBUG;
            this.debug("Turning debug on...");
            return;
        }
        if (this.keyboardLocked) {
            return;
        }
        if (n == 33 && (n2 & 2) == 2) {
            this.showStatusLine = true;
            this.updateLine(STATUS_LINE);
            return;
        }
        if (n == 34 && (n2 & 2) == 2) {
            this.showStatusLine = false;
            this.updateLine(STATUS_LINE);
            return;
        }
        if (this.handleFunctionKey(c, n, n2)) {
            return;
        }
        if (n == 19 || n == 145) {
            this.termWin.sendBreak();
            return;
        }
        this.modes[this.currentMode].keyHandler(c, n, n2);
    }

    public void mouseHandler(int n, int n2, int n3, boolean bl, int n4) {
        this.debug("mouseHandler");
        if (this.keyboardLocked) {
            return;
        }
        if (n2 == STATUS_LINE) {
            return;
        }
        if (!bl) {
            this.modes[this.currentMode].doSetCursorAddress(true, n2 + 1, n3 + 1);
        }
    }

    public void setUpdate(boolean bl) {
        this.doupdate = bl;
    }

    public synchronized void fromHost(char c) {
        int n = 256;
        try {
            n = this.hostParser.parse(c);
        }
        catch (ParseException parseException) {
            this.error(parseException.getMessage());
            return;
        }
        if (n != 256) {
            this.modes[this.currentMode].hostChar(c);
        }
    }

    public void setTerminalWindow(TerminalWindow terminalWindow) {
        this.debug("setTerminalWindow");
        this.termWin = terminalWindow;
    }

    public void setDisplay(DisplayView displayView) {
        this.debug("setDisplay");
        this.display = displayView;
        this.statusLine.setDisplay(displayView);
        this.modes[this.currentMode].setDisplay(displayView);
        if (displayView != null) {
            displayView.setModel(this);
            displayView.setGeometry(STATUS_LINE + 1, COLUMNS);
        }
    }

    public void close() {
        this.display = null;
        this.termWin = null;
    }

    public static TerminalOption[] getTerminalOptions() {
        return optionsDef;
    }

    public void setProperties(Properties properties) {
        this.debug("setProperties");
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.setProperty(string, string2);
        }
    }

    public boolean setProperty(String string, String string2) {
        return this.setProperty(string, string2, false);
    }

    public boolean setProperty(String string, String string2, boolean bl) {
        this.debug("setProperty");
        boolean bl2 = false;
        String string3 = this.getProperty(string);
        boolean bl3 = Boolean.valueOf(string2);
        if (string3 != null && string3.equals(string2)) {
            bl2 = true;
            if (!bl) {
                return true;
            }
        }
        if (optColorMapping.getKey().equals(string)) {
            if (!string2.equals(string3)) {
                this.colorSupport = bl3;
                if (this.display != null) {
                    this.display.updateDirtyArea(0, 0, STATUS_LINE + 1, COLUMNS);
                    if (this.doupdate) {
                        this.display.repaint();
                    }
                }
            }
        } else {
            return false;
        }
        ((Hashtable)this.props).put(string, string2);
        if (!bl2) {
            this.propsChanged = true;
        }
        return true;
    }

    public Properties getProperties() {
        this.debug("getProperties");
        return this.props;
    }

    public String getProperty(String string) {
        this.debug("getProperty");
        return this.props.getProperty(string);
    }

    public boolean getPropsChanged() {
        this.debug("getPropsChanged");
        return this.propsChanged;
    }

    public void setPropsChanged(boolean bl) {
        this.debug("setPropsChanged");
        this.propsChanged = bl;
    }

    public String getDefaultProperty(String string) {
        this.debug("getDefaultProperty");
        return defaultProperties.getProperty(string);
    }

    public TerminalOption[] getOptions() {
        this.debug("getOptions");
        return optionsDef;
    }

    public SearchContext search(SearchContext searchContext, String string, boolean bl, boolean bl2) {
        this.debug("search: key='" + string + "'");
        return this.modes[this.currentMode].search(searchContext, string, bl, bl2);
    }

    private void makeTerminalReady() {
        if (this.currentMode != 0) {
            this.doSetConversationalMode();
        }
    }

    public void setAttributeBold(boolean bl) {
        this.debug("setAttributeBold");
        this.makeTerminalReady();
        if (bl) {
            this.doSetVideoAttributes('\"');
        } else {
            this.doSetVideoAttributes(' ');
        }
    }

    public void clearScreen() {
        this.debug("clearScreen");
        this.makeTerminalReady();
        this.modes[this.currentMode].doClearMemoryToSpaces();
    }

    public void ringBell() {
        this.debug("ringBell");
        this.doBell();
    }

    public void setCursorPos(int n, int n2) {
        this.debug("setCursorPos");
        this.makeTerminalReady();
        this.modes[this.currentMode].doSetCursorAddress(true, n + 1, n2 + 1);
    }

    public void clearLine() {
        this.debug("clearLine");
        this.makeTerminalReady();
        int n = this.modes[this.currentMode].getRow();
        this.modes[this.currentMode].doSetCursorAddress(true, n, 1);
        this.modes[this.currentMode].doEraseToEndOfLineOrField();
    }

    public boolean setSize(int n, int n2) {
        this.debug("setSize");
        if (this.display != null) {
            this.display.setGeometry(this.getRows(), this.getCols());
        }
        return true;
    }

    public boolean setSaveLines(int n) {
        this.debug("setSaveLines");
        return true;
    }

    public void clearSaveLines() {
        this.debug("clearSaveLines");
    }

    public void paste(String string) {
        this.debug("paste");
        if (string == null) {
            return;
        }
        for (int i = 0; i < string.length(); ++i) {
            this.keyHandler(string.charAt(i), 0, 0);
        }
    }

    public void doClickSelect(int n, int n2, int n3, String string) {
        this.debug("doClickSelect");
        if (n2 == STATUS_LINE) {
            return;
        }
        this.modes[this.currentMode].doClickSelect(n + n2, n3, string);
    }

    public String getSelection(String string) {
        this.debug("getSelection");
        return this.modes[this.currentMode].getSelection(string);
    }

    public void setSelection(int n, int n2, int n3, int n4, int n5) {
        this.debug("setSelection1");
        if (n2 == STATUS_LINE || n4 == STATUS_LINE) {
            return;
        }
        this.setSelection(n + n2, n3, n + n4, n5);
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        this.debug("setSelection2");
        this.modes[this.currentMode].setSelection(n, n2, n3, n4);
    }

    public void selectAll() {
        this.debug("selectAll");
        this.modes[this.currentMode].selectAll();
    }

    public void resetSelection() {
        this.debug("resetSelection");
        this.modes[this.currentMode].resetSelection();
    }

    public void resetClickSelect() {
        this.debug("resetClickSelect");
        this.modes[this.currentMode].resetClickSelect();
    }

    public void setInputCharset(String string) {
        this.debug("setInputCharset");
    }

    public char[] getChars(int n, int n2) {
        if (!this.viewBlankPage && 0 <= n2 && n2 <= STATUS_LINE - 1) {
            return this.modes[this.currentMode].getChars(n, n2);
        }
        if (n2 == STATUS_LINE && this.showStatusLine) {
            return this.statusLine.getChars();
        }
        return null;
    }

    public int[] getAttribs(int n, int n2) {
        if (!this.viewBlankPage && 0 <= n2 && n2 <= STATUS_LINE - 1) {
            int[] nArray = this.modes[this.currentMode].getAttribs(n, n2);
            if (nArray == null) {
                return null;
            }
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray2.length; ++i) {
                if (this.colorSupport) {
                    nArray2[i] = this.colorMap.map(nArray[i]);
                    continue;
                }
                nArray2[i] = 32768;
                if ((nArray[i] & ATTR_6530_DIM_INTENSITY) != 0) {
                    int n3 = i;
                    nArray2[n3] = nArray2[n3] | 2;
                }
                if ((nArray[i] & ATTR_6530_BLINKING) != 0) {
                    int n4 = i;
                    nArray2[n4] = nArray2[n4] | 8;
                }
                if ((nArray[i] & ATTR_6530_REVERSE_VIDEO) != 0) {
                    int n5 = i;
                    nArray2[n5] = nArray2[n5] | 0x10;
                }
                if ((nArray[i] & ATTR_6530_INVISIBLE) != 0) {
                    int n6 = i;
                    nArray2[n6] = nArray2[n6] | 0x20;
                }
                if ((nArray[i] & ATTR_6530_UNDERSCORE) == 0) continue;
                if (i > 0) {
                    if ((nArray[i - 1] & ATTR_6530_UNDERSCORE) == 0) continue;
                    int n7 = i;
                    nArray2[n7] = nArray2[n7] | 4;
                    continue;
                }
                int n8 = i;
                nArray2[n8] = nArray2[n8] | 4;
            }
            return nArray2;
        }
        if (n2 == STATUS_LINE && this.showStatusLine) {
            return this.statusLine.getAttribs();
        }
        return null;
    }

    public int getDisplayRows() {
        this.debug("getDisplayRows");
        return this.getRows();
    }

    public int getDisplayCols() {
        this.debug("getDisplayCols");
        return this.getCols();
    }

    public int getBufferRows() {
        this.debug("getBufferRows");
        return this.modes[this.currentMode].getBufferRows() + 1;
    }

    public void send(char c) {
        this.debug("send: '" + c + "' (" + c + ")");
        if (this.termWin != null) {
            this.termWin.typedChar(c);
        }
    }

    public void send(String string) {
        this.debug("send: " + string);
        if (this.termWin != null && string != null) {
            char[] cArray = string.toCharArray();
            if (this.DEBUG) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < cArray.length; ++i) {
                    if (Character.isLetterOrDigit(cArray[i]) || cArray[i] == ' ') {
                        stringBuffer.append(cArray[i]);
                    } else {
                        stringBuffer.append('.');
                    }
                    stringBuffer.append(" (");
                    stringBuffer.append(Integer.toHexString(cArray[i]));
                    stringBuffer.append(")\n");
                }
                this.debug(stringBuffer.toString());
            }
            this.termWin.sendBytes(string.getBytes());
        }
    }

    public void error(String string) {
        this.debug("error: " + string);
        this.haveError = true;
        this.statusLine.setError(string);
        this.doBell();
    }

    public void statusLineUpdated() {
        this.updateLine(STATUS_LINE);
    }

    private String configString(char c, int n) {
        if (n < 10) {
            return c + " " + n;
        }
        if (10 <= n && n < 100) {
            return c + String.valueOf(n);
        }
        if (100 <= n && n < 1000) {
            return c + String.valueOf(n);
        }
        return "";
    }

    private void debug(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }

    private void notImplemented(String string) {
        if (this.LIMITED_DEBUG) {
            System.out.println("Not implemented: " + string);
        }
    }

    private void softReset() {
        this.debug("softReset (can unlock keyboard: " + !this.viewBlankPage + ")");
        if (!this.viewBlankPage) {
            this.doUnlockKeyboard();
        }
        this.hostParser.reset();
        this.keyboardParser.reset();
    }

    private void programReset() {
        this.notImplemented("programReset()");
    }

    private boolean haveAltShift(int n) {
        return this.haveModifiers(n, 9);
    }

    private boolean haveAlt(int n) {
        return this.haveModifiers(n, 8);
    }

    private boolean isAlt(int n) {
        return n == 8;
    }

    private boolean haveShift(int n) {
        return this.haveModifiers(n, 1);
    }

    private boolean isShift(int n) {
        return n == 1;
    }

    private boolean haveCtrl(int n) {
        return this.haveModifiers(n, 2);
    }

    private boolean isCtrl(int n) {
        return n == 2;
    }

    private boolean haveNone(int n) {
        return n == 0;
    }

    private boolean haveModifiers(int n, int n2) {
        return (n & n2) == n2;
    }

    private boolean handleFunctionKey(char c, int n, int n2) {
        int n3 = 0;
        if (!this.haveCtrl(n2)) {
            switch (n) {
                case 112: {
                    if (this.haveAlt(n2)) {
                        n3 = 74;
                        break;
                    }
                    n3 = 64;
                    break;
                }
                case 113: {
                    if (this.haveAlt(n2)) {
                        n3 = 75;
                        break;
                    }
                    n3 = 65;
                    break;
                }
                case 114: {
                    if (this.haveAlt(n2)) {
                        n3 = 76;
                        break;
                    }
                    n3 = 66;
                    break;
                }
                case 115: {
                    if (this.haveAlt(n2)) {
                        n3 = 77;
                        break;
                    }
                    n3 = 67;
                    break;
                }
                case 116: {
                    if (this.haveAlt(n2)) {
                        n3 = 78;
                        break;
                    }
                    n3 = 68;
                    break;
                }
                case 117: {
                    if (this.haveAlt(n2)) {
                        n3 = 79;
                        break;
                    }
                    n3 = 69;
                    break;
                }
                case 118: {
                    n3 = 70;
                    break;
                }
                case 119: {
                    n3 = 71;
                    break;
                }
                case 120: {
                    n3 = 72;
                    break;
                }
                case 121: {
                    n3 = 73;
                    break;
                }
                case 122: {
                    n3 = 74;
                    break;
                }
                case 123: {
                    n3 = 75;
                }
            }
            if (n3 != 0 && this.haveShift(n2)) {
                n3 = (char)(n3 + 32);
            }
        }
        if (n3 == 0 && this.currentMode != 0) {
            switch (n) {
                case 38: {
                    if (!this.haveAlt(n2)) break;
                    if (!this.haveShift(n2)) {
                        n3 = 80;
                        break;
                    }
                    n3 = 112;
                    break;
                }
                case 40: {
                    if (!this.haveAlt(n2)) break;
                    if (!this.haveShift(n2)) {
                        n3 = 81;
                        break;
                    }
                    n3 = 113;
                    break;
                }
                case 34: {
                    if (this.haveNone(n2)) {
                        n3 = 82;
                        break;
                    }
                    if (!this.isAlt(n2)) break;
                    n3 = 114;
                    break;
                }
                case 33: {
                    if (this.haveNone(n2)) {
                        n3 = 83;
                        break;
                    }
                    if (!this.isAlt(n2)) break;
                    n3 = 115;
                    break;
                }
                case 155: {
                    if (this.localLineEditing || !this.isCtrl(n2)) break;
                    n3 = 84;
                    break;
                }
                case 127: {
                    if (this.localLineEditing || !this.isCtrl(n2)) break;
                    n3 = 116;
                    break;
                }
                case 10: {
                    if (!this.enterIsFuctionKey) break;
                    if (this.haveNone(n2)) {
                        n3 = 86;
                        break;
                    }
                    if (!this.isShift(n2)) break;
                    n3 = 118;
                }
            }
        }
        if (n3 != 0) {
            if (this.currentMode != 0) {
                this.doLockKeyboard();
            }
            this.sendFunctionKey((char)n3);
            return true;
        }
        return false;
    }

    private void sendFunctionKey(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0001').append(c);
        if (this.currentMode != 0) {
            stringBuffer.append((char)(32 + this.modes[this.currentMode].getPage()));
        }
        stringBuffer.append((char)(31 + this.modes[this.currentMode].getRow()));
        stringBuffer.append((char)(31 + this.modes[this.currentMode].getCol()));
        if (this.currentMode == 0) {
            stringBuffer.append('\r');
        } else {
            stringBuffer.append('\u0003');
            stringBuffer.append('\u0000');
        }
        this.send(stringBuffer.toString());
    }

    private void updateLine(int n) {
        if (this.display != null) {
            int n2 = n + this.modes[this.currentMode].getVisTop();
            this.display.updateDirtyArea(n2, 0, n2 + 1, COLUMNS);
            if (this.doupdate) {
                this.display.repaint();
            }
        }
    }

    private void setMode(int n) {
        this.debug("setMode:" + n);
        int n2 = this.currentMode;
        if (n != this.currentMode) {
            switch (n) {
                case 0: {
                    this.doUnlockKeyboard();
                    break;
                }
                case 1: {
                    this.localLineEditing = true;
                    this.doLockKeyboard();
                    break;
                }
                case 2: {
                    this.localLineEditing = false;
                    this.doLockKeyboard();
                }
            }
            this.modes[this.currentMode].setDisplay(null);
            this.currentMode = n;
            this.modes[this.currentMode].setDisplay(this.display);
            this.modes[this.currentMode].switchReset();
            if (n2 == 0 && this.currentMode == 1) {
                this.blockMode.setBuffer(this.convMode.getBuffer());
            }
            this.modes[this.currentMode].doSetDefaultVideoAttribute(0);
            this.statusLine.setMessage("");
        }
    }

    private void repaint() {
        if (this.display != null && this.doupdate) {
            this.display.repaint();
        }
    }

    static {
        optColorMapping = new TerminalOption("color-mapping", "Use colors", "false");
        optionsDef = new TerminalOption[]{optColorMapping};
        defaultProperties = new Properties();
        for (int i = 0; i < optionsDef.length; ++i) {
            ((Hashtable)defaultProperties).put(optionsDef[i].getKey(), optionsDef[i].getDefault());
        }
    }
}

