/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.util;

import java.io.OutputStream;

public final class ExpectOutputStream
extends OutputStream {
    private Expector expector;
    private byte[] captBuf;
    private int captLen;
    private byte[] boundary;
    private int matchIdx;

    public ExpectOutputStream(Expector expector) {
        this.expector = expector;
        this.captBuf = new byte[1024];
        this.captLen = 0;
        this.boundary = null;
    }

    public ExpectOutputStream(Expector expector, String string) {
        this(expector);
        this.expect(string);
    }

    public ExpectOutputStream(Expector expector, byte[] byArray, int n, int n2) {
        this(expector);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.expect(byArray2);
    }

    public void expect(String string) {
        this.expect(string.getBytes());
    }

    public synchronized void expect(byte[] byArray) {
        this.boundary = byArray;
        this.matchIdx = 0;
        if (this.captLen > 0) {
            this.write(this.captBuf, 0, this.captLen);
        }
    }

    public void write(int n) {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        boolean bl = false;
        while (!bl && n2 > 0) {
            byte by = byArray[n];
            if (this.captLen == this.captBuf.length) {
                byte[] byArray2 = this.captBuf;
                this.captBuf = new byte[this.captBuf.length * 2];
                System.arraycopy(byArray2, 0, this.captBuf, 0, this.captLen);
            }
            this.captBuf[this.captLen++] = by;
            if (!bl) {
                bl = this.boundaryReached(by);
            }
            --n2;
            ++n;
        }
        if (bl) {
            this.expector.reached(this, this.captBuf, this.captLen - this.boundary.length);
            this.matchIdx = 0;
            this.captLen = 0;
        }
        if (n2 > 0) {
            this.write(byArray, n, n2);
        }
    }

    public void close() {
        if (this.captLen > 0) {
            this.expector.closed(this, this.captBuf, this.captLen);
        }
    }

    private boolean boundaryReached(byte by) {
        if (this.boundary == null) {
            return false;
        }
        this.matchIdx = this.boundary[this.matchIdx] == by ? ++this.matchIdx : 0;
        return this.matchIdx == this.boundary.length;
    }

    public static interface Expector {
        public void reached(ExpectOutputStream var1, byte[] var2, int var3);

        public void closed(ExpectOutputStream var1, byte[] var2, int var3);
    }
}

