/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.util;

import java.io.OutputStream;
import java.math.BigInteger;

public class HexDump {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String intToString(int n) {
        char[] cArray = new char[8];
        for (int i = 7; i >= 0; --i) {
            cArray[i] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
        }
        return new String(cArray);
    }

    public static String toString(byte[] byArray) {
        return HexDump.toString(byArray, 0, byArray.length);
    }

    public static String toString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = n;
        int n4 = 0;
        while (n3 < n + n2) {
            byte by = byArray[n3++];
            cArray[n4++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n4++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    public static String formatHex(int n, int n2) {
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public static void print(byte[] byArray, int n, int n2) {
        HexDump.print(System.err, null, true, byArray, n, n2);
    }

    public static void print(OutputStream outputStream, byte[] byArray, int n, int n2) {
        HexDump.print(outputStream, null, true, byArray, n, n2);
    }

    public static void print(String string, boolean bl, byte[] byArray, int n, int n2) {
        HexDump.print(System.err, string, bl, byArray, n, n2);
    }

    public static synchronized void print(OutputStream outputStream, String string, boolean bl, byte[] byArray, int n, int n2) {
        if (string != null) {
            try {
                outputStream.write(string.getBytes());
                outputStream.write("\r\n".getBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (int i = 0; i < n2; i += 16) {
            int n3;
            int n4;
            int n5;
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                stringBuffer.append(HexDump.formatHex(i + n, 8));
                stringBuffer.append(": ");
            }
            n5 = (n5 = n2 - i) > 16 ? 16 : n5;
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = (byArray[n + i + n4] + 256) % 256;
                stringBuffer.append(HexDump.formatHex(n3, 2));
                if (n4 % 2 != 1) continue;
                stringBuffer.append(" ");
            }
            while (n4 < 16) {
                stringBuffer.append("  ");
                if (n4 % 2 == 1) {
                    stringBuffer.append(" ");
                }
                ++n4;
            }
            stringBuffer.append(" ");
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = (byArray[n + i + n4] + 256) % 256;
                n3 = n3 < 32 || n3 >= 127 ? 46 : n3;
                stringBuffer.append((char)n3);
            }
            try {
                outputStream.write(stringBuffer.toString().getBytes());
                outputStream.write("\r\n".getBytes());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void print(byte[] byArray) {
        if (byArray == null) {
            System.err.println("<null>");
            return;
        }
        HexDump.print(byArray, 0, byArray.length);
    }

    public static void print(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 1 && byArray[0] == 0) {
            byArray = new byte[]{};
        }
        HexDump.print(byArray);
    }
}

