/*
     udplogger - A UDP traffic logger
     Copyright (C) 1993 Douglas Lee Schales, David K. Hess, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.

pktfilt.c - 03/20/93

*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <net/nit_pf.h>
#include <net/packetfilt.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/if_ether.h>
#include <sys/stropts.h>
#include <netdb.h>

#define offsetof(T, m) ((size_t)&(((T *)0)->m))

/*
  Rename some of the packet filter operators so that
   the names reflect what they actually do
*/

/* Short circuit if equal and keep packet */
#define ENF_CEQ ENF_COR
/* Short circuit if not equal and keep packet */
#define ENF_CNE ENF_CNAND
/* Short circuit if equal and reject packet */
#define ENF_CREQ ENF_NOR
/* Short circuit if not equal and reject packet */
#define ENF_CRNE ENF_CAND

void
pushfilter(int fd)
{
     struct packetfilt pf;
     u_short *ptr;
     struct servent *se;

     pf.Pf_Priority = 0;
     ptr = pf.Pf_Filter;
     *ptr++ = ENF_PUSHWORD + 6;
     *ptr++ = ENF_PUSHLIT|ENF_CRNE;
     *ptr++ = htons(ETHERTYPE_IP);
     *ptr++ = ENF_PUSHWORD + 11;
     *ptr++ = ENF_PUSHLIT|ENF_AND;
     *ptr++ = 0xff;
     *ptr++ = ENF_PUSHLIT|ENF_CRNE;
     *ptr++ = 17; /* UDP */

     pf.Pf_FilterLen = ptr - &pf.Pf_Filter[0];

     if(ioctl(fd, NIOCSETF, &pf) == -1)
	  perror("pf setf");
}

     
