#define _BSD_SOURCE
/* BSD compatibility */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <netdb.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>


struct pseudo {
	u_long saddr;
	u_long daddr;
	u_char zero;
	u_char protocol;
	u_short length;
};

/* diz piece is ripped off.. who carez */
unsigned short
in_cksum (unsigned short *ptr, int nbytes)
{

  register long sum;		/* assumes long == 32 bits */
  u_short oddbyte;
  register u_short answer;	/* assumes u_short == 16 bits */

  /*
   * Our algorithm is simple, using a 32-bit accumulator (sum),
   * we add sequential 16-bit words to it, and at the end, fold back
   * all the carry bits from the top 16 bits into the lower 16 bits.
   */

  sum = 0;
  while (nbytes > 1)
    {
      sum += *ptr++;
      nbytes -= 2;
    }

  /* mop up an odd byte, if necessary */
  if (nbytes == 1)
    {
      oddbyte = 0;		/* make sure top half is zero */
      *((u_char *) & oddbyte) = *(u_char *) ptr;	/* one byte only */
      sum += oddbyte;
    }

  /*
   * Add back carry outs from top 16 bits to low 16 bits.
   */

  sum = (sum >> 16) + (sum & 0xffff);	/* add high-16 to low-16 */
  sum += (sum >> 16);		/* add carry */
  answer = ~sum;		/* ones-complement, then truncate to 16 bits */
  return (answer);
}

int sendtcp( int s, /* raw socket descriptor */
		u_long srcaddr, u_short srcport, /* src addr, port */
		u_long dstaddr, u_short dstport, /* dst addr, port */
		u_short th_flags, /* tcp packet flags */
		u_char *packet_body,u_long length, /* packet body / length */
		u_char *fmt, /*  additional format-string args (see below)*/
		...)/* we can accept other parameters as well
		     *  basically they should be:
		     *  const char *name
		     *  apropriate_type value
		     *
		     *  where name, is an additional value we want to
		     *  pass, and value, is it's value.
		     *
		     *  following values are recognized:
		     *  v - ip_v version (default 4, do you need other?)
		        u_char
		     *  h - ip_hl header length (we only can change diz value
		     *  	     the size of IP is hardcoded, yet).
		        u_char
		     *  i - ip_id IP ID  (IP packet ID) (default is random)
		        u_short
		     *  t - ip_ttl IP time-to-live (time to live default 0xff)
		        u_char
		     *  o - ip_off IP offset       (offset, default is 0)
		        u_short
		     *  l - ip_len (if different, useful for some exploits)
		        u_short
		     *  s - ip_tos  type of service.
		        u_char
		     *  f - IP flags (sits in first 3 bytes of ip_off;
		        u_char (will use only 3 lower bites)
		     * 
		     *  S - th_seq TCP SEQ (default is randomized)
		        u_long
		     *  A - th_ack TCP ACK (....)
		        u_long
		     *  O - th_off TCP data offset. (hardcoded, you can change
		     *          this value only).
		       u_char
		     *  u - th_urp  TCP urgent pointer.
		       u_short
*  example
*
sendtcp(rawfd,srcip.s_addr,srcport,dstip.s_addr,dstport,TH_SYN,pack,20
"vhSA",4,5,0,20);
 will cause a packet being send with additional parameters:
 version -- 4; ipheader length - 5, Seq - 0, ack - 20;
		     * */
		 {

	u_char *packet,*content;
	struct sockaddr_in foo;
	struct in_addr srcinaddr,dstinaddr;
	struct ip *ip;
	struct pseudo *pseudo;
	struct tcphdr *tcp;
	va_list v;
	/* additinal variables; */
	u_char dip_v,dip_hl,dip_tos,dip_ttl,dth_off;
	u_short dip_id,dip_off,dip_len,dth_urp;
	u_long dth_seq,dth_ack;

	/* default values (if no arguments are passed */
	dip_v = 4;
	dip_hl= 5;
	dip_tos = 0;
	dip_ttl = 0xff;
	dth_off = 5;
	dip_id = htons(rand()^0xffff);
	dip_off = 0;
	dip_len = sizeof(struct ip) + sizeof(struct tcphdr) + length;
	dth_urp = 0;
	dth_seq=htonl(rand());
	dth_ack=htonl(rand());
	
	packet = (u_char *)malloc(sizeof(struct ip) + sizeof(struct pseudo) 
			+ sizeof(struct tcphdr)+length);
	bzero(packet, sizeof(packet));
	bzero(&foo,sizeof(foo));

	ip = (struct ip *) packet;
	pseudo = (struct pseudo *) (packet + sizeof(struct ip));
	tcp = (struct tcphdr *) (packet + sizeof(struct ip) 
				+ sizeof(struct pseudo));
	content = packet + sizeof(struct ip) + sizeof(struct tcphdr);
	
	/* only BSD, linux has plain u_long declared */
	srcinaddr.s_addr = srcaddr;
	dstinaddr.s_addr = dstaddr;

/* check for passed additional arguments */
	if(fmt) { /* sanity check */
		va_start(v,fmt);
		while(*fmt) {
			switch(*fmt++) {
				case 'v': /* version */
					dip_v = va_arg(v,u_char);
					break;
				case 'h': /* header length */
					dip_hl = va_arg(v,u_char);
					break;
				case 'i':/* ip id */
					dip_id = htons(va_arg(v,u_short));
					break;
				case 't':/* ttl */
					dip_ttl = va_arg(v,u_char);
					break;
				case 'o': /* ip offset */
					dip_off = htons(va_arg(v,u_short));
					break;
				case 'f': /* if flags */
					dip_off |= (va_arg(v,u_char)<<5);
					break;
		     		case 'l': /* ip len */
					dip_len = va_arg(v,u_short);
					break;
				case 's': /* ip type of service */
					dip_tos = va_arg(v,u_char);
					break;
				case 'S': /* tcp SEQ */
					dth_seq = htonl(va_arg(v,u_long));
					break;
				case 'A': /* tcp ACK */
					dth_ack = htonl(va_arg(v,u_long));
					break;
				case 'O': /* tcp data offset */
					dth_off = va_arg(v,u_char);
					break;
				case 'u': /* urgent pointer */
					dth_urp = va_arg(v,u_short);
					break;
				default: return -1; /* unknown format */
			}/*switch*/
		}/*while*/
		va_end(v);
	}
	
/* building packets */
	/* filling in pseudo for checksum */
			pseudo->saddr = srcaddr;
			pseudo->daddr = dstaddr;
			pseudo->zero = 0;
			pseudo->protocol=IPPROTO_TCP;
			pseudo->length = htons(sizeof (struct tcphdr));
	/* ip packet */
			ip->ip_v = dip_v;
			ip->ip_hl = dip_hl;
			ip->ip_id = dip_id;
			ip->ip_tos= dip_tos;
			ip->ip_src = srcinaddr;
			ip->ip_dst = dstinaddr;
			ip->ip_p = IPPROTO_TCP;
			ip->ip_ttl = dip_ttl;
			ip->ip_off = dip_off;
			ip->ip_len = dip_len;
			ip->ip_sum = in_cksum((u_short *)ip,sizeof(struct ip));
	/* tcp packet */
			tcp->th_sport = htons(srcport);
			tcp->th_dport = htons(dstport);
			tcp->th_seq = dth_seq;
			tcp->th_ack = dth_ack;
			tcp->th_off = dth_off;
			tcp->th_flags = th_flags;
			tcp->th_urp = dth_urp;
			tcp->th_sum = in_cksum((u_short *) pseudo,
					sizeof(struct pseudo) +
					 sizeof(struct tcphdr));
		/* remove pseudoheader */
			bcopy(tcp,pseudo,sizeof(struct tcphdr));
		/* if packet body is not null, copy that */	
			if(packet_body) bcopy(packet_body,content,length);
			
			foo.sin_family=AF_INET;
			foo.sin_addr.s_addr=dstaddr;
		/* sending packet */	
	return(sendto(s,packet,sizeof(struct ip) + 
					sizeof(struct tcphdr) + length, 0,
					(struct sockaddr *) &foo,sizeof(foo)));

}

u_long resolve_name(char *hostname) {
	struct hostent *host;
	u_long addr;
	if ((addr = inet_addr(hostname)) != -1) return addr;
	if ((host = gethostbyname(hostname)) == NULL) {
		fprintf(stderr,"Can not resolve name: %s\n",hostname);
		exit(1);
	}
	bcopy(host->h_addr,&addr,host->h_length);
	return addr;
}

