/* gives you remote Win95/98 Machine name.
 *
 * with reliable connection sending single packet would be enough.
 *
 * idea was found in cifs.txt Hobbit's paper. (http://www.avian.org)
 * slightly coded by CyberPsychotic (fygrave@blackstar.krsu.edu.kg)
 */

#include "config.h"
#include "tellme.h"

/*             1   2   3   4   5   6   7   8   9   10 */
unsigned char rpack[]="\x00\x03\x00\x00\x00\x01\x00\x00\x00\x00"
             "\x00\x00\x20\x43\x4b\x41\x41\x41\x41\x41"
             "\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
             "\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
             "\x41\x41\x41\x41\x41\x00\x00\x21\x00\x01"
	     ;

unsigned char buf[1024];
int ssock;

int usage(char *myname)
{
	printf("Usage: %s remote_winmachine [number_of_packets] [seconds to wait for responce]\n",myname);
	exit(1);
}

void sig_alarm(int sig) {
	close(ssock);
	printf("\ntimeout expired. No responce received.\n");
	exit(1);
}

int main(int argc,char **argv)
{
int    npack;
int   pcount;
struct servent *sp;
struct sockaddr_in host;
struct hostent *hostaddr;
struct linger ling;
int rsize,hsize,i,timeout;
fd_set rfd,wfd;
struct timeval  waitsock; 
unsigned char received=0;

/* we need hostname. at least.. */
if (argc<2)
{ usage(argv[0]);
  exit(1);
}

/* or number of packets to send */

timeout=DEFTIMEOUT;
npack=DEFNPACK;

switch (argc) {
	case 4: timeout=atoi(argv[3]);
	case 3: npack=atoi(argv[2]);
		break;
	case 2: printf("No arguments were given. Defaults applied\n");
		break;
	default: printf("too much garbage\n");
		 usage(argv[0]);
}
	if (npack<=0) 
	   { usage(argv[0]);
 	      exit(1);
	   }

if (signal(SIGALRM,sig_alarm)==SIG_ERR) { fprintf(stderr,"signal errie");
					exit(1);
}
alarm(timeout);
	   
sp=getservbyname("netbios-ns","udp");


  memset(&host, 0, sizeof(host));
  host.sin_family = AF_INET;
  host.sin_port = sp->s_port;
 if (( hostaddr = gethostbyname(argv[1])) == NULL)
{	 herror("can't resolve remote hostname");
	exit(1);
}

/* here we open socket, which we will use to send packets */
if ( (ssock=socket(AF_INET,SOCK_DGRAM, 0)) < 0)
{
	perror("err-socket: ");
	exit(1);
}

if ( (bind(ssock,(struct sockaddr *)&host,sizeof(host))) < 0 )
{ 
	perror("cant bind UDP netbios-ns port:");
	close(ssock);
	exit(1);
}
  ling.l_onoff = 0;          /* dont linger */
if( setsockopt(ssock, SOL_SOCKET, SO_LINGER, (void *)&ling, sizeof(ling))==-1)
{ 	perror("setsockopt error:");
	close(ssock);
	exit(1);
}
 
bcopy(hostaddr->h_addr,&host.sin_addr,hostaddr->h_length);

printf("Sending %i packets to %s [%s]\n(timeout's set to %i).",npack,argv[1],
		inet_ntoa(host.sin_addr),timeout);
/* we don't want to send trailing 0 byte */

/* pre-initialisation for select */

waitsock.tv_sec=0;
waitsock.tv_usec=0;


/* send packets while not receive any or interrupted */
for(;;)
{

	FD_ZERO(&rfd);
	FD_ZERO(&wfd);
	FD_SET(ssock,&rfd);
	FD_SET(ssock,&wfd);
	

	if (select(ssock+1,&rfd,&wfd,(fd_set *)0,&waitsock) == -1)
	{ if (errno==EINTR) continue;
		else { perror("select:");
		       close(ssock);
		       exit(1);
		}
	}	
	
/* if we can write */
 if (FD_ISSET(ssock,&wfd) && npack)
 {
	if ( (sendto(ssock,rpack,sizeof(rpack)-1,0,(struct sockaddr *)&host,
	sizeof(host))) != sizeof(rpack)-1)
	{
		perror("sendto:");
		if (errno == ENOBUFS ) {
					sleep(1);
		  			continue;
		  } else
		       exit(1);
	  }
	printf(".");
	npack--;
	fflush(stdout);
  }
/* if something to read ... */
 if (FD_ISSET(ssock,&rfd))
 {
	 if( ( rsize = recvfrom(ssock,buf,sizeof(buf),0,
			 (struct sockaddr *)&host,&hsize)) <=0) continue;
	printf("\nreceived packet:\n--\n");
	 for(i=0;i<rsize;i++) printf("%c",buf[i]);
	 printf("\n--\n");
 	 received++;/* ok.. we got at least single packet */			 
	
 }
 if (received) break;
}
close(ssock);
printf("\n");
return 0;
}
