;*********************************************************
;	PIC PAGER SCAN v1.01 (jul 26 1997)
;	Copyright (c)1996-1997 Dejan Kaljevic
;	All Rights Reserved
;	(eMail: dejan@net.yu)
;*********************************************************
list p=16c84,f=inhx8m,r=dec
__fuses H'1'
include dex.mac
;*********************************************************
r0	equ 0ch
r1	equ 0dh
r2	equ 0eh
r3	equ 0fh
r4	equ 10h
r5	equ 11h
r6	equ 12h
r7	equ 13h

txreg 		equ 1ch 
crc_temp 	equ 1dh
temp_count	equ 1eh
temp_data	equ 1fh
_data		equ 20h ;20h,21h,22h,23h
status_s	equ 24h
pozic_adr	equ 25h
count_in	equ 26h
timer_9600	equ 27h
status_sync	equ 28h

;	76543210	
;	||  || |
;	||  || *- 0=1200 bps 1=512 bps	
;	||  |*--- 0=noinvert 1=invert
;	||  *---- 1=new bit 
;	**------- 2 bit counter for 512 bps

counter		equ 29h
data_in_temp	equ 2ah
data_in		equ 2bh
sinhro		equ 2ch
status_tx 	equ 2dh
temp_w		equ 2eh
temp_status 	equ 2fh

	include "picreg.h"


;**********************************************
		org 0
		jmp start



		org 4

;************   timer interrupt  **************
; 
		movwf temp_w		;save w & status
		swapf status,w 	
		bcf status,rp0
		movwf temp_status
;---------------------------------------
;-10 for rtcc		
		
		movlw 256 -104 + 10
		movwf rtcc
		bcf intcon,rtif

		jmp int_timer







;---------------------------------------
get_data	clr pclath
		movwf pc

copy_r		db 13
		db 10
		db 13
		db 10

		db 1
		db 80
		retlw '*'

		db 13
		db 10

	data ' PIC PAGER SCAN v1.01 by Kaljevic Dejan 97  All Rights Reserved'

		db 13
		db 10

	data ' TEL.381-11-596-075 Belgrade,YU   eMail: dejan@net.yu'

		db 13
		db 10

		db 1
		db 80
		retlw '*'

		db 13
		db 10
		db 0








;******************************************************
;------------------------------------------------------
int_timer	incf count_in
		incf timer_9600



;======================================================
;	Tx bajt
;	txreg <- bajt	
;	status_tx <- ffh 	start 
;
;	read	status_tx=0	ready for transmit
;------------------------------------------------------

		movf status_tx,w
		jz end_tx		;nothing to send

		incf status_tx,w
		jne tx_1		;not start impuls

		bcf port_a,3		;start 
		movlf status_tx,10
		jmp end_tx

tx_1		djnz status_tx,tx_2
		jmp end_tx		;end of stop impuls

tx_2		decf status_tx,w
		jne tx_3

		bsf port_a,3		;stop
		jmp end_tx

tx_3		rrf txreg
		jc txx
		bcf port_a,3
		jmp end_tx
txx		bsf port_a,3
end_tx
;------------------------------------------------------



;======================================================
; Set frequency from 9600 Hz to 1200 Hz or 512 Hz
;======================================================

set_freq	jb status_sync,0,s_512

		movf count_in,w
		xorlw 8  		;1200 = 9600/8
		je t512c		;end of 1200
		jmp t512		
		
s_512		movlw 0c0h		;512 = 9600*4/(3*19+18)
		andwf status_sync,w
		movlw 18		
		jz bb512
		movlw 19
bb512		xorwf count_in,w
		jne t512
		movlw 40h		;end of 512
		addwf status_sync
t512c		clr count_in
t512		
;-----------------------------------------------------



;=====================================================
; Set phase for 1200 Hz or 512 Hz  (PLL)
;=====================================================
set_phase	clc
		jnb port_a,4,m1
		stc
m1		rlf status_s		;last 8 bits

		movf status_s,w
		andlw 3 
		xorlw 1 
		;je promena		;01
		;xorlw 3 
		jne bez_promene		;00 or 11
		
;---------------------------------------
;	01 ;or 10
;---------------
promena		jb status_sync,0,b_512

		movlw 6			;1200
		subwf count_in,w
		jc pro			;6,7 		(+25%)
		movlw 3
		subwf count_in,w
		jnc pro			;0 & 1,2 	(-25%)	
bez_prom	incf count_in
		jmp bez_promene

;---------------
b_512		movlw 15		;512
		subwf count_in,w
		jc pro			;15,16,17,18,19 (+25%)
		movlw 4
		subwf count_in,w
		jc bez_prom		;0 & 1,2,3	(-15%)
		
pro		clr count_in
bez_promene
;---------------------------------------




;=======================================
; get bit
;---------------------------------------

		jb status_sync,0,d_512
		movlw 4 		;1200	bps
		jmp get_bit
d_512		movlw 8			;512	bps
get_bit		xorwf count_in,w
		jne end_bit

;---------------
		incf counter
		bsf status_sync,3

;---------------------------------------
;  bit filter
;---------------------------------------
		movf status_s,w
		andlw 7
		xorlw 3			
		je bit_1		;011
		xorlw 7			
		je bit_0		;100
		jnb status_s,2,bit_0
bit_1		stc
		jmp bit_e
bit_0		clc
bit_e
;---------------------------------------

		rlf data_in_temp
		movf counter,w
		andlw 7
		jne end_bit
		movlf counter,80h
		movff data_in,data_in_temp
end_bit
;---------------------------------------

;---------------------------------------
; end of interrupt
;---------------------------------------
		swapf temp_status,w
		movwf status
		swapf temp_w
		swapf temp_w,w
		retfie
;---------------------------------------





;***************************************

start		clr r0			;pause 65536 uS
s1		clr r1
s2		djnz r1,s2
		djnz r0,s1



		clr status_tx
		clr txreg
		clr status_sync


		movlf port_a,8
		movlf port_b,0
		movlw 0		
		tris port_b
		movlw 0f0h
		tris port_a

		movlw 256-96 		;tmr0
		movwf rtcc
		movlf intcon,10100000b
		movlw 10001000b
		option
;---------------------------------------

		clr r0			;pause 65536 uS
ps1		clr r1
ps2		djnz r1,ps2
		djnz r0,ps1



;=======================================
; Print Info
;---------------------------------------
		movlw copy_r
		movwf r7

nex_data	movf r7,w
		call get_data
		incf r7

		movwf r1
		iorlw 0
		jz end_of_data
		decf r1
		jz mul_pr

		call send_byte		;char
		jmp nex_data
		
;---------------------------------------
mul_pr		movf r7,w
		call get_data
		movwf r1		;mult.
		incf r7
		movf r7,w
		call get_data
		movwf r2		;char.
		incf r7			

nn_r		movf r2,w
		call send_byte		;char * mult
		djnz r1,nn_r
		jmp nex_data

;---------------
end_of_data

;---------------------------------------


		clr counter



;***************************************
next_scan_reset	
		clr r1
	
;---------------------------------------
; Reset 10 ms
;---------------
		movf timer_9600,w
		addlw 96
		movwf r0

		bsf port_a,2		;reset 10 ms
ne_res		movf timer_9600,w
		xorwf r0,w
		jne ne_res		

		bcf port_a,2
;---------------------------------------



;---------------------------------------
; Wait 	8,3 ms
;---------------	
		movf timer_9600,w
		addlw 80
		movwf r0

nne_res		movf timer_9600,w	;wait 8,3 ms
		xorwf r0,w
		jne nne_res		
;---------------------------------------



;=======================================
next_scan	clr count_in

		clr port_b		;LEDs off

		movf r1,w
		andlw 1
		movwf status_sync	;set freq
		movwf status_sync	;!


;---------------------------------------
; Search for header
;---------------------------------------
		call get_bajt
		jc end_scan		;time out

		movwf r0
		xorlw 55h
		je prr_o
		addlw 1
		jne end_scan		;not found 55h or 0aah

prr_o		movlf r2,8

prr_		call get_bajt
		jc end_scan		;time out
		movf r0,w
		xorwf data_in,w
		jne end_scan		;not found header
		
		djnz r2,prr_
;---------------------------------------



;---------------------------------------
		bsf port_b,0		;on LED header 
		jb status_sync,0,led_512
		bsf port_b,2		;on LED 1200 bps
		jmp led_end
led_512		bsf port_b,3		;on LED 512 bps
led_end
;---------------------------------------





;---------------------------------------
; Search for end of header to get synchro & polarity
;---------------------------------------
		bcf status_sync,3

		call get__bit
		jc end_scan		;time out

nex_bb		movwf r0
		call get__bit
		jc end_scan		;time out
		xorwf r0
		jb r0,0,nex_bb
		
;--------------- end of header ---------

		movwf r0
		movlf counter,1		;set sync (number of rx bits)

		bcf status_sync,2	;set polarity
		jnb r0,0,no_inv
		bsf status_sync,2
no_inv

;---------------------------------------




;=======================================
; decode block
;---------------------------------------
get_next_block	call get_dword		;get data
		jc end_scan
		call crc		;test CRC & correct

g_next_block	call test_frame_sync
		jne next_scan_reset
;---------------------------------------

		clr pozic_adr

		bcf port_b,0		;off LED header
		bsf port_b,1		;on LED data

;---------------------------------------
get_next_dword	call get_dword
		jc end_scan
		call crc

g_next_dword	call test_idle
		je end_dd



;=======================================
; decode data
;---------------------------------------

		rlf _data+2
		rlf _data+1
		rlf _data
		jc data_dd		;data chunk

;=======================================
; decode addr
;---------------------------------------

		clr temp_data
		movlf temp_count,7

;---------------	
		movlw 0c0h		;calculate addr
		andwf _data+2
		movff r0,pozic_adr	;3 LSB bits from pozic_addr
		rlf r0
		rlf r0,w
		iorwf _data+2
		call bin_bcd		;bin 21 bit _data --> bcd r6,r5,r4,r3
;---------------


;---------------------------------------
; send (print) Addr & get next dword
;---------------------------------------
		call get_bajt
		jc end_scan
		movwf _data

;---------------
		movlw 13		;new line
		call send_byte
		movlw 10
		call send_byte

		movf r3,w
		call send_lnibl

;---------------	
		call get_bajt
		jc end_scan
		movwf _data+1

;---------------
		swapf r4,w
		call send_lnibl
		movf r4,w
		call send_lnibl
		swapf r5,w
		call send_lnibl
	
;---------------
		call get_bajt
		jc end_scan
		movwf _data+2
;---------------
		movf r5,w
		call send_lnibl
		swapf r6,w
		call send_lnibl
		movf r6,w
		call send_lnibl

;---------------
		call get_bajt
		jc end_scan
		movwf _data+3

;---------------
		movlw ' '
		call send_byte
		movlw ' '
		call send_byte
;---------------------------------------
		call crc


		incf pozic_adr
		movlw 16
		xorwf pozic_adr,w
		jne g_next_dword
		jmp g_next_block	;end of block



;=======================================
; decode text
;---------------------------------------
data_dd		movlf r2,20
		movff r0,temp_data
		movff r1,temp_count
		subwf r2

send_nex_ch	call send_char		;send (print) text

		movlf r1,7
		subwf r2
		jc send_nex_ch

;---------------
		movf r2,w
		clr temp_count
		subwf temp_count	;new temp_count
		
		movf temp_count,w
		subwf r1
;---------------		
nex_td		rlf _data+2
		rlf _data+1
		rlf _data		

		rrf r0
		djnz r1,nex_td

		movff temp_data,r0	;new temp_data

;---------------------------------------
end_dd		incf pozic_adr
		movlw 16
		xorwf pozic_adr,w
		jne get_next_dword
		jmp get_next_block	;end of block
;---------------------------------------



end_scan	incf r1
		movlw 16
		xorwf r1,w
		je next_scan_reset
		jmp next_scan
;--------------------------------





;***************************************
send_char	rlf _data+2
		rlf _data+1
		rlf _data		

		rrf r0
		djnz r1,send_char

		clc		
		rrf r0,w
		jmp send_byte
;---------------------------------------

;***************************************
; bin 21 bit _data --> bcd r6,r5,r4,r3
;---------------------------------------

bin_bcd		movlf r1,21
		clr r3
		clr r4
		clr r5
		clr r6
next_lld	rlf _data+2
		rlf _data+1
		rlf _data

		rlf r6
		rlf r5
		rlf r4
		rlf r3

		djnz r1,adj_bcd
		ret
;---------------
adj_bcd		movlw 3		;adj r6
		addwf r6,w
		movwf r0
		btfsc r0,3
		movwf r6
		movlw 30h
		addwf r6,w
		movwf r0
		btfsc r0,7
		movwf r6

		movlw 3		;adj r5
		addwf r5,w
		movwf r0
		btfsc r0,3
		movwf r5
		movlw 30h
		addwf r5,w
		movwf r0
		btfsc r0,7
		movwf r5

		movlw 3		;adj r4
		addwf r4,w
		movwf r0
		btfsc r0,3
		movwf r4
		movlw 30h
		addwf r4,w
		movwf r0
		btfsc r0,7
		movwf r4

		movlw 3		;adj r3
		addwf r3,w
		movwf r0
		btfsc r0,3
		movwf r3
		movlw 30h
		addwf r3,w
		movwf r0
		btfsc r0,7
		movwf r3

		jmp next_lld
;---------------------------------------

;***************************************
test_frame_sync	movlw 7ch
		xorwf _data,w
		jne er_t
		movlw 0d2h
		xorwf _data+1,w
		jne er_t
		movlw 15h
		xorwf _data+2,w
		;jne er_t
		;movlw 0d8h
		;xorwf _data+3,w
er_t		ret

;***************************************
test_idle	movlw 7ah
		xorwf _data,w
		jne er_t
		movlw 89h
		xorwf _data+1,w
		jne er_t
		movlw 0c1h
		xorwf _data+2,w
		;jne er_t
		;movlw 97h
		;xorwf _data+3,w
		ret


;***************************************
; 32-bit in --> data (0-3)
;---------------------------------------
get_dword	call get_bajt
		jc er_dd
		movwf _data
		call get_bajt
		jc er_dd
		movwf _data+1
		call get_bajt
		jc er_dd
		movwf _data+2
		call get_bajt
		jc er_dd
		movwf _data+3
er_dd		ret

;---------------------------------------

;**************************************
; ret: 	c=0 w=bit (byte)
;	c=1 time over error
;--------------------------------------
get__bit	movf timer_9600,w
		addlw 256-2
		movwf r7
		
nex_b		movf r7,w
		xorwf timer_9600,w
		je time_ee

		jnb status_sync,3,nex_b
;---------------
		clc
		bcf status_sync,3
		movf data_in_temp,w
		ret
;---------------------------------------


;***************************************
; ret: 	c=0 w=byte
;	c=1 time over error
;---------------------------------------
get_bajt	movf timer_9600,w
		addlw 256-2		;time max
		movwf r7
		
nex_gb		movf r7,w
		xorwf timer_9600,w
		je time_ee		;time over error

		jnb counter,7,nex_gb	;wait for byte

;---------------
		bcf counter,7

		jnb status_sync,2,normal
		comf data_in		;data invert
normal		movf data_in,w
		clc
		ret

time_ee		stc
		ret

;---------------------------------------


;***************************************
send_lnibl	andlw 0fh
		addlw '0'
;***************************************
send_byte	movf status_tx
		jnz send_byte
		movwf txreg
		movlf status_tx,0ffh
		ret
;---------------------------------------








;***************************************
crc		call test_crc
		movf r2,w
		jz end_cr		;crc=ok

		call crc_poz		;get pozition
		addlw 1
		movwf crc_temp
		
		call test_crc1

		movf crc_temp,w
		call crc_data3
		xorwf r2,w
	
		jz crc_cor		;crc 1-bit error ok

		ret			;>1 bit error (bad data)

crc_cor		movf crc_temp,w
		call xor_bit		;correct error
		
		andlw 0			;z=1
end_cr		ret


_data1 equ _data+1
_data2 equ _data+2
_data3 equ _data+3
;---------------------------------------
_get_data	movff r3,_data
		movff r4,_data1
		movff r5,_data2
		movff r6,_data3
		ret
;---------------------------------------
shl_data	;clc
		rlf r6
		rlf r5
		rlf r4
		rlf r3
		ret


;---------------------------------------
;	ret: r2 = crc_modul
;---------------------------------------
test_crc	call _get_data	
		clr r1
		clr r2
		movlf r7,31
		
t_cr0		call shl_data
		jnc t_cr1
		movf r1,w
		call crc_data
		xorwf r2
t_cr1		incf r1
		djnz r7,t_cr0
		ret

;---------------------------------------
;	ret: r2 = crc_modul1
;---------------------------------------
test_crc1	call _get_data	
		clr r1
		clr r2
		movlf r7,31
		
t_cr01		call shl_data
		jnc t_cr11
		movf r1,w
		call crc_data2
		xorwf r2
t_cr11		incf r1
		djnz r7,t_cr01
		ret

;---------------------------------------
xor_bit		movwf r2
		andlw 7
		movwf r7
		rrf r2
		rrf r2
		rrf r2,w
		andlw 3
		sublw _data+3
		movwf fsr

		incf r7
		clr r2
		stc
n_xo		rlf r2 
		djnz r7,n_xo
		movf r2,w
		xorwf 0
		ret



;---------------------------------------
crc_data3	sublw 31
;---------------------------------------
crc_data2	movwf r0
		addwf r0
		addwf r0	;r0=w*3+2
		movlw 2

c_dats		addwf r0
		movlw 31
n_datc		subwf r0
		jc n_datc
		addwf r0,w
		jmp crc_data
		









;---------------------------------------
		org 300h

crc_poz		addlw 30
crc_data	addlw data_c-300h
		bsf pclath,0
		bsf pclath,1
		movwf pc

data_c		db 12h
		db 9
		db 16h
		db 0bh
		db 17h
		db 19h
		db 1eh
		db 0fh

		db 15h
		db 18h
		db 0ch
		db 6
		db 3
		db 13h
		db 1bh
		db 1fh

		db 1dh
		db 1ch
		db 0eh
		db 7
		db 11h
		db 1ah
		db 0dh
		db 14h
	
		db 0ah
		db 5
		db 10h
		db 8
		db 4
		db 2
		db 1

;---------------------------------------
		db 0
		db 1
		db 12h
		db 2
		db 5
		db 13h
		db 0bh
		db 3

		db 1dh
		db 6
		db 1bh
		db 14h
		db 8
		db 0ch
		db 17h
		db 4

		db 0ah
		db 1eh
		db 11h
		db 7
		db 16h
		db 1ch
		db 1ah
		db 15h
	
		db 19h
		db 9
		db 10h
		db 0dh
		db 0eh
		db 18h
		db 0fh

;---------------------------------------




end