;******************* PIC16c5X/16cXX Registers *******************
;
; Define Reset Vectors
PIC54   equ     1FFh
PIC55   equ     1FFh
PIC56   equ     3FFh
PIC57   equ     7FFh
PIC71   equ     0
PIC84	equ     0
;
; Data Registers
RTCC    equ     1
tmr0	equ 	1
PC      equ     2
STATUS  equ     3
FSR     equ     4
PORTA	equ     5
PORTB	equ     6
PORTC	equ     7
;
Port_A  equ     5
Port_B  equ     6
Port_C  equ     7
;
; 16c71 Special-purpose registers
ADRES   equ     9
ADCON0  equ     8
ADCON1  equ     88h
PCLATH  equ     0Ah
INTCON  equ     0Bh
TRISA   equ     85h 
TRISB   equ     86h 
tris_a	equ 	85h
tris_b	equ	86h
;
; 16c84 Special-purpose registers
EEDATA  equ     8
EEADR   equ     9
EECON1  equ     88h
EECON2  equ     89h


rd 	equ 0
wr 	equ 1
wren 	equ 2
wrerr	equ 3
eeif	equ 4

; Status File Register Bits
CARRY   equ     0
C       equ     0
DCARRY  equ     1
DC      equ     1
Z_bit   equ     2
Z       equ     2
P_DOWN  equ     3
PD      equ     3
T_OUT   equ     4
TO      equ     4

; 16c5x status bits
PA0     equ     5
PA1     equ     6   
PA2     equ     7 
;
; 16c71 status bits
RP0     equ     5
RP1     equ     6   
IRP     equ     7

; 16c71 INTCON register bits
GIE     equ     7
ADIE    equ     6
RTIE    equ     5
INTE    equ     4
RBIE    equ     3
RTIF    equ     2
INTF    equ     1
RBIF    equ     0

; 16c71 ADCON0 register bits
ADCS1   equ     7
ADCS0   equ     6
CHS1    equ     4
CHS0    equ     3
GO      equ     2
ADIF    equ     1
ADON    equ     0

; 16c71 ADCON1 register bits
PCFG1   equ     1
PCFG0   equ     0
;
; Misc. variables
Same    equ     1
LSB     equ     0
MSB     equ     7
TRUE    equ     1
YES     equ     1
FALSE   equ     0
NO      equ     0
;
;*************************************************************************


