;*********************************************************
;	Test & SP unlock card v1.02
;	Copyright (c)1996-1998 Dejan Kaljevic
;	All Rights Reserved
;	(eMail: dejan@net.yu)
;*********************************************************
 list p=16c84,f=inhx8m,r=dec
 __fuses H'1'
 include dex1.mac
;*********************************************************
r0	equ 0ch
r1	equ 0dh
r2	equ 0eh
r3	equ 0fh
r4	equ 10h
r5	equ 11h
r6	equ 12h
r7	equ 13h

iso_fleg 	equ 1ah
rxtx_count	equ 1bh

tx_reg 		equ 1ch
rx_reg 		equ 1ch

temp_tx 	equ 1dh
wait_reg	equ 1eh



d1	equ 30h
d2 	equ 31h
d3	equ 32h
d4 	equ 33h

sel_f1		equ 1fh
sel_f2		equ 20h 

card_flag	equ 21h



	include "picreg.h"


cla equ r0
ins equ r1
p1  equ r2
p2  equ r3
p3  equ r4



;**********************************************
		org 0
		jmp start



;---------------------------------------
get_data	clr pclath
		movwf pc


atr_baf		dt 12h,3fh,2fh,0,80h,69h,0afh,2,4,1,31h,0,0,0,0eh,83h,3eh,9fh,16h

atr_cl		dt 10h,3Fh,6Ch,0,0,25h,0A0h,31h,0,0FFh,0,0,1,80h,4,90h,0



pin_data	dt 11h,1fh,23h,45h,12h,34h,0



include eeprom.as



;***************************************
start		call wait2


		clr iso_fleg
		movlw 0ffh
		tris port_b
		movlw 0ffh
		tris port_a

		movlw 8 ;10001000b
		option
;---------------------------------------


		call wait1
;--------------------------------------	Send ATR

		movlf eeadr,3fh
		call ee_rd		;get flag
		movwf card_flag

		movlw atr_baf
		movf card_flag
		btfss status,z	
		movlw atr_cl
;-------------------------------------

		movwf r6
		call get_data
		movwf r7		;size of ATR

		incf r6
		movf r6,w
		call get_data		;first ATR byte

		xorlw 3fh
		jnz no_inv
		bsf iso_fleg,0
no_inv		
		movf r6,w
		incf r6
		call get_data
		call send_byte
		djnz r7,no_inv

;================================================

main		call wait

		movlf r7,5
		movlf fsr,cla
		call read__data		;get cla,ins,p1,p2,p3

		call wait

;------------------------------------------------
		movf card_flag
		jnz cl_ins

		cmp cla,0a0h
		jnz bad_cla
		
;================================= CLA A0
		cmp ins,0a4h
		je select_file 

		cmp ins,20h
		je verify_pin

		cmp ins,0b0h
		je read_bin

		cmp ins,0c0h
		je send_response

		cmp ins,0d6h
		je dumb_read

		cmp ins,0dch
		je dumb_read

		cmp ins,0fah	;sleep
		je ok_end		

		jmp bad_ins

;======================================

cl_ins		cmp ins,20h
		je verify_pin

		cmp ins,0b0h
		je cl_read_bin
		
		cmp ins,0d0h
		jne bad_ins

;======================================
dumb_read	call send_ins

nex_clwr	call get_byte
		djnz p3,nex_clwr

		jmp ok_end 
;======================================

send_ins	call wait
		movf ins,w
		jmp send_byte
		
;======================================



;======================================
; d1=data bafer
; r7=count
;--------------------------------------
read_data	movlf fsr,d1
;--------------------------------------
; fsr=addr
; r7=count
;--------------------------------------
read__data	call get_byte
		movwf 0
		incf fsr
		djnz r7,read__data
		ret
;--------------------------------------


bad_p1p2	movlw 6bh		;6b00h
		jmp send_ans0

bad_p3		movlw 67h		;6700h
		jmp send_ans0		

err_9408	movlf r0,8
		jmp send_94
	
bad_cla		movlw 6eh
		jmp send_ans0

bad_ins		movlw 6dh
		jmp send_ans0

ok_end
send_ok		movlw 90h
send_ans0	clr r0

send_answer	movwf temp_tx
		call wait
		movf temp_tx,w
		call send_byte
		movf r0,w
		call send_byte
		jmp main









;***************************************	
; RET w=char
;---------------------------------------
get_byte	bank1
		bsf tris_b,7		;in
		bank0 


l_lev		jnb port_b,7,l_lev	;wait for H
h_lev		jb port_b,7,h_lev	;wait for L (start impuls)

		movlf rxtx_count,9
		bcf iso_fleg,1		;reset parity fleg
		jb port_b,7,h_lev	;wait for L 

		call wait05		;[372/4/2-9] wait to midle of start impuls

nex_rx_bit	btfsc iso_fleg,0	;1(2)
		rlf rx_reg		;1(0)
		btfss iso_fleg,0	;2(1)
		rrf rx_reg		;0(1)
	
		call wait1		;2 [372/4-15]

		jnb port_b,7,low_l	;2(3)
;--------------------------
		movlw 2			;1
		xorwf iso_fleg		;1 ;parity
		
		nop			;1
		stc			;1
low_e		djnz rxtx_count,nex_rx_bit	;3

		rrf iso_fleg,w
		xorwf iso_fleg,w
		andlw 1
		jnz bad_parity

		btfsc iso_fleg,0
		comf rx_reg
		movf rx_reg,w
		ret

low_l		clc			;1
		jmp low_e		;2


bad_parity	call wait1

		bank1
		bcf tris_b,7		;out
		bank0
		bcf port_b,7		;i/o=0
	
		call wait1

		bsf port_b,7		;i/o=1

		bank1
		bsf tris_b,7		;in

		call wait05
		jmp get_byte



;**************************************
; W = char

send_byte	movwf temp_tx		
		
		movwf tx_reg
		btfsc iso_fleg,0
		comf tx_reg

		movlf rxtx_count,9
		bcf iso_fleg,1		;reset parity fleg

		call wait05
		
		bank1
		bsf tris_b,7		;in
		bank0 
tx_l		jnb port_b,7,tx_l
		
		clc

;---------------
nex_tx_bit	jc tx_high		;2(3)
		call tx_lo		;2+7
		jmp tx_e		;2

tx_high		call tx_hi		;2+5
		movlw 2			;1
		xorwf iso_fleg		;1 ;parity
		nop			;1

tx_e		call wait11		;2 + (372/4-22)

		btfsc iso_fleg,0	;1(2)
		rlf tx_reg		;1(0)
		btfss iso_fleg,0	;2(1)
		rrf tx_reg		;0(1)

		djnz rxtx_count,nex_tx_bit	;3


;---------------
		rrf iso_fleg,w		;send parity
		xorwf iso_fleg,w
		andlw 1		
		jnz par_s

		call tx_lo
		jmp end_par
	
par_s		call tx_hi
end_par		call wait1

;---------------
		call tx_hi		;stop impuls
		call wait1

		jnb port_b,7,error_tx
		call wait2
		ret

error_tx	call wait2
		movf temp_tx,w
		jmp send_byte		;try again


;---------------------------------------	out = L
tx_lo		bcf port_b,7		;1	out=0
		bank1			;1
		bcf tris_b,7		;1	;out
		bank0			;1
		bcf port_b,7		;1	;out=0
		ret			;2
;---------------------------------------
tx_hi		bank1			;1
		bsf tris_b,7		;1 ;in (i/o=1)
		bank0			;1
		ret			;2

;---------------------------------------

wait05		;37 ins
		movlf wait_reg,10
		jmp _wait3

wait11		;71 ins
		movlf wait_reg,22
		jmp _wait1

wait1		;78 ins
		movlf wait_reg,24	
		nop
_wait3		nop
_wait2		nop
_wait1		djnz wait_reg,_wait1	;3*wait_reg+1 
		ret

wait
wait2		;182 ins
		movlf wait_reg,59
		jmp _wait1


















;************************************************
select_file	movf p1,w
		iorwf p2,w
		jnz bad_p1p2	 
		cmp p3,2
		jnz bad_p3

		call send_ins		;OK p1=0,p2=0,p3=2

		movlf r7,2
		call read_data		;get File ID

;---------------------------------------
		cmp d1,3fh
		jnz no_mf
		movf d2
		jnz no_mf		;selected MF
ok_df		movlf r0,16h

;======================================
send_9fa	movff sel_f1,d1
		movff sel_f2,d2
;===============
send_9f		movlw 9fh
		jmp send_answer

;--------------------------------------		
no_mf		cmp d1,7fh
		jnz no_df
		movlf r0,df_info
		call test_file
		jnz ok_df		;select DF

;--------------------------------------		
no_df		cmp d1,6fh
		jnz no_ef
		movlf r0,ef_info
		call test_file
		jz no_ef
ok_eef		movlf r0,0fh
		jmp send_9fa		;select EF (6fxx)

no_ef		cmp d1,2fh
		jnz err_9404 ;no_eef
		movlf r0,eef_info
		call test_file
		jnz ok_eef		;select EEF (2fxx)

;=======================================
err_9404	movlf r0,4
send_94		movlw 94h
		jmp send_answer






;**************************************
;r0=index in table3 of valid files
;d2=file to test (low byte)
;
;RET z=1 file not found
;    z=0 OK r0=index to selected file data
;--------------------------------------
test_file	movf r0,w
		call get_data3
		andlw 0ffh
		jz end_tf
		xorwf d2,w
		jz end_oktf
		incf r0
		incf r0
		jmp test_file

end_oktf	iorlw 1	
end_tf		ret
;--------------------------------------




;************************************************
send_response	call send_ins		;always OK

		cmp sel_f1,3fh
		jne no__mf

		movlf r0,mf_d
		jmp send_resp		;MF

no__mf		cmp sel_f1,7fh
		jne no__df

		movlf r0,df_d
		jmp send_resp		;DF

no__df		cmp sel_f1,6fh
		je resp_ef		;EF (6fxx)
		
		cmp sel_f1,2fh
		je resp_eef		;EEF (2fxx)

send_zeros	clrw
		call send_byte
		djnz p3,send_zeros
		jmp ok_end


;***************************************
send_resp	clr r7

nex_srr		cmp r7,5
		jnz no_inf
		movf sel_f2,w
		jmp noo_inf

no_inf		movf r0,w
		call get_data3
noo_inf		call send_byte
		incf r7
		incf r0
		djnz p3,nex_srr
		jmp ok_end
;---------------------------------------

;************************************************
resp_eef	movlw eef_info
		jmp sp_ef
;************************************************
resp_ef		movlw ef_info
sp_ef		movwf r0
		movff d2,sel_f2
		call test_file		;always OK
		incf r0,w		
		call get_data3		;addr of selected file info
		movwf r0
;----------------------------
		movlw 85h
		call send_byte
		movlw 0dh
		call send_byte		;send 85 0d
		
		movlf r7,2
		call send_r0		;send file size
		
		movf sel_f1,w
		call send_byte
		movf sel_f2,w
		call send_byte		;send file ID

		movlf r7,3
		call send_r0		

		movlf r7,6
		movlf r0,ef_d
		call send_r0
		jmp ok_end

;--------------------------------------

;**************************************
; r0=index in table3
; r7=count
;--------------------------------------
send_r0		movf r0,w
		call get_data3
		call send_byte
		incf r0
		djnz r7,send_r0
		ret
;--------------------------------------




;************************************************
read_bin	cmp sel_f1,6fh
		movlw ef_info
		btfss status,z
		movlw eef_info
		movwf r0
		movff d2,sel_f2
		call test_file
		jz err_9408

		call send_ins
	
		incf r0,w
		call get_data3
		movwf r0
		addlw 1
		call get_data3
		movwf r7
				
		movlw 5
		addwf r0,w
		call get_data3
		
		andlw 0ffh
		jnz no_eep


		movlw 6
		addwf r0
		call send_r0
		jmp ok_end


no_eep		

nex_ff		movlw 0ffh
		call send_byte
		djnz r7,nex_ff
		jmp ok_end



;**************************************
verify_pin	cmp p3,8
		jne bad_p3

		call send_ins

		movlf r7,8
	 	call read_data

;-------------------------------------
		movlw 0fh
		andwf d1
		andwf d2
		andwf d3
		andwf d4

		swapf d1,w
		iorwf d2
		swapf d3,w
		iorwf d4		;d2:d4=PIN

		clrf r7
		movlf r0,pin_data
		
nex_tp		incf r7
		movf r0,w
		incf r0
		incf r0
		call get_data
		andlw 0ffh
		jz ok_end		;PIN is not defined, send OK
		xorwf d2,w
		jne nex_tp

		decf r0,w
		call get_data
		xorwf d4,w
		je end_tp
		andlw 0f0h
		jne nex_tp
		decf r7,w
		jne nex_tp

end_tp		
;--------------------------------------
		movlf eeadr,3fh
		decf r7
		jnz no_1
		movf d4,w
		andlw 0fh
end_pin		call ee_wr
		jmp ok_end

no_1		decf r7
		movlw 0ffh
		btfss status,z
		addlw 1
		jmp end_pin


		






;======================================
cl_verify_pin	cmp p3,8
		jne bad_p3
		jmp dumb_read


;======================================
cl_read_bin	movf p1
		jne bad_p1p2
		movf p2,w
		addwf p3,w
		jc bad_p3
		movf p3
		je bad_p3
			
		call send_ins

		movff r7,p2

nex_clrd:	movf r7,w
		call get_clone_byte
		call send_byte
		incf r7
		djnz p3,nex_clrd

	movlf eeadr,3fh
	call ee_rd
	movwf p3
	incf p3,w
	jz ok_end
	movf p3
	jz ok_end
	decf p3,w
	andlw 0fh
	call ee_wr
	

		jmp ok_end

;--------------------------------------
get_clone_byte	cmp r7,40h
		jnc bac_0
		
		jz bac_ff
		addlw -2
		jz bac_ff
		
		cmp r7,60h
		jnc bac_0

		cmp r7,70h
		jc bac_0
;----------------

		addlw 10h
		movwf eeadr
		jmp ee_rd
		

bac_0		retlw 0
bac_ff		retlw 0ffh
;--------------------------------------		







;-------------------------------------------------------------
		org 300h



get_data3	bsf pclath,0
		bsf pclath,1
		movwf pc



df_info		dt 10h,0,20h,0,21h,0,0
eef_info 	dt 0e2h,_e2,0
ef_info 	dt 5,_5,7,_7,10h,_10,16h,_16,20h,_20,30h,_30,31h,_31
		dt 38h,_38,74h,_74,78h,_78,7bh,_7b,7eh,_7e,0adh,_ad,0aeh,_ae,0

mf_d	dt 85h,14h,1,0f0h,3fh,0,1,80h,0,0ffh,0ffh,43h,9,9,2,5
	dt 4,0,83h,8ah,83h,8ah


df_d	dt 85h,14h,0,30h,7fh,10h,2,80h,0,0fbh,0ffh,3,9,9,0,14
	dt 4,0,83h,8ah,83h,8ah

ef_d	dt 0ffh,0bbh,3,2,0,0

_5	dt 0,1		,4,0,1		,0	,1
_7	dt 0,9		,4,0,1bh	,0 	,8,9,10h,10h,1,0,0,0,0
_10	dt 0,9		,4,0,1bh	,0ffh
_16	dt 0,9		,4,0,1bh	,0ffh
_20	dt 0,9		,4,0,1bh	,0ffh
_30	dt 0,30h	,4,0,11h	,0ffh
_31	dt 0,1		,4,0,11h	,0ffh
_38	dt 0,4		,4,0,1bh 	,0 	,0,3ch,0,0
_74	dt 0,10h	,4,0,11h	,0	,0
_78	dt 0,2		,4,0,1bh	,0	,0,1
_7b	dt 0,0ch	,4,0,11h	,0ffh
_7e	dt 0,0bh	,4,0,11h	,0ffh
_ad	dt 0,3		,4,0,0bh	,0	,81h,0ffh,0ffh
_ae	dt 0,1		,4,0,0bh	,0	,2


_e2	dt 0,0ah	,4,0,0bh	,0	,98h,83h,11h,11h,11h,11h,11h,11h,11h,0f1h

	org 2100h


de 	1,61h,1,0,0,0,0,0,0,0,0,0,0,0,0,0

	org 213fh
de 	0

 end
;