// -*- c++ -*-
//
// $COPYRIGHT$
//
//


#ifndef ENTRY_H
#define ENTRY_H

#include <iostream.h>

#include "mtl/config.h"

namespace mtl {

  //:
  // Definintion for entries in sparse matrices
  //
  // There is one index stored with the element.
  //!category: utilities
  //!component: type

template <class T>
struct entry1 {
  /* This is kind of bad because it gets padded
     out to 16 bytes, which wastes space/bandwidth
     */

  typedef entry1<T> self;

  typedef T PR;

  int index;
  mutable PR value;

  inline entry1() : index(-1), value(0.0) { }

  inline entry1(int i, PR v = PR(0.0)) : index(i), value(v) { }

  inline entry1(const self& x) : index(x.index), value(x.value) { }

  inline self& operator=(const self& x) {
    index = x.index;
    value = x.value;
    return *this;
  }

  inline bool operator < (const entry1& e) const {
    return index < e.index; }

  inline bool operator == (const entry1& e) const {
    return index == e.index; }

  inline bool operator != (const entry1& e) const {
    return index != e.index; }
};

template <class T>
ostream& operator<<(ostream& os, const entry1<T>& e)
{
  os << "(" << e.index << "," << e.value << ") ";
  return os;
}

//: blah
//!noindex:
template <class OneD>
class elt_ref {
  typedef elt_ref<OneD> self;
public:
  typedef typename OneD::value_type PR;

  inline elt_ref() : vec(OneD()), i(-1) { }

  inline elt_ref(OneD& m, int i_) 
    : vec(m), i(i_) {
      iter = vec.find(i);
      if (iter != vec.end()) {
        if (iter.index() == i)
          val = *iter;
        else
          val = PR(0);
      } else
        val = PR(0);
  }

  inline operator PR() const {
    return val;
  }

  inline PR operator=(PR v) {
    if (iter != vec.end() && iter.index() == i) {
      *iter = val = v;
    } else {
      val = v;
      iter = vec.insert(iter, i, v);
    }
    return val;
  }

  inline PR operator+=(PR v) {
    if (iter != vec.end() && iter.index() == i) {
      *iter = val += v;
    } else {
      val = v;
      iter = vec.insert(iter, i, v);
    }
    return val;
  }

  inline PR operator*=(PR v) {
    if (iter != vec.end() && iter.index() == i)
      *iter = val *= v;
    return val;
  }

  template <class Ref>
  inline PR operator/=(const Ref& v) {
    if (iter != vec.end() && iter.index() == i)
      *iter = val /= v.val;
    return val;
  }

  inline PR operator/=(PR v) {
    if (iter != vec.end() && iter.index() == i)
      *iter = val /= val;
    return val;
  }

  inline PR operator-=(PR v) {
    if (iter != vec.end() && iter.index() == i)
      *iter = val -= v;
    else {
      val = -v;
      iter = vec.insert(iter, i, val);
    }
    return val;
  }

  inline PR operator=(const self& a) {
    if (iter != vec.end() && iter.index() == i)
       *iter = val = a.val;
    else
      iter = vec.insert(iter, i, a.val);
    return val;
  }

  /*protected: */
  OneD vec;
  /* JGS, probably performance issue here, want 
   OneD& vec;
   but vec may be temporary object in the 2D, like compressed2D
   */
  typename OneD::iterator iter;
  int i;
  PR val;
};



//: blah
//!noindex:
template <class OneD>
class const_elt_ref {
  typedef const_elt_ref<OneD> self;
public:
  typedef typename OneD::value_type PR;

  /*  inline const_elt_ref() : vec(0), i(0) { }*/
  template <class EltRef>
  inline const_elt_ref(const EltRef& elt) {
    typename OneD::const_iterator iter = elt.vec.find(elt.i);
    if (iter != elt.vec.end()) {
      if (iter.index() == elt.i)
        val = *iter;
      else
        val = PR(0);
    } else
      val = PR(0);
  }

  inline const_elt_ref(const OneD& vec, int i) {
    typename OneD::const_iterator iter = vec.find(i);
    if (iter != vec.end()) {
      if (iter.index() == i)
        val = *iter;
      else
        val = PR(0);
    } else
      val = PR(0);
  }

  inline operator PR() const { return val; }

protected:
  PR val;
};


template <class T>
ostream& operator<<(ostream& os, const elt_ref<T>& er) {
  typedef typename elt_ref<T>::PR PR; 
  os << PR(er);
  return os;
}

template <class T>
ostream& operator<<(ostream& os, const const_elt_ref<T>& er) {
  typedef typename const_elt_ref<T>::PR PR;
  os << PR(er);
  return os;
}

#define ELTREF_BINARY_OP(OP) \
template <class T, class U> \
T operator OP (const T& a, const elt_ref<U>& e) { \
  return a OP T(e); \
} \
template <class T, class U> \
T operator OP (const elt_ref<U>& e, const T& a) { \
  return T(e) OP a; \
} \
template <class V, class U> \
typename elt_ref<V>::PR \
operator OP (const elt_ref<V>& f, const elt_ref<U>& e) { \
  typedef elt_ref<V>::PR T; \
  return T(f) OP T(e); \
}

ELTREF_BINARY_OP(+)
ELTREF_BINARY_OP(-)
ELTREF_BINARY_OP(*)
ELTREF_BINARY_OP(/)

#define ELTREF_COMPARISON_OP(OP) \
template <class T, class U> \
bool operator OP (const T& a, const elt_ref<U>& e) { \
  return a OP T(e); \
} \
template <class T, class U> \
bool operator OP (const elt_ref<U>& e, const T& a) { \
  return T(e) OP a; \
} \
template <class V, class U> \
bool operator OP (const elt_ref<V>& f, const elt_ref<U>& e) { \
  typedef elt_ref<V>::PR T; \
  return T(f) OP T(e); \
}

ELTREF_COMPARISON_OP(==)
ELTREF_COMPARISON_OP(!=)
ELTREF_COMPARISON_OP(<)
ELTREF_COMPARISON_OP(>)
ELTREF_COMPARISON_OP(<=)
ELTREF_COMPARISON_OP(>=)


#define CONST_ELTREF_BINARY_OP(OP) \
template <class T, class U> \
T operator OP (const T& a, const const_elt_ref<U>& e) { \
  return a OP T(e); \
} \
template <class T, class U> \
T operator OP (const const_elt_ref<U>& e, const T& a) { \
  return T(e) OP a; \
} \
template <class V, class U> \
typename const_elt_ref<V>::PR \
operator OP (const const_elt_ref<V>& f, const const_elt_ref<U>& e) { \
  typedef const_elt_ref<V>::PR T; \
  return T(f) OP T(e); \
}

CONST_ELTREF_BINARY_OP(+)
CONST_ELTREF_BINARY_OP(-)
CONST_ELTREF_BINARY_OP(*)
CONST_ELTREF_BINARY_OP(/)


#define CONST_ELTREF_COMPARISON_OP(OP) \
template <class T, class U> \
bool operator OP (const T& a, const const_elt_ref<U>& e) { \
  return a OP T(e); \
} \
template <class T, class U> \
bool operator OP (const const_elt_ref<U>& e, const T& a) { \
  return T(e) OP a; \
} \
template <class V, class U> \
bool \
operator OP (const const_elt_ref<V>& f, const const_elt_ref<U>& e) { \
  typedef const_elt_ref<V>::PR T; \
  return T(f) OP T(e); \
}

CONST_ELTREF_COMPARISON_OP(==)
CONST_ELTREF_COMPARISON_OP(!=)
CONST_ELTREF_COMPARISON_OP(<)
CONST_ELTREF_COMPARISON_OP(>)
CONST_ELTREF_COMPARISON_OP(<=)
CONST_ELTREF_COMPARISON_OP(>=)


  //:
  // two indices stored with each element.

template <class T>
struct entry2 {
  typedef entry2<T> self;
  typedef T PR;

  int row, col;
  PR value;

  inline entry2() : row(-1), col(-1), value(0.0) { }
  inline entry2(int r, int c, PR v = PR(0.0))
    : row(r), col(c), value(v) { }
  inline entry2(const self& x) : row(x.row), col(x.col), value(x.value) { }
  inline self& operator =(const self& x) {
    row = x.row;
    col = x.col;
    value = x.value;
    return *this;
  }
  inline bool operator == (const entry2& e) const {
    return row == e.row && col == e.col; }
};

} /* namespace mtl */


#endif


