//
// $COPYRIGHT$
//

#ifndef MTL_NOT_AT_H
#define MTL_NOT_AT_H

#include "mtl/mtl_iterator.h"

#include "mtl/config.h"


namespace mtl {

using std::iterator_traits;
using std::random_access_iterator_tag;
using std::input_iterator_tag;

template <class Ran1, class Ran2>
inline bool not_at(const Ran1& a, const Ran2& b, random_access_iterator_tag) {
  return a < b;
}

template <class Iter1, class Iter2>
inline bool not_at(const Iter1& a, const Iter2& b, input_iterator_tag) {
  return a != b;
}

template <class Iter1, class Iter2>
inline bool not_at(const Iter1& a, const Iter2& b) {
  typedef typename iterator_traits<Iter1>::iterator_category Category;
  return mtl::not_at(a, b, Category());
}

inline bool not_at(int a, int b) {
  return a < b;
}

} /* namespace mtl */

#endif // MTL_NOT_AT_H
