#include "qgate.h"
void Q_2x2Gate::Transform(Q_BitSet &q, int bit)
{
	amplitude_vector_t ResultVector;
	Complex temp;

	int maski  = 1 << q.getStateVectorBitNum(bit);
	int k;                                       
  
	for (k = 0; k < q.numStates(); ++k) {
		if (k & maski)	// bit set so we use second row of the matrix
			temp =   _a10 * q.getAmplitude(k ^ maski) + 
				_a11 * q.getAmplitude(k);
		else
			temp  =   _a00 * q.getAmplitude(k) + 
					_a01 * q.getAmplitude(k ^ maski);
		if(ImagOrReal(temp)) ResultVector[k] = temp;
	}
	
	q.changeAmplitudeVector(ResultVector);  
}

/*
void Q_GateMatrix::Controlled::operator() (Q_BitSet &q, unsigned long mask, int bit=0)
	throw (Q_Exception::ControlErr)
//multi-controlled (via mask) operator
//suggested by Rafal Podeszwa
{
	int states = Q_StateVector::States();
	std::vector<Complex> _qArrayTmp(states);
	
	D("Mask given: %d\n", mask);
	reMask(mask, q.Offset());
	D("Remasked with offset %d: %d\n", q.Offset(), mask);

	int maski = 1 << q.Bit(bit);

	D("Controlling: %d \t Controlled: %d\n",mask, maski);
	D("In common: %d\n", mask & maski);
	
	//can't modify controlling bit
	if((mask & maski) != 0) throw Q_Exception::ControlErr();
	int k;

	for(k=0; k < states; ++k) {
		if (k & mask)      //if mask is set
			if (k & maski)  //if controlled bit set
				_qArrayTmp[k] = _a10 * Q_StateVector::Coef(k ^ maski) + 
									 _a11 * Q_StateVector::Coef(k);
			else
				_qArrayTmp[k] = _a00 * Q_StateVector::Coef(k) + 
									 _a10 * Q_StateVector::Coef(k ^ maski);

		if (k & mask)
			Q_StateVector::Coef(k) = _qArrayTmp[k];
	}
}

void opFFT::operator() (Q_BitSet &q, int numbits=-1)
{ 
	if (numbits == -1) numbits = q.Qubits();
   int j,k; 
  
	//operators we will be needing
   opSPhaseShift S;      //conditional phase shift
   Hadamard H;           //hadamard operator
	
   for (j = numbits-1; j>=0; j--) 
   { 
      for (k = numbits-1; k>j; k--)
      {
    		S(q,j,k);		
			D("S(%d,%d)",j,k);
      }
     
		D("H(%d)",j);
      H(q,j);
   } 
}
*/
