// -*- c++ -*-
//
// $COPYRIGHT$
//

#ifndef MTL_INITIALIZE_H
#define MTL_INITIALIZE_H

#include "mtl/matrix_stream.h"

#include "mtl/entry.h"
#include "mtl/mtl_complex.h"
#include "mtl/conj.h"
#include "mtl/mtl_set.h"

namespace mtl {

using std::complex;
using std::conj;

class symmetric_tag;

//need add mmio.c on using
template <class Matrix>
void
__initialize(Matrix& A, matrix_market_stream<typename Matrix::value_type>& s, 
	     symmetric_tag)
{
  entry2<typename Matrix::value_type> e;

  if ( s.is_symmetric() ) {
    while( ! s.eof() ) {
      s >> e;
      int row = e.row;
      int col = e.col;
      A(row, col) = e.value;
    }
  } else {
    cout << " matrix type is symmetric but the matrix in the file is not" << endl;
    assert(0);
  }
}

template <class Matrix, class ANY_TAG>
void
__initialize(Matrix& A, matrix_market_stream<typename Matrix::value_type>& s,
	     ANY_TAG)
{
  entry2<typename Matrix::value_type> e;

  if ( s.is_symmetric() ) {
    while( ! s.eof() ) {
      s >> e;
      int row = e.row;		// g++ internal compiler error
      int col = e.col;		//      A(e.row, e.col) = e.value;
      A(row, col) = e.value;
      if ( s.is_hermitian() )  
	A(e.col, e.row) = std::conj(e.value);
      else
	A(e.col, e.row) = e.value;
    }
  } else {
    while( ! s.eof() ) {
      s >> e;
      int row = e.row;
      int col = e.col;
      A(row, col) = e.value;
    }
  }
}

template <class Matrix>
void
initialize(Matrix& A, matrix_market_stream<typename Matrix::value_type>& s)
{
  typedef typename Matrix::value_type T;
  typedef typename Matrix::shape Shape;
  mtl::set(A, T(0));
  mtl::__initialize(A, s, Shape());
}

//need add iohb.c on using
template <class Matrix>
void
initialize(Matrix& A, harwell_boeing_stream<typename Matrix::value_type>& s)
{ //for hbs, shape doesn't matter
  typedef typename Matrix::size_type Int;
  typedef typename Matrix::value_type T;

  mtl::set(A, T(0));
  entry2<T> e;

  while( ! s.eof() ) {
    s >> e;
    Int row = e.row;
    Int col = e.col;
    A(row, col) = e.value;
  }
}

} /* namespace mtl */

#endif
