#ifndef MTL_PARTITION_H
#define MTL_PARTITION_H

namespace mtl {

//: This currenlty only does dense matrices, a different
//  version needs to be written for sparse matrices

template <class Sequence1, class Sequence2, class Matrix>
inline typename Matrix::partitioned
partition_matrix(const Sequence1& prows, 
		 const Sequence2& pcols, const Matrix& A)
{
  typedef typename Matrix::size_type size_type;
  typedef typename Matrix::dim_type dim_type;

  size_type pms = prows.size() + 1;
  size_type pns = pcols.size() + 1;
  typename Matrix::partitioned  P(pms, pns);
  typename Sequence1::const_iterator mi;
  typename Sequence2::const_iterator ni;
  size_type i, j, mprev, nprev;
    
  i = 0;
  mi = prows.begin();
  mprev = 0;

  j = 0;
  ni = pcols.begin();
  nprev = 0;
  P(i,j) = A.sub_matrix(mprev, *mi, nprev, *ni);
  nprev = *ni;
  for (++ni, ++j; ni != pcols.end(); ++ni, ++j) {
    P(i,j) = A.sub_matrix(mprev, *mi, nprev, *ni);
    nprev = *ni;
  }
  P(i,j) = A.sub_matrix(mprev, *mi, nprev, A.ncols());

  mprev = *mi;

  for (++mi, ++i; mi != prows.end(); ++mi, ++i) {

    j = 0;
    ni = pcols.begin();
    nprev = 0;
    P(i,j) = A.sub_matrix(mprev, *mi, nprev, *ni);
    nprev = *ni;
    for (++ni, ++j; ni != pcols.end(); ++ni, ++j) {
      P(i,j) = A.sub_matrix(mprev, *mi, nprev, *ni);
      nprev = *ni;
    }
    P(i,j) = A.sub_matrix(mprev, *mi, nprev, A.ncols());

    mprev = *mi;
      
  }

  j = 0;
  ni = pcols.begin();
  nprev = 0;
  P(i,j) = A.sub_matrix(mprev, A.nrows(), nprev, *ni);
  nprev = *ni;
  for (++ni, ++j; ni != pcols.end(); ++ni, ++j) {
    P(i,j) = A.sub_matrix(mprev, A.nrows(), nprev, *ni);
    nprev = *ni;
  }
  P(i,j) = A.sub_matrix(mprev, A.nrows(), nprev, A.ncols());

  return P;
  }

} /* namespace mtl */

#endif /* MTL_PARTITION_H */
