//
// $COPYRIGHT$
//

#ifndef MTL_REVERSE_ITER_H
#define MTL_REVERSE_ITER_H


#include "mtl/mtl_iterator.h"

#include "mtl/config.h"

namespace mtl {


#if STD_REVERSE_ITER
template <class Iter>
class reverse_iter : public std::reverse_iterator<Iter> {
	typedef std::reverse_iterator<Iter> super;
#else
template <class Iter>
class reverse_iter : public std::reverse_iterator<Iter,typename Iter::value_type> {
  typedef std::reverse_iterator<Iter, typename Iter::value_type> super;
#endif
public:
  typedef typename super::difference_type difference_type;
  typedef typename super::value_type value_type;
  typedef typename super::reference reference;
  typedef typename super::iterator_category iterator_category;

  inline reverse_iter() {}
  
  inline explicit
  reverse_iter(Iter x) : super(x) {}

  inline difference_type index() const {
    Iter tmp = current;
    return (--tmp).index(); 
  }
  inline difference_type row() const {
    Iter tmp = current;
    return (--tmp).row(); 
  }
  inline difference_type column() const {
    Iter tmp = current;
    return (--tmp).column(); 
  }

};

} /* namespace mtl */

#endif
