#include "qgate.h"

void Q_Gate::ApplyTo(Q_BitSet &q, int bit)
{
	amplitude_vector_t ResultVector;
	Complex temp;

	D("Applying to bit %d\n", q.getStateVectorBitNum(bit));
	int maski  = 1 << q.getStateVectorBitNum(bit);
	int k;                                       
  
	for (k = 0; k < q.QSV->States(); ++k) {
		if (k & maski)	// bit set so we use second row of the matrix
			temp =   _a10 * q.getAmplitude(k ^ maski) + 
				_a11 * q.getAmplitude(k);
		else
			temp  =   _a00 * q.getAmplitude(k) + 
					_a01 * q.getAmplitude(k ^ maski);
		if(ImagOrReal(temp)) ResultVector[k] = temp;
	}
	q.QSV->_AmplitudeVector = ResultVector;
}

Q_Gate Gates::Unitary(double alpha, double beta, double delta, double theta)
{
	return Q_Gate(
		Complex(cos(delta+alpha/2+beta/2)*cos(theta/2),
                        sin(delta+alpha/2+beta/2)*cos(theta/2)),

                Complex(cos(delta+alpha/2-beta/2)*sin(theta/2),
                	sin(delta+alpha/2-beta/2)*sin(theta/2)),

                Complex(-cos(delta-alpha/2+beta/2)*sin(theta/2),
                        -sin(delta-alpha/2+beta/2)*sin(theta/2)),

                Complex(cos(delta-alpha/2-beta/2)*cos(theta/2),
                	sin(delta-alpha/2-beta/2)*cos(theta/2))
	);
}

Q_Gate Gates::RotQubit(double theta)
{
	return Q_Gate(	cos(theta/2), sin(theta/2), 
			-sin(theta/2), cos(theta/2));
}

Q_Gate Gates::RotPhase(double alpha)
{
	return Q_Gate(	Complex(cos(alpha/2), sin(alpha/2)), 0,
			0, Complex(cos(alpha/2), -sin(alpha/2)));
}

Q_Gate Gates::PhaseShift(double delta)
{
	return Q_Gate(	Complex(cos(delta), sin(delta)),0,
			0, Complex(cos(delta), sin(delta)));
}

Q_Gate Gates::Hadamard()
{
	return Q_Gate(	M_SQRT1_2, M_SQRT1_2, 
			M_SQRT1_2, -M_SQRT1_2);
}

Q_Gate Gates::Not()
{
	return Q_Gate(	0,1,
			1,0);
}
