/* exceptions.h

Exceptions for OpenQubit.
This file is part of the OpenQubit project.

Copyright (C) 1998-1999 OpenQubit.org
Yan Pritzker <skwp@thepentagon.com>

Please see the CREDITS file for contributors.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef _EXCEPTION_H_
#define _EXCEPTION_H_

//! author="Yan Pritzker"
//! lib="Exception Classes"

struct QException
//: Group of all OpenQubit Exceptions.
{

struct GeneralErr
//: General Exception.
	{ virtual char* msg()=0; };

struct MallocErr : public GeneralErr 
//: Memory Allocation Exception.
{
	char* msg()
		{ return "Error: Could not allocate specified number of bits.\n"; }
};

struct RangeErr : public GeneralErr 
//: Range Error.
{
	char* msg()
		{ return "Error: Index is not valid.\n"; }
};

struct SizeErr : public GeneralErr
//: Coefficient array too large for state.
{
	char* msg()
		{ return 
			"Error: Number of specified coefficients must equal number of possible outcomes for this register.\n"; }
};

struct NormErr : public GeneralErr
//: Illegal normalized value for coefficients.
{
	char* msg()
		{ return "Error: Normalized sum of specified coefficients does not (approximately)equal one.\n"; }
};

struct ControlErr : public GeneralErr
//: Attempt to modify controlling bit.
{
	char* msg()
		{ return "Error: Bit to be operated on is included in controlling bitmask.\n"; }
};

};

#endif
