/* main.cc

Main testing code.
This file is part of the OpenQubit project.

Copyright (C) 1998-1999 OpenQubit.org
Yan Pritzker <skwp@thepentagon.com>

Please see the CREDITS file for contributors.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <string.h>
#include <iostream.h>
#include "quantum"

int x;
int M;
	
//check for obvious solutions...even number, prime number
//etc...
void Check()
{
	if((M % 2) == 0)
	{
		printf("Number is even. Factors found.\n");
		printf("%d = 2 * %d\n", M,M/2);
		exit(0);
	}

	if(IsPrime(M))
	{
		printf("Numer is prime. It cannot be factored.\n");
		exit(0);
	}

	printf("Enter number from 1..%d: ",M-1);
	scanf("%d",&x);

	int factor = GCD(M,x);

	if (factor != 1 && factor != M) {
		printf("Factor found since GCD(%d,%d)=%d.\n",M,x,factor);
		printf("%d = %d * %d.\n",M,factor,M/factor);
		exit(0);
	}

}

void main()
{
	cout  << "OpenQubit version NewSpin, Copyright (C) 1999 OpenQubit.org\n"
         << "The OpenQubit library comes with ABSOLUTELY NO WARRANTY; "
         << "for details\nread COPYING. This is free software, and you "
         << "are welcome to redistribute\nit under certain conditions. "
         << "Please see the file COPYING for details.\n\n";


	WalshHadamard WH;
	ModExp MX;
	FFT	fft;

	printf("Enter number to factor: ");
	scanf("%d",&M);

	Check();

	const int first = count_bits(M*M);	
	const int second = count_bits(M);
	
	//initialize with seed 0
	QState::Initialize(first+second,0);

	QRegister reg1(first);
	QRegister reg2(second);
	
	printf("Preparing equal superposition in first register.\n");
	WH(reg1);	//set up equal superposition in first register
	
	QState::Save("superposition.qsf");

	printf("Modular exponentiation.\n");
	MX(reg1,x,M,first);
	
	QState::Save("modexp.qsf");

	printf("Measure of second register.\n");
	int result=reg2.Measure();

	QState::Save("measure2.qsf");

	printf("Second register is %d.\n",result);

	printf("Fourier transformation of first register.\n");
	fft(reg1);

	QState::Save("fft.qsf");

	printf("Measurement of the first register.\n");
	result = reg1.Measure();
	printf("Measured state is %d: \n",result);
	QState::Print();

	//result %= 1<<first;
	result = Reverse(result,first);
	printf("Result is %d\n",result);
	printf("Fourier domain is %d\n",1<<first);
	int period = PeriodExtract(result,M,1<<first);
		
	printf("Period guess is: %d\n",period);
	if(period % 2 != 0) printf("Procedure failed. Odd period.\n");
	else {
		if(period != 0 && modexp(x,period,M) == 1) {
			int factor = GCD(modexp(x,period/2,M)+1,M);
			printf("%d\n",factor);
			if(factor!=1 && factor!=M)
				printf("Found factors. %d = %d * %d.\n",M,factor,M/factor);
		} else {
			printf("Incorrect period guess.\n");
			printf("Try again with different starting number.\n");
		}
	}
}
