#include "qop.h"

void SingleBit::operator() (QRegister &q, int bit=0)
{
	//results will first go here
	int states = QState::States();
	std::vector<Complex> _qArrayTmp(states);
	
	int maski  = 1 << q.Bit(bit);  // set bit mask
	int k;
  
	for (k = 0; k < states; ++k)
		if (k & maski)  		// bit set so we use second row of the matrix
			_qArrayTmp[k] = _a10 * QState::Coef(k ^ maski) + 
								 _a11 * QState::Coef(k);
		else
			_qArrayTmp[k] = _a00 * QState::Coef(k) + 
								 _a01 * QState::Coef(k ^ maski);
       
	for (k = 0; k < states; k++)
		QState::Coef(k) = _qArrayTmp[k]; //copy result
}

void Controlled::operator() (QRegister &q, unsigned long mask, int bit=0)
	throw (QException::ControlErr)
//multi-controlled (via mask) operator
//suggested by Rafal Podeszwa
{
	int states = QState::States();
	std::vector<Complex> _qArrayTmp(states);
	
	D("Mask given: %d\n", mask);
	reMask(mask, q.Offset());
	D("Remasked with offset %d: %d\n", q.Offset(), mask);

	int maski = 1 << q.Bit(bit);

	D("Controlling: %d \t Controlled: %d\n",mask, maski);
	D("In common: %d\n", mask & maski);
	
	//can't modify controlling bit
	if((mask & maski) != 0) throw QException::ControlErr();
	int k;

	for(k=0; k < states; ++k) {
		if (k & mask)      //if mask is set
			if (k & maski)  //if controlled bit set
				_qArrayTmp[k] = _a10 * QState::Coef(k ^ maski) + 
									 _a11 * QState::Coef(k);
			else
				_qArrayTmp[k] = _a00 * QState::Coef(k) + 
									 _a10 * QState::Coef(k ^ maski);

		if (k & mask)
			QState::Coef(k) = _qArrayTmp[k];
	}
}

void opFFT::operator() (QRegister &q, int numbits=-1)
{ 
	if (numbits == -1) numbits = q.Qubits();
   int j,k; 
  
	//operators we will be needing
   opSPhaseShift S;      //conditional phase shift
   Hadamard H;           //hadamard operator
	
   for (j = numbits-1; j>=0; j--) 
   { 
      for (k = numbits-1; k>j; k--)
      {
    		S(q,j,k);		
			D("S(%d,%d)",j,k);
      }
     
		D("H(%d)",j);
      H(q,j);
   } 
}
