/* binary.cc

Implementation of various utility algorithms.
This file is part of the OpenQubit project.

Copyright (C) 1998-1999 OpenQubit.org
Yan Pritzker <skwp@thepentagon.com>

Please see the CREDITS file for contributors.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "binary.h"

char *dtob(unsigned long value, unsigned short pad = 0)
{
	int numBits = count_bits(value), index = 0;
	int length = (pad > numBits) ? pad : numBits;
	char *result = new char[length+1];
	unsigned int mask = 1 << (numBits - 1);

	if(pad > numBits)
	{
		for(index = 0; index < pad-numBits; index++)
			result[index] = '0';
		result[index] = '\0';
	}

	// if pad>numBits, then index will be greater than zero at
	// this point (in fact, it will be positioned right after
	// the pad of zeroes), but if not, then index will have been
	// initialized to zero at its declaration
	for( ; mask && index < length; index++, mask >>= 1)
	{
		result[index] = (value & mask) ? '1' : '0';
	}
	result[index] = '\0';

   return result;
}
