/* binary.h

Definition of several utility algorithms.
This file is part of the OpenQubit project.

Copyright (C) 1998-1999 OpenQubit.org
Yan Pritzker <skwp@thepentagon.com>

Please see the CREDITS file for contributors.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef _BINARY_H_
#define _BINARY_H_

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <math.h>


char *dtob(unsigned long value, unsigned short pad = 0);

inline int count_bits(unsigned long value) 
//: Count number of bits in a number
{
    int nbits = 0;
    while (value) {
        nbits++;
        value >>= 1;
    }

    // If we "need" 0 bits, return 1 so we at least print a 0.
    return nbits ? nbits : 1;
}

inline bool IsBitSet(int n, unsigned short i)
//: Check if a bit is set in a number
	{ return (n >> i) & 1; }

#endif
