/* main.cc

Main testing code.
This file is part of the OpenQubit project.

Copyright (C) 1998-1999 OpenQubit.org
Yan Pritzker <skwp@thepentagon.com>

Please see the CREDITS file for contributors.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include <string.h>
#include <iostream.h>
#include "qstate.h"

int main() {
	QState *qureg;
	
	//this is the state |psi> = sqrt(1/3)(|01> + |10> - |11>)
	//note this state is not a direct tensor product...

	Complex StateCoefs[] =  {0, sqrt(1.0/3.0), sqrt(1.0/3.0), -sqrt(1.0/3.0)};
	qureg = new QState(2,StateCoefs);
	qureg->Dump("twobits.qsf");
	qureg->Print();
	qureg->Read("twobits.qsf");
	qureg->Print();
	return 0;
}
