/*
Copyright 2004 Massimiliano Montoro (mao@oxid.it)

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License Version 2, as published
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  The program may contain errors that
could cause failures or loss of data, and may be incomplete or contain
inaccuracies.  By using the program, you expressly acknowledge and agree
that use of the program, or any portion thereof, is at your sole and entire
risk.  You are solely responsible for determining the appropriateness of
using, copying, distributing and modifying the program and assume all risks
of exercising your rights under the license, compliance with all applicable
laws, damage to or loss of data, programs or equipment, and unavailability
or interruption of operations.   THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
EXPRESSLY DISCLAIM ALL WARRANTIES AND/OR CONDITIONS, EXPRESS OR IMPLIED,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES AND/OR CONDITIONS OF
MERCHANTABILITY, OF SATISFACTORY QUALITY, OF FITNESS FOR A PARTICULAR
PURPOSE, OF ACCURACY, OF QUIET ENJOYMENT, AND NONINFRINGEMENT OF THIRD
PARTY RIGHTS.  THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES DO NOT WARRANT
AGAINST INTERFERENCE WITH YOUR ENJOYMENT OF THE PROGRAM, THAT THE FUNCTIONS
CONTAINED IN THE PROGRAM WILL MEET YOUR NEEDS, THAT THE OPERATION OF THE
PROGRAM WILL BE UNINTERRUPTED OR ERROR-FREE, OR THAT DEFECTS IN THE PROGRAM
WILL BE CORRECTED. THE DISCLAIMER OF WARRANTY CONSTITUTES AN ESSENTIAL PART
OF THE LICENSE TO USE THE PROGRAM AND NO USE OF THE PROGRAM IS AUTHORIZED
EXCEPT UNDER THE DISCLAIMER.  ALSO, SOME JURISDICTIONS DO NOT ALLOW THE
EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL DAMAGES, SO THAT
EXCLUSION AND LIMITATION MAY NOT APPLY TO YOU.  See the GNU General Public
License Version 2 for more details.

You should have received a copy of the GNU General Public License Version 2
along with this program; if not, write to the Free Software Foundation, 59
Temple Place, Suite 330, Boston, MA 02111-1307 USA.

*/

#include "Inject.h"

typedef unsigned long NTSTATUS;
typedef NTSTATUS (__stdcall *NtQSI_t)( ULONG, PVOID, ULONG, PULONG );
typedef LONG (__stdcall *RtlCUS_t)( UNICODE_STRING*, UNICODE_STRING*, ULONG );
NTSTATUS (__stdcall *NtQuerySystemInformation)( IN ULONG SysInfoClass, IN OUT PVOID SystemInformation,IN ULONG SystemInformationLength, OUT PULONG RetLen );
LONG (__stdcall *RtlCompareUnicodeString)( IN UNICODE_STRING*, IN UNICODE_STRING*, IN ULONG CaseInsensitve );


DWORD __stdcall RemoteThreadFunc(RemoteThreadData* pData)
{
    HINSTANCE hDll;
    pRemoteFunc pFunc;
    int rc = -1;

    hDll = pData->pLoadLibrary( pData->szDllName );
    if(hDll)
	{
        rc = -2;
        pFunc = (pRemoteFunc)pData->pGetProcAddress( hDll, pData->szFuncName );
		if(pFunc){
            rc = pFunc(pData->szInputFileName, pData->szOutputFileName, pData->magic );
		}
        pData->pFreeLibrary(hDll);
    }
    return rc;
}

void DummyFuncForSize( )
{
    return;
}


DWORD EnableDebugPriv(void)
{
	HANDLE hToken = 0;
	DWORD dwErr = 0;
	TOKEN_PRIVILEGES newPrivs;

	if (!OpenProcessToken (GetCurrentProcess (),TOKEN_ADJUST_PRIVILEGES,&hToken)){
		dwErr = GetLastError ();
		printf ("Unable to open process token: %d\n", dwErr);
		goto exit;
	}

	if (!LookupPrivilegeValue (NULL, SE_DEBUG_NAME,&newPrivs.Privileges[0].Luid)){
		dwErr = GetLastError ();
		printf ("Unable to lookup privilege: %d\n", dwErr);
		goto exit;
	}

	newPrivs.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
	newPrivs.PrivilegeCount = 1;
	
	if (!AdjustTokenPrivileges (hToken, FALSE, &newPrivs, 0, NULL, NULL)){
		dwErr = GetLastError ();
		printf ("Unable to adjust token privileges: %d\n", dwErr);
		goto exit;
	}

 exit:
	if (hToken) CloseHandle (hToken);

	return dwErr;
}

DWORD GetLsassPid( )
{
    HINSTANCE hNtDll;
    NTSTATUS rc;
    ULONG ulNeed = 0;
    void *buf = NULL;
    size_t len = 0;
    int ret = 0;

    hNtDll = LoadLibrary( "NTDLL" );
    if(!hNtDll) {
		ret = 0;
		goto exit;
	}

    NtQuerySystemInformation = (NtQSI_t)GetProcAddress( hNtDll, "NtQuerySystemInformation" );
    if (!NtQuerySystemInformation) {
		ret = 0;
		goto exit;
	}

    RtlCompareUnicodeString = (RtlCUS_t)GetProcAddress( hNtDll, "RtlCompareUnicodeString" );
    if(!RtlCompareUnicodeString) {
		ret = 0;
		goto exit;
	}

    do {
       	delete[] buf;
        len += 2000;
        buf = new BYTE[len];
        if(!buf) {
			ret = 0;
			goto exit;
		}
        rc = NtQuerySystemInformation( 5, buf, len, &ulNeed );
    } while( rc == 0xc0000004 );  

    if(rc<0){
		ret = 0;
		goto exit;
	}

    {
        struct process_info *p = (struct process_info*)buf;
        bool endlist = false;
        UNICODE_STRING lsass = { 18, 20, L"LSASS.EXE" };

        while(!endlist){
            if( p->ProcessName.Buffer && !RtlCompareUnicodeString( &lsass, &p->ProcessName, 1)){
                ret = p->ProcessId;
                goto exit;
            }
            endlist = p->NextEntryDelta == 0;
            p = (struct process_info *)(((BYTE*)p) + p->NextEntryDelta);
        }
    }

 exit:
    delete[] buf;
    if(hNtDll) FreeLibrary(hNtDll);
    return ret;
}