/*
Copyright 2004 Massimiliano Montoro (mao@oxid.it)

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License Version 2, as published
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  The program may contain errors that
could cause failures or loss of data, and may be incomplete or contain
inaccuracies.  By using the program, you expressly acknowledge and agree
that use of the program, or any portion thereof, is at your sole and entire
risk.  You are solely responsible for determining the appropriateness of
using, copying, distributing and modifying the program and assume all risks
of exercising your rights under the license, compliance with all applicable
laws, damage to or loss of data, programs or equipment, and unavailability
or interruption of operations.   THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
EXPRESSLY DISCLAIM ALL WARRANTIES AND/OR CONDITIONS, EXPRESS OR IMPLIED,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES AND/OR CONDITIONS OF
MERCHANTABILITY, OF SATISFACTORY QUALITY, OF FITNESS FOR A PARTICULAR
PURPOSE, OF ACCURACY, OF QUIET ENJOYMENT, AND NONINFRINGEMENT OF THIRD
PARTY RIGHTS.  THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES DO NOT WARRANT
AGAINST INTERFERENCE WITH YOUR ENJOYMENT OF THE PROGRAM, THAT THE FUNCTIONS
CONTAINED IN THE PROGRAM WILL MEET YOUR NEEDS, THAT THE OPERATION OF THE
PROGRAM WILL BE UNINTERRUPTED OR ERROR-FREE, OR THAT DEFECTS IN THE PROGRAM
WILL BE CORRECTED. THE DISCLAIMER OF WARRANTY CONSTITUTES AN ESSENTIAL PART
OF THE LICENSE TO USE THE PROGRAM AND NO USE OF THE PROGRAM IS AUTHORIZED
EXCEPT UNDER THE DISCLAIMER.  ALSO, SOME JURISDICTIONS DO NOT ALLOW THE
EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL DAMAGES, SO THAT
EXCLUSION AND LIMITATION MAY NOT APPLY TO YOU.  See the GNU General Public
License Version 2 for more details.

You should have received a copy of the GNU General Public License Version 2
along with this program; if not, write to the Free Software Foundation, 59
Temple Place, Suite 330, Boston, MA 02111-1307 USA.

*/

#include "windows.h"
#include "stdio.h"


typedef DWORD (WINAPI *LsaICryptUnprotectData) (PVOID pBuffer, DWORD dwSize, DWORD, DWORD, DWORD, DWORD, DWORD flags, DWORD, PVOID pOutput, DWORD* cbSize);
static LsaICryptUnprotectData pLsaICryptUnprotectData;

void DumpFile(char* filename, void* buffer,int size, BOOL Append)
{
	FILE* f;

	if (Append)
		f=fopen(filename,"ab");
	else
		f=fopen(filename,"wb");

	if (f==NULL){
		return;
	}

	if (Append == TRUE) fseek(f,0,SEEK_END);
	fwrite(buffer,size,1,f); 
	fclose(f);
}

int __declspec(dllexport) DumpCF(char *szInputFile, char *szOutputFile, LPVOID lpParameter )
{
	unsigned char* buffer = NULL;
	unsigned char entropy[16];
	DWORD dwSize = 0;
	FILE* credfile = NULL;
	HINSTANCE hLsasrv = 0;
    DWORD rc;
	DWORD cbSize;
	int res = 1;

    hLsasrv = LoadLibrary ("lsasrv.dll");
    pLsaICryptUnprotectData = (LsaICryptUnprotectData) GetProcAddress (hLsasrv, "LsaICryptUnprotectData");
	if( !pLsaICryptUnprotectData ) 
    {
        goto exit;
    }
	
	credfile = fopen(szInputFile,"rb");
	if (credfile == NULL) goto exit;

	fseek(credfile, 0, SEEK_END);
	dwSize = ftell(credfile);
	fseek(credfile, 0, SEEK_SET);

	buffer = (unsigned char*) malloc (dwSize);
	memset (buffer,0,sizeof(buffer));

	fread (buffer, dwSize, 1, credfile);
	fclose (credfile);

	cbSize = 0;
	memset (entropy,0,sizeof(entropy));

	pLsaICryptUnprotectData ( buffer, dwSize, 0,0,0,0, 0x20000041, 0, entropy, &cbSize);
	rc = GetLastError ();
	if (rc!=0) goto exit;

	DumpFile (szOutputFile, buffer, dwSize, FALSE);
	res = 0;

exit:
	if (buffer!=NULL) free (buffer);
    if (hLsasrv) FreeLibrary (hLsasrv);
	return res;
}