/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros;

import com.proofsecure.paros.AdminHandler;
import com.proofsecure.paros.Global;
import com.proofsecure.paros.Proxy;
import com.proofsecure.paros.Session;
import com.proofsecure.paros.util.Util;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Random;
import java.util.Vector;

public class AdminServer
extends Proxy {
    public static int ADMIN_SERVER_PORT = 8099;
    public static String ADMIN_SERVER_NAME = "127.0.0.1";
    public static Vector IPAllowed = new Vector();
    public static String DOCROOT = "." + File.separator + "adminpages";
    private static Session session = new Session();
    private static String authCode;

    AdminServer(String proxyIP, int port) {
        super(proxyIP, port);
        try {
            DOCROOT = new File(DOCROOT).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IPAllowed.add("127.0.0.1");
        Random randomGenerator = new Random();
        authCode = Long.toString(Math.abs(randomGenerator.nextLong()));
    }

    String getAuthCode() {
        return authCode;
    }

    Session getSession() {
        return session;
    }

    public synchronized boolean startServer() {
        if (this.mIsProxyRunning) {
            return false;
        }
        this.mIsProxyRunning = false;
        this.mIsExit = false;
        this.myThread = new Thread(this);
        this.myThread.setDaemon(true);
        this.myThread.setPriority(6);
        this.myThread.start();
        try {
            this.mProxySock = Global.ssl.listen(this.mProxyPort, 300, InetAddress.getByName(this.mProxyIP));
            this.mProxySock.setSoTimeout(3000);
            this.mIsProxyRunning = true;
            System.out.println("Admin server started.");
        }
        catch (Exception e) {
            System.out.println("Error: Cannot open port.");
            return false;
        }
        return true;
    }

    public boolean isAccessAllowed(Socket in) {
        InetAddress clientAddr = in.getInetAddress();
        return IPAllowed.indexOf(clientAddr.getHostAddress()) != -1;
    }

    public void run() {
        Socket clientSock = null;
        while (!this.mIsExit) {
            try {
                if (this.mIsProxyRunning) {
                    AdminHandler p = new AdminHandler(this);
                    clientSock = this.mProxySock.accept();
                    p.start(clientSock);
                    continue;
                }
                Util.sleep(100);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getDocRoot() {
        return DOCROOT;
    }

    public static void main(String[] args) {
        AdminServer server = new AdminServer(ADMIN_SERVER_NAME, ADMIN_SERVER_PORT);
        boolean success = server.startServer();
        if (!success) {
            System.out.println("Error Admin server initialization, please exit");
        }
        while (true) {
            System.gc();
            Util.sleep(800000);
        }
    }
}

