/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.filter;

import com.proofsecure.paros.filter.Filter;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpRequestHeader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;

public class LogGetQuery
implements Filter {
    private final String logFile = "get.xls";
    private final String delim = "\t";
    private final int MAX_FORM_FIELDS = 80;
    private File selFile;
    private Pattern pSeparator = Pattern.compile("([^=&]+)[=]([^=&]*)");
    private Matcher matcher2;

    public LogGetQuery() {
        this.selFile = new File("get.xls");
    }

    public JDialog getDialog() {
        JDialog dialog = new JDialog(){

            public String toString() {
                return "LogGetQuery";
            }

            public void show() {
            }
        };
        return dialog;
    }

    public void process(HttpHeader header, HttpBody body) {
        HttpRequestHeader reqheader;
        if (header != null && header instanceof HttpRequestHeader && header.isText() && (reqheader = (HttpRequestHeader)header).getMethod().equalsIgnoreCase("GET")) {
            try {
                String uri = reqheader.getURIHostPathQuery();
                String host = reqheader.getHostName();
                int port = reqheader.getHostPort();
                int pos = uri.indexOf("?");
                if (pos != -1) {
                    String firstline = String.valueOf(reqheader.getHostName()) + "\t" + reqheader.getHostPort() + "\t" + uri.substring(0, pos);
                    Hashtable param = this.parseParameter(uri.substring(pos + 1));
                    this.writeLogFile(firstline, param);
                } else {
                    String firstline = String.valueOf(reqheader.getHostName()) + "\t" + reqheader.getHostPort() + "\t" + uri;
                    this.writeLogFile(firstline, null);
                }
            }
            catch (Exception aa) {
                aa.printStackTrace();
            }
        }
    }

    public String usage() {
        return "Record all GET query into file get.xls";
    }

    private synchronized void writeLogFile(String line, Hashtable param) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.selFile, true));
            out.write(String.valueOf(line) + "\r\n");
            if (param != null) {
                Enumeration v = param.keys();
                while (v.hasMoreElements()) {
                    String name = (String)v.nextElement();
                    String value = (String)param.get(name);
                    out.write("\t" + name + "\t" + value + "\r\n");
                }
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Hashtable parseParameter(String param) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            this.matcher2 = this.pSeparator.matcher(param);
            while (this.matcher2.find()) {
                table.put(this.matcher2.group(1), this.matcher2.group(2));
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
        return table;
    }
}

