/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.log;

import com.proofsecure.paros.log.Dump;
import com.proofsecure.paros.log.DumpAnalyzerGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OpenFileDialog
extends JDialog
implements ListSelectionListener {
    private final String FRAME_NAME = "Open Log File";
    private JPanel BottomPanel;
    private JButton btnCancel;
    private JButton btnOk;
    private JList fileList;
    private JScrollPane jScrollPane1;
    private JTextField upperText;
    private JTextField statusBar;
    private String logName = null;
    private DefaultListModel listModel = new DefaultListModel();

    public OpenFileDialog() {
        this.initComponents();
        this.createList();
    }

    private void createList() {
        File dir = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + Dump.PROJECT_DIR);
        String[] children = dir.list();
        if (children != null) {
            Pattern logPattern = Pattern.compile("(.+)_" + Dump.INDEX_FILE);
            Matcher matcher = null;
            int i = 0;
            while (i < children.length) {
                String filename = children[i];
                matcher = logPattern.matcher(filename);
                if (matcher.find()) {
                    this.listModel.addElement(matcher.group(1));
                }
                ++i;
            }
        }
        this.setListModel(this.listModel);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.fileList = new JList();
        this.BottomPanel = new JPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.upperText = new JTextField();
        this.statusBar = new JTextField();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OpenFileDialog.this.exitForm(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.fileList);
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenFileDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.BottomPanel.add(this.btnOk);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenFileDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.BottomPanel.add(this.btnCancel);
        this.statusBar.setEditable(false);
        this.statusBar.setText("");
        centerPanel.add((Component)this.jScrollPane1, "Center");
        centerPanel.add((Component)this.BottomPanel, "South");
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.upperText.setEditable(false);
        this.upperText.setText("Select a log below in Paros directory 'Project'");
        this.getContentPane().add((Component)this.upperText, "North");
        this.setResizable(false);
        this.setTitle("Open Log File");
        this.fileList.addListSelectionListener(this);
        this.pack();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        DumpAnalyzerGUI dumpGUI = new DumpAnalyzerGUI(new Dump(this.logName, false, false));
        dumpGUI.setCurSession(false);
        String createDate = "";
        if (this.logName.indexOf("_") != -1) {
            SimpleDateFormat staticDateFormat = new SimpleDateFormat();
            Date dateTime = new Date(Long.parseLong(this.logName.substring(this.logName.indexOf("_") + 1, this.logName.length())));
            createDate = " , Created on " + staticDateFormat.format(dateTime);
        }
        dumpGUI.setTitle(String.valueOf(this.logName) + createDate);
        dumpGUI.show();
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void exitForm(WindowEvent evt) {
        this.dispose();
    }

    public void setListModel(DefaultListModel m) {
        this.listModel = m;
        this.fileList.setModel(m);
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            if (this.fileList.getSelectedValue() == null) {
                return;
            }
            this.logName = (String)this.fileList.getSelectedValue();
        }
        if (this.logName != null && this.logName.indexOf("_") != -1) {
            SimpleDateFormat staticDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss", Locale.ENGLISH);
            Date dateTime = new Date(Long.parseLong(this.logName.substring(this.logName.indexOf("_") + 1, this.logName.length())));
            String createDate = "Created on " + staticDateFormat.format(dateTime);
            this.statusBar.setText(createDate);
        } else if (this.logName != null && this.logName.equals("session")) {
            this.statusBar.setText("Current session log file");
        } else if (this.logName != null && this.logName.equals("scan")) {
            this.statusBar.setText("Last scan log file");
        } else {
            this.statusBar.setText("");
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Locale.setDefault(Locale.ENGLISH);
        OpenFileDialog d = new OpenFileDialog();
        d.show();
    }

    public DefaultListModel getListModel() {
        return this.listModel;
    }
}

