/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.network;

import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpUtil;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpRequestHeader
extends HttpHeader {
    public static final String OPTIONS = "OPTIONS";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String TRACE = "TRACE";
    public static final String CONNECT = "CONNECT";
    public static final String HOST = "Host";
    static final Pattern patternRequestLine = Pattern.compile("(\\w+) +(\\S+) +(HTTP/\\d+\\.\\d+)", 2);
    protected static final Pattern patternHostHeader = Pattern.compile("([^:]+)\\s*:?\\s*(\\d*)");
    protected static final Pattern patternImage = Pattern.compile("\\.(jpg|jpeg|gif|tiff|tif|png)\\z", 2);
    protected static final Pattern patternPartialRequestLine = Pattern.compile("\\A *(OPTIONS|GET|HEAD|POST|PUT|DELETE|TRACE|CONNECT)\\b", 2);
    private String mMethod = "";
    private String sUri = "";
    private String mHostName = "";
    private int mHostPort = 80;
    private boolean mIsSecure = false;
    private boolean mIsAbsoluteUriRequired = false;

    public HttpRequestHeader() {
    }

    public HttpRequestHeader(String data) throws HttpMalformedHeaderException {
        this();
        this.setMessage(data);
    }

    public void setMessage(String data) throws HttpMalformedHeaderException {
        super.setMessage(data);
        try {
            if (!this.parse()) {
                this.mMalformedHeader = true;
            }
        }
        catch (Exception e) {
            this.mMalformedHeader = true;
        }
        if (this.mMalformedHeader) {
            throw new HttpMalformedHeaderException();
        }
    }

    public String getMethod() {
        return this.mMethod;
    }

    public void setMethod(String method) {
        this.mMethod = method.toUpperCase();
        this.mStartLine = String.valueOf(this.getMethod()) + " " + this.getURI() + " " + this.getVersion();
    }

    public String getURI() {
        return this.sUri;
    }

    public void setURI(String uri) {
        if (uri.startsWith("https://")) {
            uri = "http://" + uri.substring("https://".length());
            this.mIsSecure = true;
        } else if (uri.startsWith("http://")) {
            this.mIsSecure = false;
        }
        if (!uri.startsWith("http://")) {
            uri = "http://" + uri;
        }
        try {
            this.sUri = HttpUtil.encodeURI(uri);
            this.mStartLine = String.valueOf(this.getMethod()) + " " + this.sUri + " " + this.getVersion();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        String hostHeader = this.getHostHeader(uri);
        this.parseHostName(hostHeader);
    }

    public String getURIPathQuery() {
        String result = this.sUri;
        int pos = result.indexOf("//");
        if (pos > -1) {
            result = (pos = result.indexOf("/", pos + 2)) > -1 ? result.substring(pos) : "";
        }
        if (result.equals("")) {
            result = "/";
        }
        return result;
    }

    public String getURIQuery() {
        int pos = this.sUri.indexOf("?");
        if (pos == -1) {
            return "";
        }
        return this.sUri.substring(pos + 1);
    }

    public String getURIHostPathQuery() {
        StringBuffer sb = new StringBuffer();
        if (this.getSecure()) {
            sb.append("https://" + this.getHostName());
            if (this.getHostPort() != 443) {
                sb.append(":" + this.getHostPort());
            }
        } else {
            sb.append("http://" + this.getHostName());
            if (this.getHostPort() != 80) {
                sb.append(":" + this.getHostPort());
            }
        }
        String result = sb.append(this.getURIPathQuery()).toString();
        return result;
    }

    public String getURIHostPath() {
        String tmpUri = this.getURIHostPathQuery();
        int pos = tmpUri.indexOf("?");
        if (pos > -1) {
            tmpUri = tmpUri.substring(0, pos);
        }
        return tmpUri;
    }

    public boolean getSecure() {
        return this.mIsSecure;
    }

    public void setSecure(boolean isSecure) {
        this.mIsSecure = isSecure;
    }

    public void setVersion(String version) {
        this.mVersion = version.toUpperCase();
        this.mStartLine = String.valueOf(this.getMethod()) + " " + this.getURI() + " " + this.mVersion;
    }

    public int getContentLength() {
        if (this.content_length == -1) {
            return 0;
        }
        return this.content_length;
    }

    protected boolean parse() throws Exception {
        Matcher matcher = patternRequestLine.matcher(this.mStartLine);
        if (!matcher.find()) {
            this.mMalformedHeader = true;
            return false;
        }
        this.mMethod = matcher.group(1);
        this.sUri = matcher.group(2);
        this.mVersion = matcher.group(3);
        if (!this.mVersion.equalsIgnoreCase("HTTP/1.0") && !this.mVersion.equalsIgnoreCase("HTTP/1.1")) {
            this.mMalformedHeader = true;
            return false;
        }
        String hostHeader = null;
        hostHeader = this.mMethod.equalsIgnoreCase(CONNECT) ? this.sUri : (this.getHeader(HOST) != null ? this.getHeader(HOST) : this.getHostHeader(this.sUri));
        this.parseHostName(hostHeader);
        return true;
    }

    private String getHostHeader(String uri) {
        String result = null;
        String scheme = "";
        if (uri.startsWith("http://")) {
            scheme = "http://";
        } else if (uri.startsWith("https://")) {
            scheme = "https://";
        } else {
            return result;
        }
        int startOffset = scheme.length();
        int pos = uri.indexOf(47, startOffset);
        result = pos > -1 ? this.sUri.substring(startOffset, pos) : this.sUri.substring(startOffset);
        return result;
    }

    private void parseHostName(String hostHeader) {
        if (hostHeader == null) {
            return;
        }
        int pos = 0;
        pos = hostHeader.indexOf(58, 2);
        if (pos > -1) {
            this.mHostName = hostHeader.substring(0, pos).trim();
            try {
                this.mHostPort = Integer.parseInt(hostHeader.substring(pos + 1));
            }
            catch (NumberFormatException e) {}
        } else {
            this.mHostName = hostHeader.trim();
        }
    }

    public String getHostName() {
        return this.mHostName;
    }

    public void setHostName(String hostName) {
        this.mHostName = hostName;
    }

    public int getHostPort() {
        return this.mHostPort;
    }

    public void setHostPort(int hostPort) {
        this.mHostPort = hostPort;
    }

    public String getAbsoluteURI() {
        String result = null;
        result = this.sUri.startsWith("http://") ? this.sUri : "http://" + this.getHostName() + result;
        return result;
    }

    public String toStringNoAbsoluteUri() {
        int pos;
        String result = null;
        result = this.sUri.startsWith("http://") ? ((pos = this.sUri.indexOf(47, "http://".length())) > -1 ? this.sUri.substring(pos) : "/") : this.sUri;
        result = String.valueOf(this.mMethod) + " " + result + " " + this.mVersion + this.mLineDelimiter;
        return String.valueOf(result) + this.mMsgHeader + this.mLineDelimiter;
    }

    public boolean isImage() {
        return patternImage.matcher(this.getURIHostPath()).find();
    }

    public static boolean isRequestLine(String data) {
        return patternPartialRequestLine.matcher(data).find();
    }

    private String buildHostPort(String hostName, int hostPort) {
        String result = hostName;
        if (hostPort != 443 && hostPort != 80) {
            result = String.valueOf(result) + ":" + hostPort;
        }
        return result;
    }
}

