/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.util.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;

public class ParsedEntity
extends DefaultMutableTreeNode {
    public static final int DEFAULT = 0;
    public static final int DO_NOT_SCAN = 1;
    private static final String CRLF = "\r\n";
    private static final String DEFAULT_HEADER = "Accept: */*\r\nAccept-Language: en-us\r\nPragma: no-cache\r\nUser-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0;)\r\n";
    private static final String a_BASIC_AUTH = "basicAuth";
    private static final String a_BASIC_AUTH_BASE64 = "basicAuthBase64";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String BASIC = "Basic ";
    private URI mUri = null;
    private boolean mIsSecure = false;
    private String mHostName = "";
    private int mHostPort = 80;
    private HttpRequestHeader mReqHeader = new HttpRequestHeader();
    private HttpBody mReqBody = new HttpBody();
    private String mCaption = "";
    protected Hashtable mAttr = new Hashtable();
    public int mState = 0;

    public ParsedEntity() {
    }

    public ParsedEntity(String caption) {
        super(caption);
    }

    public ParsedEntity(String caption, HttpRequestHeader req, HttpBody body) throws HttpMalformedHeaderException, URISyntaxException {
        this.mCaption = caption;
        this.setUserObject(this.mCaption);
        this.setEntity(req, body);
    }

    public ParsedEntity(String caption, URI uri, boolean isSecure) throws HttpMalformedHeaderException, URISyntaxException {
        this.mCaption = caption;
        this.setUserObject(this.mCaption);
        this.setEntity(uri, isSecure);
    }

    public void setEntity(HttpRequestHeader req, HttpBody body) throws HttpMalformedHeaderException, URISyntaxException {
        String val = "";
        this.setEntity(new URI(req.getURIHostPath()), req.getSecure());
        this.getRequestHeader().setMessage(req.toStringAbsoluteUri());
        this.getRequestHeader().setHeader("If-Modified-Since", null);
        this.getRequestHeader().setHeader("If-None-Match", null);
        this.getRequestHeader().setVersion("HTTP/1.0");
        this.getRequestHeader().setHeader("Connection", null);
        this.getRequestBody().setBody(body.toString());
        this.mIsSecure = req.getSecure();
        this.mHostName = req.getHostName();
        this.mHostPort = req.getHostPort();
        val = req.getHeader("Authorization");
        if (val != null) {
            this.setBasicAuthBase64(val);
        }
    }

    private void setEntity(URI uri, boolean isSecure) throws HttpMalformedHeaderException, URISyntaxException {
        this.mIsSecure = isSecure;
        if (uri.getScheme().equalsIgnoreCase(HTTPS)) {
            this.mIsSecure = true;
        }
        this.mUri = new URI(Util.getURIHostPath(uri, this.mIsSecure));
        this.mHostName = uri.getHost();
        this.mHostPort = uri.getPort();
        String sTmp = this.mUri.getPath();
        if (sTmp == null || sTmp.equals("")) {
            sTmp = "/";
        }
        this.getRequestHeader().setMessage("GET " + sTmp + " HTTP/1.0" + CRLF + DEFAULT_HEADER + CRLF);
        this.getRequestHeader().setSecure(this.mIsSecure);
    }

    public URI getURIHostPath() {
        return this.mUri;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public void setHostName(String hostName) {
        this.mHostName = hostName;
    }

    public int getHostPort() {
        return this.mHostPort;
    }

    public void setHostPort(int hostPort) {
        this.mHostPort = hostPort;
    }

    public boolean getSecure() {
        return this.mIsSecure;
    }

    public void setSecure(boolean isSecure) {
        this.mIsSecure = isSecure;
    }

    public String getBasicAuthBase64() {
        return (String)this.getAttr(a_BASIC_AUTH_BASE64);
    }

    public void setBasicAuthBase64(String basicAuthBase64) {
        if (basicAuthBase64 == null || basicAuthBase64.equals("")) {
            this.mAttr.remove(a_BASIC_AUTH_BASE64);
            this.mAttr.remove(a_BASIC_AUTH);
            return;
        }
        if (basicAuthBase64.substring(0, BASIC.length()).equalsIgnoreCase(BASIC)) {
            basicAuthBase64 = basicAuthBase64.substring(BASIC.length());
        }
        String basicAuth = "";
        try {
            this.mAttr.put(a_BASIC_AUTH_BASE64, BASIC + basicAuthBase64);
            this.mAttr.put(a_BASIC_AUTH, basicAuth);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getBasicAuth() {
        return (String)this.getAttr(a_BASIC_AUTH);
    }

    public void setBasicAuth(String basicAuth) {
        if (basicAuth == null || basicAuth.equals("")) {
            this.mAttr.remove(a_BASIC_AUTH);
            this.mAttr.remove(a_BASIC_AUTH_BASE64);
            return;
        }
        this.mAttr.put(a_BASIC_AUTH, basicAuth);
        String base64 = "";
        this.mAttr.put(a_BASIC_AUTH_BASE64, BASIC + base64);
    }

    protected Object getAttr(String attrName) {
        ParsedEntity entity = this;
        Object val = null;
        while (entity != null) {
            val = entity.getAttr(attrName);
            if (val != null || (entity = (ParsedEntity)entity.getParent()) == null) break;
        }
        return val;
    }

    public HttpRequestHeader getRequestHeader() {
        return this.mReqHeader;
    }

    public HttpBody getRequestBody() {
        return this.mReqBody;
    }

    public void setCaption(String caption) {
        this.mCaption = caption;
        this.setUserObject(this.mCaption);
    }
}

