/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.log.Dump;
import com.proofsecure.paros.log.DumpAnalyzerGUI;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.scan.AbstractScanner;
import com.proofsecure.paros.scan.TestCacheAndMisc;
import com.proofsecure.paros.util.Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScannerOffline
extends AbstractScanner {
    protected static final String CRLF = "\r\n";
    protected static DecimalFormat decFormat = new DecimalFormat("##0.###");

    protected void process() {
    }

    protected void endOfProcess() {
        Global.currentScanner = null;
        Global.scanner.generateAlertReport();
    }

    public ScannerOffline() throws Exception {
        Global.currentScanner = this;
        this.removeAllAlert();
    }

    public synchronized void test(DumpAnalyzerGUI da) {
        long startTime = 0L;
        long diffTime = 0L;
        String curDateTime = Long.toString(da.getDump().getCurDate());
        Global.scanner.removeAllAlert();
        startTime = System.currentTimeMillis();
        Util.writeOutput("Offline scanning ...");
        Pattern patHeader = null;
        patHeader = da.isCurSession() ? Pattern.compile(String.valueOf(Dump.SEPARATOR_LEFT) + "\\d+[-]((\\d+)[.](" + curDateTime + "))" + Dump.SEPARATOR_RIGHT) : Pattern.compile(String.valueOf(Dump.SEPARATOR_LEFT) + "\\d+[-]((\\d+)[.](\\d+))" + Dump.SEPARATOR_RIGHT);
        String line = "";
        String nextID = "";
        Matcher matcher = null;
        CharSequence cs = null;
        TestCacheAndMisc testModel = null;
        try {
            cs = this.fromFile(da.getDump().getFilePath(Dump.REQUEST_FILE));
            matcher = patHeader.matcher(cs);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int startRes = 0;
        while (matcher.find(startRes)) {
            String thisID = matcher.group(1);
            startRes = matcher.end();
            int endRes = matcher.find(startRes) ? matcher.start() : cs.length();
            String request = cs.subSequence(startRes + 2, endRes).toString();
            Vector<String> result = new Vector<String>(2);
            int split = request.indexOf("\r\n\r\n");
            if (split == -1) {
                result.add(String.valueOf(request) + CRLF);
                result.add("");
            } else {
                result.add(String.valueOf(request.substring(0, split)) + CRLF);
                result.add(request.substring(split + 4));
            }
            Vector v = da.searchResponse(thisID);
            try {
                testModel = new TestCacheAndMisc();
                testModel.getRequestHeader().setMessage(result.get(0).toString());
                testModel.getRequestBody().setBody(result.get(1).toString());
                if (v != null) {
                    testModel.getResponseHeader().setMessage(v.get(0).toString());
                    testModel.getResponseBody().setBody(v.get(1).toString());
                } else {
                    testModel.getResponseHeader().setMessage(null);
                    testModel.getResponseBody().setBody(null);
                }
            }
            catch (HttpMalformedHeaderException e) {
                System.out.println("HttpMalformedHeader: " + e.getMessage());
                continue;
            }
            try {
                testModel.scanOffline();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        DecimalFormat decFormat = new DecimalFormat("##0.###");
        diffTime = System.currentTimeMillis() - startTime;
        String diffTimeString = String.valueOf(decFormat.format((double)diffTime / 1000.0)) + "s";
        Util.writeOutput("Offline scanning completed in " + diffTimeString);
        Util.writeStatus("Done.");
        this.endOfProcess();
    }

    private CharSequence fromFile(String filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bbuf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
        CharBuffer cbuf = Charset.forName("8859_1").newDecoder().decode(bbuf);
        return cbuf;
    }

    public static void main(String[] args) {
        try {
            ScannerOffline s = new ScannerOffline();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

