/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.scan.AbstractAppTest;
import com.proofsecure.paros.scan.UrlParam;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Pattern;

abstract class TestAbstractParam
extends AbstractAppTest {
    HttpRequestHeader myReqHeader = new HttpRequestHeader();
    HttpBody myReqBody = new HttpBody();
    String myHostPath = null;
    String myQuery = null;
    private static Pattern staticPatternParam = Pattern.compile("&", 2);

    TestAbstractParam() {
    }

    public String toString() {
        return "TestAbstractParam";
    }

    protected void buildHeader(String hostPath, String query) throws HttpMalformedHeaderException {
        String sUri = hostPath;
        if (query != null && query.length() > 0) {
            sUri = String.valueOf(sUri) + "?" + query;
        }
        this.getRequestHeader().setMessage(this.myReqHeader.toStringAbsoluteUri());
        this.getRequestHeader().setURI(sUri);
    }

    private Vector getParsedParam(String params) {
        Vector<UrlParam> paramList = new Vector<UrlParam>();
        String[] keyValue = staticPatternParam.split(params);
        String key = null;
        String value = null;
        int pos = 0;
        int i = 0;
        while (i < keyValue.length) {
            key = null;
            value = null;
            pos = keyValue[i].indexOf(61);
            try {
                if (pos > 0) {
                    key = keyValue[i].substring(0, pos);
                    value = keyValue[i].substring(pos + 1);
                    paramList.add(new UrlParam(key, value));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return paramList;
    }

    protected void checkUrlOrBody(boolean isBody, String params) throws Exception {
        Vector paramList = this.getParsedParam(params);
        StringBuffer sb = new StringBuffer();
        UrlParam keyValue = null;
        String paramKey = null;
        String paramValue = null;
        int pos = 0;
        this.restore();
        int i = 0;
        while (i < paramList.size() && !this.isSignalStop()) {
            sb.setLength(0);
            paramKey = ((UrlParam)paramList.elementAt((int)i)).key;
            paramValue = ((UrlParam)paramList.elementAt((int)i)).value;
            int j = 0;
            while (j < paramList.size()) {
                keyValue = (UrlParam)paramList.elementAt(j);
                if (i == j) {
                    pos = sb.length();
                } else {
                    sb.append(String.valueOf(keyValue.key) + "=");
                    if (keyValue.value != null && keyValue.value.length() > 0) {
                        sb.append(keyValue.value);
                    }
                    if (j + 1 != i && j < paramList.size() - 1) {
                        sb.append("&");
                    }
                }
                ++j;
            }
            String query = sb.toString();
            this.check(isBody, paramKey, paramValue, query, pos);
            ++i;
        }
    }

    protected abstract void check(boolean var1, String var2, String var3, String var4, int var5) throws IOException;

    protected void createMessage(boolean isBody, String newQuery) throws HttpMalformedHeaderException {
        if (isBody) {
            this.getRequestHeader().setContentLength(newQuery.length());
            this.getRequestBody().setBody(newQuery);
        } else {
            this.buildHeader(this.myHostPath, newQuery.toString());
            this.getRequestBody().setBody(this.myReqBody.toString());
        }
    }

    protected String insertQuery(String oldQuery, int pos, String newParam) {
        String insertParam = "";
        if (newParam == null || newParam.length() == 0) {
            return oldQuery;
        }
        if (pos > 0) {
            insertParam = "&" + insertParam;
        }
        insertParam = String.valueOf(insertParam) + newParam;
        if (pos < oldQuery.length()) {
            insertParam = String.valueOf(insertParam) + "&";
        }
        StringBuffer sb = new StringBuffer(oldQuery);
        String result = sb.insert(pos, insertParam).toString();
        return result;
    }

    protected void init() throws HttpMalformedHeaderException {
        this.myHostPath = new String(this.getRequestHeader().getURIHostPath());
        this.myQuery = new String(this.getRequestHeader().getURIQuery());
        this.myReqHeader.setMessage(this.getRequestHeader().toStringAbsoluteUri());
        this.myReqHeader.setSecure(this.getRequestHeader().getSecure());
        this.myReqBody.setBody(this.getRequestBody().toString());
    }

    protected void restore() throws HttpMalformedHeaderException {
        this.getRequestHeader().setMessage(this.myReqHeader.toStringAbsoluteUri());
        this.getRequestHeader().setSecure(this.myReqHeader.getSecure());
        this.getRequestBody().setBody(this.myReqBody.toString());
    }
}

