/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.network.HttpStatusCode;
import com.proofsecure.paros.scan.TestAbstractParam;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TestBufferOverflow
extends TestAbstractParam {
    private static final int TEST_LENGTH = 16384;
    private static final String TEST_CHAR = "A";
    private static String staticLongStringA = null;
    private static String staticLongFormatString = null;
    private static String[] PARAM_LIST;
    private static Pattern patternOverflow;

    static {
        StringBuffer sb = new StringBuffer(16384);
        int i = 0;
        while (sb.length() < 16384) {
            sb.append(TEST_CHAR);
            ++i;
        }
        staticLongStringA = sb.toString();
        sb.setLength(0);
        i = 0;
        while (sb.length() < 8192) {
            sb.append("%25x%25n");
            ++i;
        }
        staticLongFormatString = sb.toString();
        PARAM_LIST = new String[]{staticLongStringA, staticLongFormatString};
        patternOverflow = Pattern.compile("A{8192,16384}", 42);
    }

    TestBufferOverflow() {
    }

    public String toString() {
        return "TestBufferOverflow";
    }

    public String getTestName() {
        return "Long input and buffer overflow";
    }

    protected void check(boolean isBody, String paramKey, String paramValue, String query, int insertPos) throws IOException {
        String bingoQuery = null;
        String displayURI = null;
        String newQuery = null;
        boolean isError = false;
        String resBodyNormal = null;
        boolean pos = false;
        long defaultTimeUsed = 0L;
        long timeUsed = 0L;
        long lastTime = 0L;
        newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue);
        this.createMessage(isBody, newQuery);
        lastTime = System.currentTimeMillis();
        this.sendAndReceive();
        defaultTimeUsed = System.currentTimeMillis() - lastTime;
        if (this.getResponseHeader().getStatusCode() != 200) {
            return;
        }
        resBodyNormal = this.getResponseBody().toString();
        int i = 0;
        while (i < PARAM_LIST.length) {
            bingoQuery = i == 0 ? this.insertQuery(query, insertPos, "") : this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + PARAM_LIST[i]);
            this.createMessage(isBody, bingoQuery);
            lastTime = System.currentTimeMillis();
            try {
                this.sendAndReceive();
            }
            catch (SocketException e) {
                isError = true;
            }
            catch (EOFException e) {
                isError = true;
            }
            catch (IOException e) {
                throw e;
            }
            defaultTimeUsed = System.currentTimeMillis() - lastTime;
            displayURI = this.getRequestHeader().getURIHostPathQuery();
            if (isError) {
                this.bingo(30001, 3, 1, "", paramKey, "");
                return;
            }
            if (this.checkResult(bingoQuery, resBodyNormal)) {
                return;
            }
            ++i;
        }
    }

    private boolean checkResult(String paramKey, String normalHTTPResponse) {
        if (this.getResponseHeader().getStatusCode() != 200 && !HttpStatusCode.isServerError(this.getResponseHeader().getStatusCode())) {
            return false;
        }
        if (this.getResponseBody().toString().equals(normalHTTPResponse)) {
            return false;
        }
        Matcher matcher = patternOverflow.matcher(this.getResponseHeader().toString());
        if (matcher.find()) {
            this.bingo(30000, 2, 2, "", paramKey, "");
            return true;
        }
        return false;
    }

    protected void scan() throws Exception {
        boolean skip = this.getEntity().mState == 1;
        this.writeStatus(String.valueOf(this.getTestName()) + ": " + (skip ? "(skipped) " : "") + this.getRequestHeader().getURIHostPath());
        if (skip) {
            return;
        }
        this.init();
        this.checkUrlOrBody(false, this.myQuery);
        this.checkUrlOrBody(true, this.myReqBody.toString());
    }
}

