/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.scan.AbstractAppTest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TestCacheAndMisc
extends AbstractAppTest {
    private static final Pattern patternNoCache = Pattern.compile("\\QNo-cache\\E|\\QNo-store\\E", 42);
    private static final Pattern patternHtmlNoCache = Pattern.compile("<META[^>]+(Pragma|\\QCache-Control\\E)[^>]+(\\QNo-cache\\E|\\QNo-store\\E)[^>]*>", 42);
    private static final Pattern patternAutocomplete = Pattern.compile("AUTOCOMPLETE\\s*=[^>]*OFF[^>]*", 42);
    private static final Pattern patternForm = Pattern.compile("(<FORM\\s*[^>]+\\s*>).*?(<INPUT\\s*[^>]+PASSWORD[^>]+\\s*>).*?</FORM>", 42);
    private static final Pattern patternPrivateIP = Pattern.compile("(10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3})", 42);
    private static final String[] platforms = new String[]{"Microsoft", "Windows ?\\d{4,4}", "Windows ?XP", "BeOS", "Redhat", "SUSE", "Mandrake", "Mandrakesoft", "Slackware", "BSD Unix", "FreeBSD", "HP-?UX", "Solaris", "AIX", "MVS", "OS.?390", "MacOS", "Debian", "RedFlag", "Internet information server", "IIS ?\\d?", "Apache", "Stronghold", "Netscape enterprise", "iplanet", "Lotus Domino", "Domino", "IBM HTTP", "webstar", "rapidsite", "thttpd", "websitepro", "Tomcat", "ATG Dynamo", "WebLogic", "Borland", "Fujisu Interstage", "Cosminexus", "Websphere", "Orbix E2A", "Macromedia", "Jrun", "WebOTX", "Novell exteNd", "Pramati server", "Pramati studio", "Oracle ?\\di", "SAS AppDev", "SeeBeyond ICAN", "SpiritSoft", "Sun ?ONE", "Sybase", "EAServer", "Tmax Soft JEUS", "Trifork Application", "Internet information server", "IIS", "Apache", "Lotus Domino", "Domino", "IBM HTTP server", "ColdFusion", "Frontpage", "Visual ?Basic", "Visual ?C", "dreamweaver", "VisualAge", "netbean", "perl", "php", "python", "powerbuilder", "Load runner", "JDeveloper", "JProbe", "PerformaSure", "Jbuilder", "Introscope", "OptimizeIT", "proxy server", "reverse proxy", "squid", "Microsoft SQL", "MS ?SQL", "Oracle", "Mysql", "msql", "foxbase", "sybase", "postgre ?sql", "powerbase", "Cyberguard firewall", "Altavista firewall", "Ascend firewall", "Cisco PIX", "Eagle NT", "Elron firewall", "Check\\s*point", "Firewall-1", "Network-1 firewall", "GFX firewall", "GNAT box firewall", "NetGuardian", "Milkyway SecurIT", "Sonic firewall", "sonicwall", "Kane security analyst", "NetRoad firewall", "session wall-3", "SUNScreen", "watchguard", "Nokia +\\d+", "Alteon", "Guardian firewall", "NetScreen"};
    private static Pattern patternComment = Pattern.compile("<!--\\s*?(.*?)\\s*?-->");
    private static Pattern patternPlatforms = null;
    private static Pattern staticSessionIDPHP1;
    private static Pattern staticSessionIDPHP2;
    private static Pattern staticSessionIDJava;
    private static Pattern staticSessionIDASP;
    private static Pattern staticSessionIDColdFusion;
    private static Pattern staticSessionIDApache;
    private static Pattern staticSessionIDJW;
    private static Pattern[] staticSessionIDList;
    private static final String paramHostHttp = "http://([\\w\\.\\-_]+)";
    private static final String paramHostHttps = "https://([\\w\\.\\-_]+)";
    private static final Pattern[] staticLinkCheck;

    static {
        StringBuffer sb = new StringBuffer();
        sb.append("\\b(");
        int i = 0;
        while (i < platforms.length) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(platforms[i]);
            ++i;
        }
        sb.append(")\\s+");
        patternPlatforms = Pattern.compile(sb.toString(), 42);
        staticSessionIDPHP1 = Pattern.compile("PHPSESSION=\\w+", 42);
        staticSessionIDPHP2 = Pattern.compile("PHPSESSID=\\w+", 42);
        staticSessionIDJava = Pattern.compile("JSESSIONID=\\w+", 42);
        staticSessionIDASP = Pattern.compile("ASPSESSIONID=\\w+", 42);
        staticSessionIDColdFusion = Pattern.compile("CFTOKEN=\\w+", 42);
        staticSessionIDApache = Pattern.compile("SESSIONID=\\w+", 42);
        staticSessionIDJW = Pattern.compile("JWSESSIONID=\\w+", 42);
        staticSessionIDList = new Pattern[]{staticSessionIDPHP1, staticSessionIDPHP2, staticSessionIDJava, staticSessionIDColdFusion, staticSessionIDASP, staticSessionIDApache, staticSessionIDJW};
        staticLinkCheck = new Pattern[]{Pattern.compile("src\\s*=\\s*\"?http://([\\w\\.\\-_]+)", 42), Pattern.compile("href\\s*=\\s*\"?http://([\\w\\.\\-_]+)", 42), Pattern.compile("src\\s*=\\s*\"?https://([\\w\\.\\-_]+)", 42), Pattern.compile("href\\s*=\\s*\"?https://([\\w\\.\\-_]+)", 42)};
    }

    TestCacheAndMisc() {
    }

    public String toString() {
        return "TestCacheAndMisc";
    }

    public String getTestName() {
        return "Browser Cache and Miscellaneous";
    }

    private void buildHeader() {
    }

    protected void scan() throws Exception {
        this.buildHeader();
        this.writeStatus("BrowserCacheAndMisc: " + this.getRequestHeader().getURIHostPath());
        this.sendAndReceive();
        if (this.getResponseHeader().getStatusCode() != 200) {
            return;
        }
        this.runChecks();
    }

    private void runChecks() {
        this.checkBrowserCache();
        this.checkFormAutocomplete();
        this.checkPrivateIPDisclosure();
        this.checkComment();
        this.checkServerHeader();
        this.checkSetCookie();
        this.checkSessionIDGET();
    }

    protected void scanOffline() throws Exception {
        if (this.getResponseHeader().getStatusCode() != 200) {
            return;
        }
        this.runChecks();
    }

    private void checkBrowserCache() {
        boolean result = false;
        if (!this.getRequestHeader().getSecure()) {
            return;
        }
        if (this.getRequestHeader().isImage()) {
            return;
        }
        if (this.getResponseBody().length() == 0) {
            return;
        }
        if (!(this.matchHeaderPattern("Cache-control", patternNoCache) || this.matchHeaderPattern("Pragma", patternNoCache) || this.matchBodyPattern(patternHtmlNoCache, null))) {
            result = true;
        }
        if (result) {
            this.bingo(10003, 2, 2, "", "", "");
        }
    }

    private void checkFormAutocomplete() {
        String txtBody = this.getResponseBody().toString();
        String txtForm = null;
        String txtInput = null;
        Matcher matcherForm = patternForm.matcher(txtBody);
        Matcher matcherAutocomplete = null;
        boolean result = false;
        while (matcherForm.find()) {
            txtForm = matcherForm.group(1);
            txtInput = matcherForm.group(2);
            if (txtForm == null || txtInput == null || (matcherAutocomplete = patternAutocomplete.matcher(txtForm)).find() || (matcherAutocomplete = patternAutocomplete.matcher(txtInput)).find()) continue;
            this.bingo(10004, 2, 2, "", "", txtInput);
        }
    }

    private void checkPrivateIPDisclosure() {
        String txtBody = this.getResponseBody().toString();
        String txtFound = null;
        Matcher matcher = patternPrivateIP.matcher(txtBody);
        while (matcher.find()) {
            txtFound = matcher.group();
            if (txtFound == null) continue;
            this.bingo(10005, 1, 2, "", "", txtFound);
        }
    }

    private void checkComment() {
        Matcher commentMatcher = null;
        Matcher matcher = null;
        String txtBody = this.getResponseBody().toString();
        String txtComment = null;
        String txtFound = null;
        commentMatcher = patternComment.matcher(txtBody);
        while (commentMatcher.find()) {
            txtComment = commentMatcher.group(1);
            matcher = patternPlatforms.matcher(txtComment);
            while (matcher.find()) {
                txtFound = matcher.group(1);
                this.bingo(10006, 0, 0, "", "", txtFound);
            }
        }
    }

    private void checkServerHeader() {
        String serverHeader = this.getResponseHeader().getHeader("SERVER");
        this.bingo(10010, 0, 0, "", "", serverHeader);
    }

    private void checkSetCookie() {
        String setCookieHeader = this.getResponseHeader().getHeader("SET-COOKIE");
        if (setCookieHeader == null || setCookieHeader.length() == 0) {
            setCookieHeader = this.getResponseHeader().getHeader("SET-COOKIE2");
        }
        if (setCookieHeader == null || setCookieHeader.length() == 0) {
            return;
        }
        this.bingo(10011, 0, 0, "", "", setCookieHeader);
    }

    private void checkSessionIDGET() {
        String uri = this.getRequestHeader().getURIPathQuery();
        Matcher matcher = null;
        String sessionID = null;
        int i = 0;
        while (i < staticSessionIDList.length) {
            matcher = staticSessionIDList[i].matcher(uri);
            if (matcher.find()) {
                sessionID = matcher.group(0);
                this.bingo(10012, 1, 2, "", "", sessionID);
                this.checkSessionIDExposure();
                break;
            }
            ++i;
        }
    }

    private void checkSessionIDExposure() {
        String body = this.getResponseBody().toString();
        int risk = this.getRequestHeader().getSecure() ? 2 : 0;
        String linkHostName = null;
        Matcher matcher = null;
        int i = 0;
        while (i < staticLinkCheck.length) {
            matcher = staticLinkCheck[i].matcher(body);
            while (matcher.find()) {
                linkHostName = matcher.group(1);
                if (this.getRequestHeader().getHostName().compareToIgnoreCase(linkHostName) == 0) continue;
                this.bingo(10013, risk, 2, "", "", linkHostName);
            }
            ++i;
        }
    }
}

