/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.scan.AbstractAppTest;
import java.net.URI;
import java.util.regex.Pattern;

class TestDirBrowse
extends AbstractAppTest {
    private static final Pattern patternIIS = Pattern.compile("Parent Directory", 42);
    private static final Pattern patternApache = Pattern.compile("\\bDirectory Listing\\b.*(Tomcat|Apache)", 42);
    private static final Pattern patternGeneralDir1 = Pattern.compile("\\bDirectory\\b", 42);
    private static final Pattern patternGeneralDir2 = Pattern.compile("[\\s<]+IMG\\s*=", 42);
    private static final Pattern patternGeneralParent = Pattern.compile("Parent directory", 42);

    TestDirBrowse() {
    }

    public String toString() {
        return "TestDirBrowse";
    }

    public String getTestName() {
        return "Directory Browsing";
    }

    private void buildHeader() {
        URI uri = this.getEntity().getURIHostPath();
        String sUri = uri.toString();
        if (!sUri.endsWith("/")) {
            sUri = String.valueOf(sUri) + "/";
        }
        this.getRequestHeader().setURI(sUri);
    }

    protected void scan() throws Exception {
        boolean result = false;
        this.buildHeader();
        this.writeStatus("DirBrowse: " + this.getRequestHeader().getURIHostPath());
        this.sendAndReceive();
        if (this.getResponseHeader().getStatusCode() != 200) {
            return;
        }
        Object matcher = null;
        int reliability = 2;
        if (this.matchBodyPattern(patternIIS, null)) {
            result = true;
        } else if (this.matchBodyPattern(patternApache, null)) {
            result = true;
        } else if (this.matchBodyPattern(patternGeneralParent, null)) {
            result = true;
            reliability = 1;
        } else if (this.matchBodyPattern(patternGeneralDir1, null) && this.matchBodyPattern(patternGeneralDir2, null)) {
            result = true;
            reliability = 1;
        }
        if (result) {
            this.bingo(10001, 2, reliability, "", "", "");
        }
    }
}

