/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.scan.AbstractServerTest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

class TestURL
extends AbstractServerTest {
    private URI mUri = null;
    private static final Pattern patternNotFound = Pattern.compile("(\\bNot\\sfound\\b)|(\\b404\\b)", 42);
    private int mAlertID = 0;

    public TestURL(int id) {
        this.mAlertID = id;
    }

    public String getTestName() {
        return "URL";
    }

    protected void scan() throws Exception {
        this.testFile();
    }

    protected void init(String dir, String file) throws URISyntaxException {
        URI oldUri = this.getEntity().getURIHostPath();
        if (!dir.startsWith("/")) {
            dir = "/" + dir;
        }
        if (!file.startsWith("/") && !dir.endsWith("/")) {
            file = "/" + file;
        }
        String path = String.valueOf(dir) + file;
        this.mUri = new URI(oldUri.getScheme(), null, oldUri.getHost(), oldUri.getPort(), path, null, null);
    }

    protected void testFile() throws URISyntaxException, IOException {
        this.getRequestHeader().setURI(this.mUri.toString());
        this.writeStatus("DefaultFile: " + this.getRequestHeader().getURIHostPath());
        this.sendAndReceive();
        if (!this.isFileExist(this.getEntity(), this.getRequestHeader(), this.getResponseHeader(), this.getResponseBody())) {
            return;
        }
        this.bingo(this.mAlertID, 2, 2, this.mUri.toString(), "", "");
    }
}

