/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.spider;

import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.spider.HeaderProperty;
import com.proofsecure.paros.spider.UrlStack;
import com.proofsecure.paros.spider.Website;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class Spider
extends Thread {
    static int SPIDER_THREAD_COUNT = 6;
    protected Thread myThread = null;
    protected boolean isStarted = false;
    protected Website mSite = null;
    protected URL startURL = null;
    protected boolean isStop = false;
    protected String mHost = "";
    protected int mPort = 80;
    protected boolean mSecureFlag = false;
    protected HTMLEditorKit htmlKit = new HTMLEditorKit();
    protected HTMLDocument htmlDoc;
    protected URLConnection conn = null;
    protected HttpURLConnection hconn = null;
    protected HttpRequestHeader reqHeader = null;
    protected SSLContext sc;
    protected String cookie = null;
    protected Vector headerProperty = new Vector();
    protected UrlStack links = new UrlStack();
    protected static final String USAGE = "java paros.spider.Spider URL [proxy_name:proxy_port]\r\ne.g. java paros.spider.Spider http://localhost:8080/ \r\n      java paros.spider.Spider http://localhost:8080/ proxy.abc.com:8080\r\n ";

    public boolean init() {
        return true;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println(USAGE);
            return;
        }
        if (args.length == 2 && args[1].indexOf(":") == -1) {
            System.out.println(USAGE);
            return;
        }
        Spider s = new Spider();
        URL url = new URL(args[0]);
        if (url.getFile().equals("")) {
            url = new URL(String.valueOf(url.toString()) + "/");
        }
        s.setStartURL(url);
        if (args.length == 2) {
            String[] proxyArg = args[1].split(":");
            s.setProxy(proxyArg[0], proxyArg[1]);
        }
        s.start();
    }

    public void setSecure(boolean s) {
        this.mSecureFlag = s;
    }

    public void setStartURL(URL url) {
        this.startURL = url;
        this.mSite = new Website(url.toString());
        String proto = url.getProtocol();
        if (!proto.equalsIgnoreCase("http") && !proto.equalsIgnoreCase("https")) {
            System.out.println(USAGE);
            return;
        }
        if (proto.equalsIgnoreCase("https")) {
            this.setSecure(true);
        }
        if (url.getPort() == -1) {
            if (!this.mSecureFlag) {
                this.setPort(80);
            } else {
                this.setPort(443);
            }
        } else {
            this.setPort(url.getPort());
        }
        this.setHost(url.getHost());
        String path = url.getFile();
        if (!path.endsWith("/")) {
            path = path.substring(0, path.lastIndexOf("/") + 1);
        }
        this.setRoot(path);
    }

    public void setStop() {
        this.isStop = true;
    }

    public void setHost(String h) {
        this.mHost = h;
    }

    public void setPort(int p) {
        this.mPort = p;
    }

    public void setRoot(String s) {
        this.links.setRoot(s);
    }

    public void setProxy(String proxyhost, String proxyport) {
        System.getProperties().setProperty("https.proxyHost", proxyhost);
        System.getProperties().setProperty("https.proxyPort", proxyport);
        System.getProperties().setProperty("http.proxyHost", proxyhost);
        System.getProperties().setProperty("http.proxyPort", proxyport);
    }

    public void startCrawl() {
        if (this.isStarted) {
            return;
        }
        this.myThread = new Thread(this);
        this.myThread.setDaemon(true);
        this.myThread.start();
        this.isStarted = true;
    }

    public void run() {
        Date a = new Date();
        if (this.startURL == null) {
            return;
        }
        if (this.mSecureFlag) {
            this.initSecureConnection();
        }
        try {
            while (this.links.size() > 0 & !this.isStop) {
                String url = (String)this.links.pop();
                Vector res = this.sendAndReceive(url);
                if (res == null || res.size() <= 0) continue;
                this.links.push(res);
            }
        }
        catch (EmptyStackException es) {
            this.logError(es.getMessage());
        }
        catch (Exception ex) {
            this.logError(ex.getMessage());
        }
        this.wrapup();
    }

    protected void addHeaderProperty(HeaderProperty h) {
        this.headerProperty.add(h);
    }

    protected void setHeaderProperty(URLConnection conn, HttpRequestHeader req) {
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestProperty("Accept-Language", "en-us");
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows 98)");
        req.setHeader("Accept", "*/*");
        req.setHeader("Accept-Language", "en-us");
        req.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows 98)");
        if (this.cookie != null) {
            conn.setRequestProperty("Cookie", this.cookie);
            req.setHeader("Cookie", this.cookie);
        }
        if (this.headerProperty != null && this.headerProperty.size() > 0) {
            Enumeration e = this.headerProperty.elements();
            while (e.hasMoreElements()) {
                HeaderProperty hp = (HeaderProperty)e.nextElement();
                conn.setRequestProperty(hp.name, hp.value);
                req.setHeader(hp.name, hp.value);
            }
        }
    }

    protected void wrapup() {
        this.logError("History size: " + this.mSite.getHistory().size());
        if (this.hconn != null) {
            this.hconn.disconnect();
        }
        this.logError("\r\nTotal " + this.links.getUrlDone().size() + " link(s) crawled.\r\n");
        this.logError(this.links.listUrlRejected());
        this.isStarted = false;
    }

    protected void checkHeader(URLConnection conn) {
        int i = 0;
        while (true) {
            String headerName = conn.getHeaderFieldKey(i);
            String headerValue = conn.getHeaderField(i);
            if (headerName == null && headerValue == null) break;
            if (headerName != null && headerName.equalsIgnoreCase("Set-cookie")) {
                this.cookie = this.cookie == null ? headerValue.substring(0, headerValue.indexOf(";")) : String.valueOf(this.cookie) + "; " + headerValue.substring(0, headerValue.indexOf(";"));
            }
            ++i;
        }
    }

    protected void log(URL ur, HttpRequestHeader reqHeader) throws Exception {
    }

    private Vector sendAndReceive(String url) {
        block12: {
            String respCode = null;
            try {
                int code;
                URI aur = new URI(url);
                if (!aur.isAbsolute()) {
                    aur = new URI(this.startURL.toExternalForm()).resolve(aur);
                }
                URL ur = aur.toURL();
                this.conn = ur.openConnection();
                this.hconn = (HttpURLConnection)this.conn;
                if (this.conn instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)this.hconn).setHostnameVerifier(new HostnameVerifier(){

                        public boolean verify(String urlHost, SSLSession ssls) {
                            return true;
                        }
                    });
                    ((HttpsURLConnection)this.hconn).setSSLSocketFactory(this.sc.getSocketFactory());
                }
                HttpURLConnection.setFollowRedirects(false);
                this.hconn.setInstanceFollowRedirects(false);
                this.reqHeader = new HttpRequestHeader();
                this.reqHeader.setMessage("GET " + ur.toString() + " HTTP/1.0\r\nConnection:\r\nContent-length: 0\r\n\r\n");
                this.reqHeader.setSecure(this.mSecureFlag);
                this.setHeaderProperty(this.hconn, this.reqHeader);
                this.hconn.connect();
                if (this.conn.getHeaderField(0) != null) {
                    respCode = this.conn.getHeaderField(0);
                }
                if ((code = this.hconn.getResponseCode()) == 301 || code == 302) {
                    Vector<String> v = new Vector<String>();
                    v.add(this.hconn.getHeaderField("Location"));
                    Vector v2 = this.checkUriPrefix(v, aur.toString(), true);
                    return v2;
                }
                if (code >= 200 & code < 300) {
                    this.log(ur, this.reqHeader);
                }
                this.checkHeader(this.conn);
                if (this.hconn.getContentType() != null && this.hconn.getContentType().toLowerCase().indexOf("text") == -1 && this.hconn.getContentType().toLowerCase().indexOf("html") == -1) {
                    return null;
                }
                Object instream = this.hconn.getContent();
                if (instream == null) {
                    return null;
                }
                if (instream != null && instream instanceof InputStream) {
                    int BUFFER_SIZE = 4096;
                    Vector v = this.getContent2((InputStream)instream);
                    Vector v2 = null;
                    if (v != null && v.size() > 0) {
                        v2 = this.checkUriPrefix(v, aur.toString(), false);
                    }
                    return v2;
                }
            }
            catch (Exception fn1) {
                this.logError(fn1.getMessage());
                if (fn1 instanceof FileNotFoundException) {
                    this.links.pushUrlRejected(String.valueOf(url) + " (rejected with reply \"" + respCode + "\")");
                }
                if (!(fn1 instanceof IOException)) break block12;
                this.links.pushUrlRejected(String.valueOf(url) + " (rejected with reply \"" + respCode + "\")");
            }
        }
        return null;
    }

    public void logError(String s) {
        System.out.println(s);
    }

    private Vector getLinks(String s, String pattern) {
        int i;
        Vector<String> v = new Vector<String>();
        int base = 0;
        int plen = pattern.length();
        String abody = s.toUpperCase();
        while ((i = abody.indexOf(pattern)) != -1) {
            String tUrl;
            int j;
            if (abody.charAt(i + plen) == '\"' && (j = abody.indexOf("\"", i + plen + 1)) != -1) {
                tUrl = s.substring(base + i + plen + 1, base + j);
                v.add(tUrl);
                abody = abody.substring(j);
                base += j;
                continue;
            }
            int a = abody.indexOf(" ", i + plen + 1);
            int b = abody.indexOf(">", i + plen + 1);
            if (a == -1 && b == -1) break;
            j = a != -1 ? (b == -1 || a < b ? a : b) : b;
            tUrl = s.substring(base + i + plen, base + j);
            v.add(tUrl);
            abody = abody.substring(j);
            base += j;
        }
        if (v.size() == 0) {
            v = null;
        }
        return v;
    }

    private String getContent(BufferedInputStream in) {
        int len = 0;
        byte[] buf = new byte[1024];
        StringBuffer body = new StringBuffer();
        try {
            while (len >= 0) {
                len = in.read(buf);
                if (len <= 0) break;
                String temp = null;
                try {
                    temp = new String(buf, 0, len, "8859_1");
                }
                catch (Exception e) {
                    temp = new String(buf, 0, len);
                }
                body.append(temp);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return body.toString();
    }

    public Vector getContent2(InputStream in) {
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(isr);
        Vector<Object> res = new Vector<Object>();
        this.htmlDoc = (HTMLDocument)this.htmlKit.createDefaultDocument();
        this.htmlDoc.putProperty("IgnoreCharsetDirective", new Boolean(true));
        try {
            this.htmlKit.read(br, (Document)this.htmlDoc, 0);
            HTMLDocument.Iterator iterator = this.htmlDoc.getIterator(HTML.Tag.A);
            while (iterator.isValid()) {
                AttributeSet as = iterator.getAttributes();
                if (as != null && as.getAttribute(HTML.Attribute.HREF) != null) {
                    res.add(as.getAttribute(HTML.Attribute.HREF));
                }
                iterator.next();
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        catch (BadLocationException ie) {
            ie.printStackTrace();
        }
        if (res.size() == 0) {
            return null;
        }
        return res;
    }

    protected Vector checkUriPrefix(Vector v, String uri, boolean isRedirect) throws URISyntaxException {
        Vector res = this.mSite.resolveURI(v, Website.StringtoURI(uri));
        this.links.pushUrlRejected(this.mSite.getOtherLink());
        this.mSite.clearOtherLink();
        return res;
    }

    protected Vector checkUriPrefix2(Vector v, String uri, boolean isRedirect) {
        Vector<String> result = new Vector<String>();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String t1 = (String)e.nextElement();
            if (t1 == null) {
                this.list(v);
                break;
            }
            String t = t1.toLowerCase();
            if (t.startsWith("mailto:") || t.startsWith("ftp:") || t.startsWith("irc:") || t.startsWith("news:") || t.startsWith("gopher:") || t.startsWith("file:") || t.startsWith("nfs:")) continue;
            if (t.startsWith("http://") || t.startsWith("https://")) {
                String a;
                int i = 0;
                int plen = t.startsWith("http://") ? 7 : 8;
                i = t.substring(plen).indexOf(":");
                if (i != -1) {
                    int j;
                    a = t.substring(plen, plen + i);
                    if (!this.compareAddress(a, this.mHost) || (j = t.substring(i + 1).indexOf("/")) == -1) continue;
                    String p1 = t.substring(i + plen + 1, i + j + 1);
                    int p = -1;
                    try {
                        p = Integer.parseInt(p1);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    if (p == -1 || p != this.mPort) continue;
                    result.add(t1.substring(i + j + 1));
                    continue;
                }
                i = t.substring(plen).indexOf("/");
                if (i == -1 || !this.compareAddress(a = t.substring(plen, plen + i), this.mHost)) continue;
                if (this.mSecureFlag && this.mPort == 443 || !this.mSecureFlag && this.mPort == 80) {
                    result.add(t1.substring(plen + i));
                    continue;
                }
                this.links.pushUrlRejected(String.valueOf(t1) + ":" + this.mPort + " (port different from that of spider)");
                continue;
            }
            if (isRedirect) continue;
            if (t.startsWith("/")) {
                result.add(t1);
                continue;
            }
            int q = uri.lastIndexOf("/");
            if (q == -1) continue;
            if (q == 0) {
                result.add("/" + t1);
                continue;
            }
            result.add(String.valueOf(uri.substring(0, q)) + "/" + t1);
        }
        return result;
    }

    protected boolean compareAddress(String a, String b) {
        try {
            return InetAddress.getByName(a).equals(InetAddress.getByName(b));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void list(Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            System.out.println("list: " + (String)e.nextElement());
        }
    }

    public void initSecureConnection() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public boolean checkClientTrusted(X509Certificate[] chain) {
                return true;
            }

            public boolean isServerTrusted(X509Certificate[] chain) {
                return true;
            }

            public boolean isClientTrusted(X509Certificate[] chain) {
                return true;
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            this.sc = SSLContext.getInstance("SSL");
            SecureRandom x = new SecureRandom();
            this.sc.init(null, trustAllCerts, x);
            HttpsURLConnection.setDefaultSSLSocketFactory(this.sc.getSocketFactory());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void connectS(String hostName, int hostPort) {
        int port = hostPort;
        long lastTime = System.currentTimeMillis();
        try {
            String hostname = hostName;
            SSLSocketFactory factory = HttpsURLConnection.getDefaultSSLSocketFactory();
            SSLSocket socket = (SSLSocket)factory.createSocket(hostname, port);
            socket.setSoTimeout(500);
            socket.startHandshake();
            Certificate[] serverCerts = socket.getSession().getPeerCertificates();
            socket.close();
        }
        catch (SSLPeerUnverifiedException e) {
            System.out.println(String.valueOf(port) + " " + e.getMessage());
            System.out.println(System.currentTimeMillis() - lastTime);
            return;
        }
        catch (IOException e) {
            System.out.println(String.valueOf(port) + " IOException: " + e.getMessage());
            System.out.println(System.currentTimeMillis() - lastTime);
            return;
        }
        System.out.println(String.valueOf(port) + " is https port");
        System.out.println(System.currentTimeMillis() - lastTime);
    }
}

