/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.ui;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.Proxy;
import com.proofsecure.paros.SSLProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class OptionPanel
extends JPanel {
    public static final String FILE_OPTION = "options.xml";
    private JTextArea textArea = new JTextArea();
    private JButton loadButton = new JButton();
    private JButton saveButton = new JButton();
    private JScrollPane textScrollPane = new JScrollPane();
    private JScrollPane btntScrollPane = new JScrollPane();
    private Box buttons;

    public OptionPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.textArea.setMargin(new Insets(2, 4, 2, 4));
        this.buttons = Box.createHorizontalBox();
        this.buttons.add((Component)this.loadButton, null);
        this.buttons.add((Component)this.saveButton, null);
        this.add((Component)this.textScrollPane, "Center");
        this.add((Component)this.btntScrollPane, "South");
        this.btntScrollPane.setVerticalScrollBarPolicy(21);
        this.btntScrollPane.setHorizontalScrollBarPolicy(31);
        this.btntScrollPane.getViewport().add((Component)this.buttons, null);
        this.textScrollPane.getViewport().add((Component)this.textArea, null);
        this.loadButton.setText("Load");
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionPanel.this.readConfig();
            }
        });
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionPanel.this.saveConfig();
            }
        });
        this.readConfig();
    }

    void saveConfig() {
        try {
            int answer;
            File selFile = new File(FILE_OPTION);
            if (selFile.exists() && (answer = JOptionPane.showConfirmDialog(this, "File exists. Overwrite it?", "Warning", 0)) != 0) {
                return;
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(selFile));
            out.write(this.textArea.getText());
            out.close();
            JOptionPane.showMessageDialog(this, "Options saved.");
        }
        catch (IOException ae) {
            JOptionPane.showMessageDialog(this, "File write error!");
        }
        this.readConfig();
    }

    void readConfig() {
        try {
            String str;
            File selFile = new File(FILE_OPTION);
            if (!selFile.exists()) {
                JOptionPane.showMessageDialog(this, "options.xml not found.");
                return;
            }
            BufferedReader in = new BufferedReader(new FileReader(selFile));
            String allstr = "";
            while ((str = in.readLine()) != null) {
                allstr = String.valueOf(allstr) + str + "\r\n";
            }
            in.close();
            this.textArea.setText(allstr);
            this.textScrollPane.getVerticalScrollBar().setValue(this.textScrollPane.getVerticalScrollBar().getMinimum());
            Global.config.read(FILE_OPTION);
            if (Global.proxy != null) {
                Global.proxy.stopServer();
                Global.SSLProxy.stopServer();
                Global.proxy = new Proxy(Global.config.getProxyIP(), Global.config.getProxyPort());
                Global.SSLProxy = new SSLProxy(Global.config.getProxyIP(), Global.config.getProxyPortSSL());
                Global.proxy.startServer();
                Global.SSLProxy.startServer();
            }
        }
        catch (Exception ae) {
            JOptionPane.showMessageDialog(this, "Incompatible file format or file corrupted.");
        }
    }
}

