/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.ui;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.document.WebDoc;
import com.proofsecure.paros.document.WebLink;
import com.proofsecure.paros.log.DumpResponsePanel;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.ui.FunctionPanel;
import com.proofsecure.paros.ui.OptionPanel;
import com.proofsecure.paros.ui.ParosMenu;
import com.proofsecure.paros.ui.ParosTabbedPane;
import com.proofsecure.paros.ui.TrapPanel;
import com.proofsecure.paros.ui.TreePanel;
import com.proofsecure.paros.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ParosFrame
extends JFrame
implements ComponentListener {
    public static final String OUTPUT_LOG = "Output";
    public static final String ERROR_LOG = "Errors";
    public static final String COOKIE_LOG = "Cookies";
    public static final String URL_LOG = "URLs";
    public static final String REQUEST_LOG = "Requests";
    public static final String RESPONSE_LOG = "Responses";
    public static final String TRAP_PANEL = "Trap";
    public static final String OPTION_PANEL = "Options";
    public static final String FILTER_PANEL = "Filters";
    public static final String SCAN_PANEL = "Scan";
    public static final String LOG_PANE = "LogPane";
    public static final String RIGHT_PANE = "RightPane";
    private static final int LOG_PANE_HEIGHT = 200;
    private static final int FRAME_HEIGHT = 480;
    private JList urlList = null;
    private JPanel contentPane;
    public ParosMenu menubar = new ParosMenu(this);
    private JToolBar jToolBar = new JToolBar();
    private JButton jButton1 = new JButton();
    private JButton jButton2 = new JButton();
    private JButton jButton3 = new JButton();
    private ImageIcon image1;
    private ImageIcon image2;
    private ImageIcon image3;
    private Border border3;
    private JSplitPane jSplitPane1 = new JSplitPane();
    private JSplitPane jSplitPane2 = new JSplitPane();
    private JLabel statusBar = new JLabel();
    private ParosTabbedPane rightTabPane = new ParosTabbedPane();
    private ParosTabbedPane logPane = new ParosTabbedPane();
    private TreePanel treePanel = Global.treePanel;
    private TrapPanel trapPanel = Global.trapPanel;
    private DumpResponsePanel responsePanel = new DumpResponsePanel();
    private DumpResponsePanel requestPanel = new DumpResponsePanel();
    private int old_frame_height = 480;
    private static Object sem = new Object();
    private WebDoc webDoc = Global.webDoc;

    public ParosFrame() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ParosMenu getParosMenu() {
        return this.menubar;
    }

    private void jbInit() throws Exception {
        this.image1 = new ImageIcon("openFile.gif");
        this.image2 = new ImageIcon("closeFile.gif");
        this.image3 = new ImageIcon("help.gif");
        this.setIconImage(Toolkit.getDefaultToolkit().createImage("paros_logo.gif"));
        this.contentPane = (JPanel)this.getContentPane();
        this.border3 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.contentPane.setLayout(new BorderLayout());
        this.setSize(new Dimension(640, 480));
        this.setTitle("Paros 3.1.1 ");
        this.setJMenuBar(this.menubar);
        this.jButton1.setIcon(this.image1);
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton1.setBorder(this.border3);
        this.jButton1.setToolTipText("Open File");
        this.jButton1.setBorderPainted(false);
        this.jButton2.setIcon(this.image2);
        this.jButton2.setMargin(new Insets(2, 2, 2, 2));
        this.jButton2.setBorder(this.border3);
        this.jButton2.setToolTipText("Close File");
        this.jButton2.setBorderPainted(false);
        this.jButton3.setIcon(this.image3);
        this.jButton3.setMargin(new Insets(2, 2, 2, 2));
        this.jButton3.setBorder(this.border3);
        this.jButton3.setToolTipText("Help");
        this.jButton3.setBorderPainted(false);
        this.jToolBar.setEnabled(false);
        this.jToolBar.add(this.jButton1);
        this.jToolBar.add(this.jButton2);
        this.jToolBar.add(this.jButton3);
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBar.setDisplayedMnemonic('0');
        this.statusBar.setText(" ");
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jSplitPane1.setDividerSize(3);
        this.jSplitPane2.setBorder(BorderFactory.createEtchedBorder());
        this.jSplitPane2.setDividerSize(3);
        this.jSplitPane1.add((Component)this.jSplitPane2, "top");
        this.jSplitPane2.add((Component)this.treePanel, "top");
        this.jSplitPane2.add((Component)this.rightTabPane, "right");
        this.logPane.setTabPlacement(3);
        this.urlList = this.logPane.addListPanel(URL_LOG);
        this.urlList.setModel(Global.urlLog);
        this.logPane.addLogPanel(OUTPUT_LOG);
        this.logPane.addLogPanel(COOKIE_LOG);
        this.logAppend(COOKIE_LOG, "Accepted cookie will be shown here if LogCookie is enabled.\r\n");
        if (!Global.isDumpLog) {
            this.logPane.addLogPanel(REQUEST_LOG);
            this.logPane.addLogPanel(RESPONSE_LOG);
        }
        this.jSplitPane1.add((Component)this.logPane, "bottom");
        this.rightTabPane.add((Component)this.requestPanel, REQUEST_LOG);
        this.rightTabPane.add((Component)this.responsePanel, RESPONSE_LOG);
        this.rightTabPane.add((Component)this.trapPanel, TRAP_PANEL);
        this.rightTabPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Vector v;
                super.mousePressed(e);
                if (ParosFrame.this.urlList.getSelectedValue() == null) {
                    return;
                }
                String selected = ParosFrame.this.urlList.getSelectedValue().toString();
                selected = selected.substring(0, selected.indexOf(":"));
                if (ParosFrame.this.rightTabPane.getSelectedIndex() == ParosFrame.this.rightTabPane.indexOfTab(ParosFrame.REQUEST_LOG)) {
                    Vector v2 = Global.dumpAnalyzer.searchRequest(selected);
                    if (v2 != null) {
                        ParosFrame.this.requestPanel.setMessage(v2.get(0).toString(), v2.get(1).toString());
                    }
                } else if (ParosFrame.this.rightTabPane.getSelectedIndex() == ParosFrame.this.rightTabPane.indexOfTab(ParosFrame.RESPONSE_LOG) && (v = Global.dumpAnalyzer.searchResponse(selected)) != null) {
                    ParosFrame.this.responsePanel.setMessage(v.get(0).toString(), v.get(1).toString());
                }
            }
        });
        this.rightTabPane.add((Component)new FunctionPanel(Global.filterManager, "Filters are run automatically after being enabled."), FILTER_PANEL);
        this.rightTabPane.add((Component)new FunctionPanel(Global.scanManager, "Select the website(tree) on left and click menu Tree => Scan Selected/All to start."), SCAN_PANEL);
        this.rightTabPane.add((Component)new OptionPanel(), OPTION_PANEL);
        this.urlList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    Vector v;
                    JList list = (JList)evt.getSource();
                    if (list.getModel().getSize() <= 0) {
                        return;
                    }
                    String selected = list.getSelectedValue().toString();
                    selected = selected.substring(0, selected.indexOf(":"));
                    if (ParosFrame.this.requestPanel.isVisible()) {
                        Vector v2 = Global.dumpAnalyzer.searchRequest(selected);
                        if (v2 != null) {
                            ParosFrame.this.requestPanel.setMessage(v2.get(0).toString(), v2.get(1).toString());
                        }
                    } else if (ParosFrame.this.responsePanel.isVisible() && (v = Global.dumpAnalyzer.searchResponse(selected)) != null) {
                        ParosFrame.this.responsePanel.setMessage(v.get(0).toString(), v.get(1).toString());
                    }
                }
            }
        });
        this.contentPane.setEnabled(true);
        this.contentPane.setToolTipText("");
        this.contentPane.add((Component)this.jSplitPane1, "Center");
        this.contentPane.add((Component)this.statusBar, "South");
        this.jSplitPane1.setDividerLocation(280);
        this.jSplitPane2.setDividerLocation(180);
        this.jSplitPane1.addComponentListener(this);
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            System.exit(0);
        } else if (e.getID() == 101) {
            this.componentResized(e);
        }
    }

    public void componentResized(ComponentEvent e) {
        if (e.getComponent() == this.jSplitPane1) {
            if (this.getSize().height - this.old_frame_height > 0) {
                this.jSplitPane1.setDividerLocation(this.getSize().height - (this.old_frame_height - this.jSplitPane1.getDividerLocation()));
            }
            if (this.getSize().height > 200 && this.getSize().height - this.jSplitPane1.getDividerLocation() < 200) {
                this.jSplitPane1.setDividerLocation(this.getSize().height - 200);
            }
        }
        this.old_frame_height = this.getSize().height;
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean packFrame = false;
        ParosFrame frame = new ParosFrame();
        if (packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    public void showPanel(String pane, String label) {
        ParosTabbedPane tabPane = null;
        if (pane.equals(LOG_PANE)) {
            tabPane = this.logPane;
        } else if (pane.equals(RIGHT_PANE)) {
            tabPane = this.rightTabPane;
        }
        int index = tabPane.indexOfTab(label);
        if (index != -1) {
            tabPane.setSelectedIndex(index);
        }
    }

    public void setTree(HttpRequestHeader req, HttpBody body) throws HttpMalformedHeaderException, URISyntaxException {
        this.treePanel.setTree(req, body);
    }

    public void refreshTree() {
        this.treePanel.TreeRefresh();
    }

    public void setTreeNoGUI(String host, String uri) {
        System.out.println("setTreeNoGUI called");
    }

    public void setStatus(final String status) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ParosFrame.this.statusBar.setText(status);
            }
        });
    }

    public void setPanel(final HttpHeader hdr, final HttpBody body, String status, boolean isRequest) {
        if (hdr.isImage()) {
            return;
        }
        if (isRequest && !this.trapPanel.isTrapRequest() && !hdr.isImage()) {
            return;
        }
        if (!(isRequest || this.trapPanel.isTrapResponse() || hdr.isImage())) {
            return;
        }
        Object object = sem;
        synchronized (object) {
            this.trapPanel.setContinue(false);
            this.trapPanel.setMessage(hdr.toString(), body.toString());
            this.toFront();
            while (!this.trapPanel.isContinue()) {
                Util.sleep(100);
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            hdr.setMessage(ParosFrame.this.trapPanel.getHeader());
                            if (body != null) {
                                body.setBody(ParosFrame.this.trapPanel.getBody());
                            }
                            ParosFrame.this.trapPanel.setMessage("", "");
                        }
                        catch (HttpMalformedHeaderException he) {
                            ParosFrame.this.logPane.append(ParosFrame.ERROR_LOG, he.getMessage());
                        }
                        ParosFrame.this.trapPanel.setContinue(false);
                    }
                });
            }
            catch (Exception ie) {
                this.logPane.append(ERROR_LOG, ie.getMessage());
            }
        }
    }

    public void logAppend(String s) {
        this.logPane.append(OUTPUT_LOG, s);
    }

    public void logAppend(String name, String s) {
        this.logPane.append(name, s);
    }

    public void requestLogFocus(String pane) {
        this.logPane.requestLogFocus(pane);
    }

    public void setLogLink(WebLink w) {
        this.webDoc.setHistory(w);
    }

    public Object getLogLink(String host, String s) {
        return this.webDoc.getHistory(host, s);
    }

    public Object getLogLink(String host, String s, String post) {
        return this.webDoc.getHistory(host, s, post);
    }

    public void clearTree() {
        this.treePanel.clearTree();
    }
}

