/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.ui;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.log.OpenFileDialog;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.scan.Report;
import com.proofsecure.paros.scan.ScannerStress;
import com.proofsecure.paros.spider.SpiderGUI;
import com.proofsecure.paros.ui.EncodeDialog;
import com.proofsecure.paros.ui.FindDialog;
import com.proofsecure.paros.ui.MainFrame_AboutBox;
import com.proofsecure.paros.ui.ParosFrame;
import com.proofsecure.paros.util.Util;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ParosMenu
extends JMenuBar {
    private SpiderGUI spider = null;
    private JMenu jMenuFile = new JMenu();
    private JMenuItem jMenuFileExit = new JMenuItem();
    private JMenu jMenuEdit = new JMenu();
    private JMenuItem jMenuEditFind = new JMenuItem();
    private JMenu jMenuView = new JMenu();
    private JMenuItem jMenuSessionDump = new JMenuItem();
    private JMenuItem jMenuSessionDumpFile = new JMenuItem();
    private JMenuItem jMenuSessionDumpClear = new JMenuItem();
    private JMenuItem jMenuViewTrap = new JMenuItem();
    private JMenuItem jMenuViewOptions = new JMenuItem();
    private JMenuItem jMenuViewFilters = new JMenuItem();
    private JMenuItem jMenuViewScan = new JMenuItem();
    private JCheckBoxMenuItem jMenuViewImage = new JCheckBoxMenuItem();
    private JMenu jMenuHelp = new JMenu();
    private JMenuItem jMenuHelpAbout = new JMenuItem();
    private JMenu jMenuScan = new JMenu();
    private JMenuItem jMenuScanSelected = new JMenuItem();
    private JMenuItem jMenuScanAll = new JMenuItem();
    private JMenuItem jMenuScanStress = new JMenuItem();
    private JMenuItem jMenuScanStop = new JMenuItem();
    private JCheckBoxMenuItem jMenuScanSkipNode = new JCheckBoxMenuItem();
    private JMenuItem jMenuScanDeleteTree = new JMenuItem();
    private JMenu jMenuReport = new JMenu();
    private JMenuItem jMenuReportScan = new JMenuItem();
    private JMenu jMenuSession = new JMenu();
    private JMenu jMenuTools = new JMenu();
    private JMenuItem jMenuToolsEnableCert = new JMenuItem();
    private JMenuItem jMenuToolsDisableCert = new JMenuItem();
    private JMenuItem jMenuToolsEncode = new JMenuItem();
    private JMenuItem jMenuToolsSpider = new JMenuItem();
    private JFrame frame;

    public ParosMenu(JFrame f) {
        this.frame = f;
        this.init();
    }

    private void init() {
        this.jMenuFile.setText("File");
        this.jMenuFile.setMnemonic(70);
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.setMnemonic(69);
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jMenuEdit.setText("Edit");
        this.jMenuEdit.setMnemonic(69);
        this.jMenuEditFind.setText("Find...");
        this.jMenuEditFind.setMnemonic(70);
        this.jMenuEditFind.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.jMenuEditFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.jMenuEditFind_actionPerformed(e);
            }
        });
        this.jMenuHelp.setText("Help");
        this.jMenuHelp.setMnemonic(72);
        this.jMenuHelpAbout.setText("About Paros");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.jMenuHelpAbout_actionPerformed(e);
            }
        });
        this.jMenuView.setText("View");
        this.jMenuView.setMnemonic(86);
        this.jMenuViewTrap.setText("Trap");
        this.jMenuViewTrap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.jMenuView_actionPerformed(e);
            }
        });
        this.jMenuViewFilters.setText("Filters");
        this.jMenuViewFilters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.jMenuView_actionPerformed(e);
            }
        });
        this.jMenuViewScan.setText("Scan");
        this.jMenuViewScan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.jMenuView_actionPerformed(e);
            }
        });
        this.jMenuViewOptions.setText("Options");
        this.jMenuViewOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.jMenuView_actionPerformed(e);
            }
        });
        this.jMenuViewImage.setText("Show Image Request in Log");
        this.jMenuViewImage.setState(Global.isViewImage);
        this.jMenuViewImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.jMenuViewImage_actionPerformed(e);
            }
        });
        this.jMenuScan.setText("Tree");
        this.jMenuScan.setMnemonic(82);
        this.jMenuScanSelected.setText("Scan Selected Node");
        this.jMenuScanSelected.setMnemonic(83);
        this.jMenuScanSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Global.parosFrame.requestLogFocus("Output");
                if (Global.treePanel.getSelectedParsedEntity().isRoot()) {
                    ParosMenu.this.scanAll();
                    return;
                }
                if (Global.treePanel.getSelectedParsedEntity() != null) {
                    Global.scanner.startScan(Global.treePanel.getSelectedParsedEntity());
                } else {
                    Util.showMessageDialog("Please select a site or folder.");
                }
            }
        });
        this.jMenuScanAll.setText("Scan All");
        this.jMenuScanAll.setMnemonic(65);
        this.jMenuScanAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Global.parosFrame.requestLogFocus("Output");
                ParosMenu.this.scanAll();
            }
        });
        String ST = "Scan ST One Node";
        this.jMenuScanStress.setText(ST);
        this.jMenuScanStress.setMnemonic(79);
        this.jMenuScanStress.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Global.parosFrame.requestLogFocus("Output");
                if (Global.treePanel.getSelectedParsedEntity() != null) {
                    ParosMenu.this.scanStress(Global.treePanel.getSelectedParsedEntity());
                } else {
                    Util.showMessageDialog("Please select a site or folder.");
                }
            }
        });
        this.jMenuScanStop.setText("Scan Stop");
        this.jMenuScanStop.setMnemonic(83);
        this.jMenuScanStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Global.currentScanner == null || !Global.currentScanner.isStarted()) {
                    Util.showMessageDialog("Scanner not started yet.");
                } else {
                    Global.currentScanner.stopScan();
                }
            }
        });
        this.jMenuScanSkipNode.setText("Mark Node as NOT SCAN");
        this.jMenuScanSkipNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.setMenuScanSkipValue(Global.treePanel.getSelectedParsedEntity(), ParosMenu.this.jMenuScanSkipNode);
            }
        });
        this.jMenuScanDeleteTree.setText("Delete Selected Node");
        this.jMenuScanDeleteTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParsedEntity entity = null;
                ParsedEntity parent = null;
                entity = Global.treePanel.getSelectedParsedEntity();
                if (entity == null) {
                    Util.showMessageDialog("Please select a site or folder.");
                    return;
                }
                parent = (ParsedEntity)entity.getParent();
                if (parent != null) {
                    Global.treePanel.getTreeModel().removeNodeFromParent(entity);
                    Global.treePanel.getTree().setModel(Global.treePanel.getTreeModel());
                }
            }
        });
        this.jMenuReport.setText("Report");
        this.jMenuReport.setMnemonic(82);
        this.jMenuReportScan.setText("Last Scan Alert Report");
        this.jMenuReportScan.setMnemonic(83);
        this.jMenuReportScan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Report.openBrowser(Global.fileReportScan.getAbsolutePath());
            }
        });
        this.jMenuSession.setText("Session");
        this.jMenuSessionDump.setText("Advanced Analyzer (Current session)...");
        this.jMenuSessionDump.setMnemonic(115);
        this.jMenuSessionDump.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.jMenuSessionDump.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.jMenuSessionDump_actionPerformed(e);
            }
        });
        this.jMenuSessionDumpFile.setText("Other session log files...");
        this.jMenuSessionDumpFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.jMenuSessionDumpFile_actionPerformed(e);
            }
        });
        this.jMenuSessionDumpClear.setText("Clear URLs");
        this.jMenuSessionDumpClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(null, "Clear the list?\r\n(this only affects the list display. Messages are still in session file)", "Warning", 0);
                if (answer != 0) {
                    return;
                }
                Global.dumpLog.resetCurDate();
                Global.dumpAnalyzer.refresh();
                Global.urlLog.clear();
            }
        });
        this.jMenuTools.setText("Tools");
        this.jMenuTools.setMnemonic(84);
        this.jMenuToolsEnableCert.setText("Enable client cert...");
        this.jMenuToolsEnableCert.setMnemonic(69);
        this.jMenuToolsEnableCert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.jMenuToolsEnableCert_actionPerformed(e);
            }
        });
        this.jMenuToolsDisableCert.setText("Disable client cert");
        this.jMenuToolsDisableCert.setMnemonic(68);
        this.jMenuToolsDisableCert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParosMenu.this.jMenuToolsDisableCert_actionPerformed(e);
            }
        });
        this.jMenuToolsDisableCert.setEnabled(false);
        this.jMenuToolsEncode.setText("Hash/Encoding...");
        this.jMenuToolsEncode.setMnemonic(67);
        this.jMenuToolsEncode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Global.encodeDialog == null) {
                    Global.encodeDialog = new EncodeDialog((Frame)Global.parosFrame, false);
                    Global.encodeDialog.pack();
                }
                Util.centreChild(ParosMenu.this.frame, Global.encodeDialog);
                Global.encodeDialog.show();
            }
        });
        this.jMenuToolsSpider.setText("Spider...");
        this.jMenuToolsSpider.setMnemonic(80);
        this.jMenuToolsSpider.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ParosMenu.this.spider != null && ParosMenu.this.spider.isAlive()) {
                    return;
                }
                ParosMenu.this.spider = new SpiderGUI();
                if (ParosMenu.this.spider.init()) {
                    Global.parosFrame.requestLogFocus("Output");
                }
                ParosMenu.this.spider.start();
            }
        });
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuEdit.add(this.jMenuEditFind);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuView.add(this.jMenuViewTrap);
        this.jMenuView.add(this.jMenuViewFilters);
        this.jMenuView.add(this.jMenuViewScan);
        this.jMenuView.add(this.jMenuViewOptions);
        this.jMenuView.addSeparator();
        this.jMenuView.add(this.jMenuViewImage);
        this.jMenuScan.add(this.jMenuScanSelected);
        this.jMenuScan.add(this.jMenuScanAll);
        if (Global.isST) {
            this.jMenuScan.add(this.jMenuScanStress);
        }
        this.jMenuScan.add(this.jMenuScanStop);
        this.jMenuScan.addSeparator();
        this.jMenuScan.add(this.jMenuScanSkipNode);
        this.jMenuScan.add(this.jMenuScanDeleteTree);
        this.jMenuReport.add(this.jMenuReportScan);
        if (Global.isDumpLog) {
            this.jMenuSession.add(this.jMenuSessionDump);
            this.jMenuSession.add(this.jMenuSessionDumpFile);
            this.jMenuSession.addSeparator();
            this.jMenuSession.add(this.jMenuSessionDumpClear);
        }
        this.jMenuTools.add(this.jMenuToolsEnableCert);
        this.jMenuTools.add(this.jMenuToolsDisableCert);
        this.jMenuTools.addSeparator();
        this.jMenuTools.add(this.jMenuToolsEncode);
        this.jMenuTools.addSeparator();
        this.jMenuTools.add(this.jMenuToolsSpider);
        this.add(this.jMenuFile);
        this.add(this.jMenuEdit);
        this.add(this.jMenuView);
        this.add(this.jMenuScan);
        if (Global.isReportEnabled) {
            this.add(this.jMenuReport);
        }
        this.add(this.jMenuSession);
        this.add(this.jMenuTools);
        this.add(this.jMenuHelp);
        this.frame.setJMenuBar(this);
    }

    private void jMenuSessionDumpFile_actionPerformed(ActionEvent e) {
        OpenFileDialog d = new OpenFileDialog();
        Util.centreChild(this.frame, d);
        d.show();
    }

    public void jMenuSessionDump_actionPerformed(ActionEvent e) {
        Global.dumpAnalyzer.setCurSession(true);
        Global.dumpAnalyzer.setTitle("Current Session");
        Global.dumpAnalyzer.show();
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    public void jMenuEditFind_actionPerformed(ActionEvent e) {
        FindDialog dialog = Global.findDialog = new FindDialog((Frame)Global.parosFrame, false);
        Util.centreChild(Global.parosFrame, dialog);
        dialog.show();
    }

    public void jMenuView_actionPerformed(ActionEvent e) {
        Component c = (Component)e.getSource();
        if (c instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)c;
            String label = mi.getText();
            ((ParosFrame)this.frame).showPanel("RightPane", label);
        }
    }

    public void jMenuViewImage_actionPerformed(ActionEvent e) {
        Global.isViewImage = !Global.isViewImage;
        this.jMenuViewImage.setState(Global.isViewImage);
    }

    public void jMenuToolsEnableCert_actionPerformed(ActionEvent e) {
        Util.showMessageDialog("Press OK to start choosing client certificate file (PKCS#12).");
        JFileChooser chooser = new JFileChooser();
        int rc = chooser.showOpenDialog(Global.parosFrame);
        if (rc == 0) {
            try {
                File keyFile = chooser.getSelectedFile();
                if (keyFile == null) {
                    return;
                }
                JPasswordField pwd = new JPasswordField("");
                String label = "Please input passphrase for the PKCS#12 certificate:";
                Object[] objArray = new Object[]{label, pwd};
                JOptionPane pane = new JOptionPane(objArray, 3, 2);
                JDialog dialog = pane.createDialog(Global.parosFrame, "Paros 3.1.1 ");
                dialog.show();
                int result = (Integer)pane.getValue();
                if (result != 0) {
                    return;
                }
                char[] passPhrase = pwd.getPassword();
                if (passPhrase == null) {
                    return;
                }
                Global.ssl.setClientCert(keyFile, passPhrase);
                int i = 0;
                while (i < passPhrase.length) {
                    passPhrase[i] = 32;
                    ++i;
                }
                this.jMenuToolsDisableCert.setEnabled(true);
                Global.isUseClientCert = true;
            }
            catch (Exception ex) {
                Util.showMessageDialog("Error reading PKCS#12 certificate.  Please use correct passphrase \r\nand use certificate exported from Netscape.");
                ex.printStackTrace();
            }
        }
    }

    public void jMenuToolsDisableCert_actionPerformed(ActionEvent e) {
        this.jMenuToolsDisableCert.setEnabled(false);
        Global.isUseClientCert = false;
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        MainFrame_AboutBox dlg = new MainFrame_AboutBox(this.frame, true);
        Util.centreChild(this.frame, dlg);
        dlg.pack();
        dlg.show();
    }

    public void setMenuScanSkipValue(ParsedEntity entity, JCheckBoxMenuItem item) {
        if (entity == null) {
            Util.showMessageDialog("Please select a site or URL.");
            return;
        }
        entity.mState = entity.mState == 0 ? 1 : 0;
        item.setState(entity.mState == 1);
    }

    public void setMenuScanSkipDisplay(ParsedEntity entity, JCheckBoxMenuItem item) {
        item.setState(entity.mState == 1);
    }

    public void setMenuScanSkipDisplay(ParsedEntity entity) {
        this.jMenuScanSkipNode.setState(entity.mState == 1);
    }

    public void scanAll() {
        this.scan(Global.treePanel.getRoot());
    }

    public void scan(ParsedEntity entity) {
        Global.scanner.startScan(entity);
    }

    public void scanStress(ParsedEntity entity) {
        JTextField txtCount = new JTextField("10");
        String label = "Please enter repeat count for the ST (adjust optimal threads):";
        Object[] objArray = new Object[]{label, txtCount};
        JOptionPane pane = new JOptionPane(objArray, 3, 2);
        JDialog dialog = pane.createDialog(Global.parosFrame, "Paros 3.1.1 ");
        dialog.show();
        int result = (Integer)pane.getValue();
        if (result != 0) {
            return;
        }
        try {
            int count = Integer.parseInt(txtCount.getText());
            ScannerStress scanner = new ScannerStress();
            scanner.setCount(count);
            scanner.startScan(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

