/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.ui;

import com.proofsecure.paros.ui.ParosSplitPane;
import com.proofsecure.paros.ui.PopupPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class TrapPanel
extends JPanel {
    private static final String TRAPVIEW_TABULAR = "Tabular View";
    private static final String TRAPVIEW_ORIGINAL = "Original View";
    private Pattern pSeparator = Pattern.compile("([^=&]+)[=]([^=&]*)");
    private Matcher matcher2;
    private PostTableModel myPostModel = null;
    private boolean isContinue = false;
    private JSplitPane jSplitPane5 = new JSplitPane();
    private ParosSplitPane jSplitPane4 = new ParosSplitPane();
    private JScrollPane jScrollPane4 = new JScrollPane();
    private JScrollPane jScrollPane5 = new JScrollPane();
    private JPanel jPanel4 = new JPanel();
    private JTextArea txtHeader = new JTextArea();
    private JTextArea txtBody = new JTextArea();
    private JTable jTable2 = new JTable();
    private JScrollPane jScrollPane8 = new JScrollPane();
    private JScrollPane jScrollPane9 = new JScrollPane();
    private Box box1;
    private JButton jButton4 = new JButton();
    private JLabel jLabel9 = new JLabel();
    private JLabel jLabel10 = new JLabel();
    private JCheckBox TrapReq = new JCheckBox();
    private JCheckBox TrapResp = new JCheckBox();
    private JLabel jLabel11 = new JLabel();
    private JButton TrapView = new JButton();

    public TrapPanel() {
        this.init();
    }

    private void init() {
        this.box1 = Box.createHorizontalBox();
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.activeCaptionBorder);
        this.jPanel4.setLayout(new BorderLayout());
        this.jSplitPane4.setOrientation(0);
        this.jSplitPane4.setDividerSize(3);
        this.jScrollPane8.getViewport().add((Component)this.jTable2, null);
        this.jSplitPane5.add((Component)this.jPanel4, "left");
        this.jSplitPane5.add((Component)this.jScrollPane8, "right");
        this.jSplitPane5.setDividerSize(0);
        this.add((Component)this.jSplitPane5, "Center");
        this.add((Component)this.jScrollPane9, "South");
        this.jLabel9.setText("  ");
        this.jLabel10.setText("        ");
        this.TrapReq.setText("Trap Request");
        this.TrapResp.setText("Trap Response");
        this.jLabel11.setText("   ");
        this.TrapView.setText(TRAPVIEW_TABULAR);
        this.TrapView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TrapPanel.this.TrapView_actionPerformed(e);
            }
        });
        this.jScrollPane9.setVerticalScrollBarPolicy(21);
        this.jScrollPane9.setHorizontalScrollBarPolicy(31);
        this.jScrollPane9.getViewport().add((Component)this.box1, null);
        this.jButton4.setText("Continue");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TrapPanel.this.jButton4_actionPerformed(e);
            }
        });
        this.box1.add((Component)this.TrapReq, null);
        this.box1.add((Component)this.jLabel10, null);
        this.box1.add((Component)this.TrapResp, null);
        this.box1.add((Component)this.jLabel11, null);
        this.box1.add((Component)this.jButton4, null);
        this.box1.add((Component)this.jLabel9, null);
        this.box1.add((Component)this.TrapView, null);
        this.jPanel4.add((Component)this.jSplitPane4.getJSplitPaneHeader(), "West");
        this.jPanel4.add((Component)this.jSplitPane4, "Center");
        this.jSplitPane4.add((Component)this.jScrollPane4, "top");
        this.jSplitPane4.add((Component)this.jScrollPane5, "bottom");
        this.txtHeader.setLineWrap(true);
        this.txtBody.setLineWrap(true);
        this.jScrollPane5.getViewport().add((Component)this.txtBody, null);
        this.jScrollPane4.getViewport().add((Component)this.txtHeader, null);
        this.myPostModel = new PostTableModel();
        this.jTable2.setModel(this.myPostModel);
        this.jScrollPane8.setVisible(false);
        this.txtHeader.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    PopupPanel pp = new PopupPanel(TrapPanel.this.txtHeader);
                    pp.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                } else {
                    super.mousePressed(e);
                }
            }
        });
        this.txtBody.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    PopupPanel pp = new PopupPanel(TrapPanel.this.txtBody);
                    pp.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                } else {
                    super.mousePressed(e);
                }
            }
        });
    }

    public boolean isContinue() {
        return this.isContinue;
    }

    public void setContinue(boolean s) {
        this.isContinue = s;
    }

    public boolean isTrapRequest() {
        return this.TrapReq.isSelected();
    }

    public boolean isTrapResponse() {
        return this.TrapResp.isSelected();
    }

    public String getHeader() {
        String result = this.txtHeader.getText().replaceAll("\\n", "\r\n");
        result = String.valueOf(result.replaceAll("(\\r\\n)*\\z", "")) + "\r\n\r\n";
        return result;
    }

    public String getBody() {
        return this.txtBody.getText();
    }

    public void setMessage(final String header, final String body) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TrapPanel.this.txtHeader.setText(header.replaceAll("\\r\\n", "\n"));
                TrapPanel.this.txtHeader.setCaretPosition(0);
                if (body == null) {
                    TrapPanel.this.txtBody.setEnabled(false);
                } else {
                    TrapPanel.this.txtBody.setEnabled(true);
                    TrapPanel.this.txtBody.setText(body);
                    TrapPanel.this.txtBody.setCaretPosition(0);
                }
            }
        });
    }

    void jButton4_actionPerformed(ActionEvent e) {
        this.isContinue = true;
    }

    void TrapView_actionPerformed(ActionEvent e) {
        String subStr = "";
        String subStr2 = "";
        try {
            if (this.TrapView.getText().trim().equals(TRAPVIEW_ORIGINAL)) {
                int row = 0;
                String pb = "";
                while (row < 80 && !this.myPostModel.getValueAt(row, 0).equals("")) {
                    if (row != 0) {
                        pb = String.valueOf(pb) + "&";
                    }
                    pb = String.valueOf(pb) + URLEncoder.encode((String)this.myPostModel.getValueAt(row, 0), "UTF8") + "=" + URLEncoder.encode((String)this.myPostModel.getValueAt(row, 1), "UTF8");
                    ++row;
                }
                String pb2 = pb;
                this.TrapView.setText(TRAPVIEW_TABULAR);
                this.txtBody.setText(pb2);
                this.jScrollPane8.setVisible(false);
                this.jSplitPane5.setDividerLocation(450);
                this.jSplitPane4.getJSplitPaneHeader().setVisible(true);
                this.TrapReq.setEnabled(true);
                this.TrapResp.setEnabled(true);
                this.jButton4.setEnabled(true);
                return;
            }
            String param = this.txtBody.getText().trim();
            if (this.TrapReq.isSelected() && param != null && !param.equals("")) {
                boolean end = false;
                boolean start = false;
                int row = 0;
                boolean col = false;
                while (row < 80) {
                    this.myPostModel.setValueAt("", row, 0);
                    this.myPostModel.setValueAt("", row, 1);
                    ++row;
                }
                this.jSplitPane5.setDividerLocation(0);
                this.jSplitPane4.getJSplitPaneHeader().setVisible(false);
                this.jScrollPane8.setVisible(true);
                this.TrapReq.setEnabled(false);
                this.TrapResp.setEnabled(false);
                this.jButton4.setEnabled(false);
                row = 0;
                this.matcher2 = this.pSeparator.matcher(param);
                while (row < 80 && this.matcher2.find()) {
                    this.myPostModel.setValueAt(URLDecoder.decode(this.matcher2.group(1), "8859_1"), row, 0);
                    this.myPostModel.setValueAt(URLDecoder.decode(this.matcher2.group(2), "8859_1"), row, 1);
                    ++row;
                }
                if (row >= 80) {
                    System.out.println("Too many parameters in the POST query!");
                }
                this.TrapView.setText(TRAPVIEW_ORIGINAL);
                return;
            }
        }
        catch (Exception e4) {
            System.out.println(e4.getMessage());
            e4.printStackTrace();
            return;
        }
    }

    class PostTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Element", "Value"};
        private Object[][] data = new Object[][]{{"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}};

        PostTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 1 && row < 80;
        }

        public void setValueAt(Object value, int row, int col) {
            boolean DEBUG = false;
            if (DEBUG) {
                System.out.println("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
            }
            if (value == null) {
                value = "";
            }
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
            if (DEBUG) {
                System.out.println("New value of data:");
                this.printDebugData();
            }
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            int i = 0;
            while (i < numRows) {
                System.out.print("    row " + i + ":");
                int j = 0;
                while (j < numCols) {
                    System.out.print("  " + this.data[i][j]);
                    ++j;
                }
                System.out.println();
                ++i;
            }
            System.out.println("--------------------------");
        }
    }
}

